/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.io.Serializable;

public abstract class ItemDescriptors
implements Serializable {
    protected String type;
    private static final String NOT_SUPPORTED = "?";
    public static final String UNKNOWN_TYPE = "?";
    public static final String MP3_TYPE = "mp3";
    public static final String OGG_TYPE = "ogg";

    public ItemDescriptors(File file) {
        this.setup(file);
    }

    protected boolean setup(File file) {
        String[] supp = this.getFileTypes();
        if (supp != null && supp.length > 0) {
            String name = file.getName().toLowerCase();
            for (String type : supp) {
                if (!name.endsWith(type)) continue;
                this.type = type;
                return true;
            }
            this.type = "?";
            return false;
        }
        return true;
    }

    public String getType() {
        return this.type;
    }

    public boolean isValid() {
        return !this.isInsufficient() && !this.isNotSupported();
    }

    public boolean isInsufficient() {
        return false;
    }

    public boolean isNotSupported() {
        return this.type == null || "?".equals(this.type);
    }

    public abstract String[] getFileTypes();

    public static String fileTypesAsString(String[] types) {
        boolean first = true;
        StringBuffer b = new StringBuffer();
        for (String s : types) {
            if (!first) {
                b.append(", ");
            }
            b.append(s);
            first = false;
        }
        return b.toString();
    }
}

