/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import com.wallyflint.one_point_one.collections.TernarySearchTreeModified;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import tigor.srdmusicduplicates.logic.DataDescriptors;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.SoundDescriptors;
import tigor.srdmusicduplicates.logic.Strategy;
import tigor.srdmusicduplicates.logic.TagDescriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternPlant {
    private Map<DataDescriptors, Item> dataPatterns;
    private Map<Tag, TernarySearchTreeModified> tagPatterns;

    public PatternPlant(int initialCapacity) {
        this.dataPatterns = new HashMap<DataDescriptors, Item>(initialCapacity);
        this.tagPatterns = new HashMap<Tag, TernarySearchTreeModified>();
    }

    public void clear() {
        this.dataPatterns.clear();
        this.tagPatterns.clear();
    }

    public Item match(DataDescriptors desc) {
        return this.dataPatterns != null ? this.dataPatterns.get(desc) : null;
    }

    public Set<Item> match(TagDescriptors desc, Strategy strategy, boolean firstMatchFound) {
        return strategy.matchTagDescriptors(desc, this, firstMatchFound);
    }

    public Set<Item> match(SoundDescriptors desc, Strategy strategy, boolean firstMatchFound) {
        return null;
    }

    public Set<Item> get(Tag tag, String key) {
        return (Set)this.getTree(tag).get(key);
    }

    public void put(DataDescriptors key, Item item) {
        this.dataPatterns.put(key, item);
    }

    public void put(SoundDescriptors key, Item item) {
    }

    public void put(TagDescriptors desc, Item item) {
        String key;
        String albumKey = desc.getAlbum();
        String artistKey = desc.getArtist();
        if (albumKey != null) {
            this.put(Tag.album, albumKey, item);
        }
        if (artistKey != null) {
            this.put(Tag.artist, artistKey, item);
        }
        if (albumKey != null && artistKey != null) {
            this.put(Tag.albumOfArtis, albumKey + "." + artistKey, item);
        }
        if ((key = desc.getTitle()) != null) {
            this.put(Tag.title, key, item);
        }
        if ((key = desc.getFileName()) != null) {
            this.put(Tag.filename, key, item);
        }
        if ((key = desc.getFolderName()) != null) {
            this.put(Tag.foldername, key, item);
        }
    }

    public void put(Tag tag, String key, Item pattern) {
        TernarySearchTreeModified tree = this.getTree(tag);
        HashSet<Item> set = (HashSet<Item>)tree.get(key);
        if (set == null) {
            set = new HashSet<Item>();
            tree.put(key, set);
        }
        set.add(pattern);
    }

    public Set<Item> getIntersection(Tag[] tags, String[] keys, int maxDepth, int minLen, double minLengthSimilarity) {
        HashSet<Item> intersection = null;
        for (int i = 0; i < tags.length; ++i) {
            String key;
            TernarySearchTreeModified tree = this.getTree(tags[i]);
            Set<Item> items = this.getSimilar(tree, key = keys[i], maxDepth, minLengthSimilarity);
            if (items != null) {
                if (intersection == null) {
                    intersection = new HashSet<Item>(items);
                    continue;
                }
                Strategy.doIntersection(intersection, items);
                continue;
            }
            return null;
        }
        return intersection;
    }

    public Set<Item> getSimilar(Tag tag, String key, int maxDepth, int minLen, double minLengthSimilarity) {
        if (key.length() < minLen) {
            return (Set)this.getTree(tag).get(key);
        }
        return this.getSimilar(this.getTree(tag), key, maxDepth, minLengthSimilarity);
    }

    public Set<Item> getSimilar(TernarySearchTreeModified tree, String key, int maxDepth, double minLengthSimilarity) {
        if (minLengthSimilarity >= 1.0) {
            return (Set)tree.get(key);
        }
        LinkedList list = tree.matchDeep(key, maxDepth, minLengthSimilarity);
        if (list.size() == 0) {
            return null;
        }
        HashSet<Item> result = new HashSet<Item>();
        for (Set items : list) {
            result.addAll(items);
        }
        return result;
    }

    private TernarySearchTreeModified getTree(Tag tag) {
        TernarySearchTreeModified tree = this.tagPatterns.get((Object)tag);
        if (tree == null) {
            tree = new TernarySearchTreeModified();
            this.tagPatterns.put(tag, tree);
        }
        return tree;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        artist,
        album,
        albumOfArtis,
        filename,
        foldername,
        title;

    }
}

