/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import tigor.srdmusicduplicates.common.Release;
import tigor.srdmusicduplicates.logic.DuplicateMover;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.ui.ItemRow;

public class Session {
    private boolean useXStream = false;
    public static final String FILE_TYPE = "srd_dups";

    public boolean isUseXStream() {
        return this.useXStream;
    }

    public void setUseXStream(boolean useXStream) {
        this.useXStream = useXStream;
    }

    public String getFileType() {
        return this.getFileType(this.useXStream);
    }

    public String getFileType(boolean useXStream) {
        return FILE_TYPE + (useXStream ? ".xml" : "");
    }

    public String getFileDesciption() {
        return this.getFileDesciption(this.useXStream);
    }

    public String getFileDesciption(boolean useXStream) {
        return "*." + this.getFileType() + (useXStream ? ".xml" : "");
    }

    public File addFileExtension(File file) {
        return this.addFileExtension(file, this.useXStream);
    }

    public File addFileExtension(File file, boolean useXStream) {
        String name = file.getName();
        name = name + (!name.endsWith(this.getFileType(useXStream)) ? "." + this.getFileType(useXStream) : "");
        return new File(file.getParentFile(), name);
    }

    public Record deserializeFromFile(File file) throws IOException, ClassNotFoundException {
        return this.deserializeFromFile(file, this.useXStream);
    }

    private Record deserializeFromFile(File file, boolean useXStream) throws IOException, ClassNotFoundException {
        if (!file.canRead()) {
            throw new IOException("Can't read file: " + file);
        }
        return useXStream ? this.deserializeFromXMLFile(file) : this.deserializeFromObjectFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record deserializeFromObjectFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(file);
        try {
            Record record;
            ObjectInputStream in = new ObjectInputStream(is);
            try {
                record = (Record)in.readObject();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return record;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record deserializeFromXMLFile(File file) throws IOException, ClassNotFoundException {
        FileReader fr = new FileReader(file);
        try {
            Record record;
            XStream xstream = new XStream();
            ObjectInputStream in = xstream.createObjectInputStream(fr);
            try {
                record = (Record)in.readObject();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return record;
        }
        finally {
            fr.close();
        }
    }

    public void serializeToFile(Record record, File toFile) throws IOException {
        this.serializeToFile(record, toFile, this.useXStream);
    }

    public void serializeToFile(Record record, File toFile, boolean useXStream) throws IOException {
        File file = this.addFileExtension(toFile);
        if (!file.exists()) {
            if (useXStream) {
                this.serializeToXMLFile(toFile, record);
            } else {
                this.serializeToObjectFile(toFile, record);
            }
        } else {
            throw new IOException("File already exists: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeToObjectFile(File toFile, Record record) throws IOException {
        FileOutputStream fo = new FileOutputStream(toFile);
        try {
            ObjectOutputStream out = new ObjectOutputStream(fo);
            try {
                out.writeObject(record);
            }
            finally {
                out.close();
            }
        }
        finally {
            fo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeToXMLFile(File toFile, Record record) throws IOException {
        FileWriter fw = new FileWriter(toFile);
        try {
            XStream xstream = new XStream();
            ObjectOutputStream out = xstream.createObjectOutputStream(fw);
            try {
                out.writeObject(record);
            }
            finally {
                out.close();
            }
        }
        finally {
            fw.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Serializable {
        private List<Root> roots;
        private Set<Item> items;
        private DuplicateMover mover;
        private List<ItemRow> rowsModifiedByUser;
        private Release release;
        private Date creationDatetime;

        public Record(List<Root> roots, Set<Item> items, DuplicateMover mover, List<ItemRow> rowsSelectedByUser) {
            this.roots = roots;
            this.items = items;
            this.mover = mover;
            this.rowsModifiedByUser = rowsSelectedByUser;
            this.release = new Release();
            this.creationDatetime = new Date();
        }

        public DuplicateMover getMover() {
            return this.mover;
        }

        public Release getVersion() {
            return this.release;
        }

        public Date getCreationDatetime() {
            return this.creationDatetime;
        }

        public List<ItemRow> getRowsModifiedByUser() {
            return this.rowsModifiedByUser;
        }

        public List<Root> getRoots() {
            return this.roots;
        }

        public Set<Item> getItems() {
            return this.items;
        }

        public String toString() {
            return "Record{roots=" + this.roots + ", items=" + this.items + ", mover=" + this.mover + ", rowsModifiedByUser=" + this.rowsModifiedByUser + ", version=" + this.release + ", creationDatetime=" + this.creationDatetime + "}";
        }
    }
}

