/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.PatternPlant;
import tigor.srdmusicduplicates.logic.TagDescriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strategy
implements Serializable {
    private boolean compareData;
    private boolean compareStrictTags;
    private boolean compareLessStrictTags;
    private boolean compareLooseTags;
    private boolean compareSound;
    private boolean preferVBR;
    private boolean preferMp3;
    private boolean preferOgg;
    private boolean preferBiggerFile;
    private boolean preferSmallerFile;
    private boolean preferBitrate;
    private boolean preferLongerTime;
    private int preferredBitrate;
    private Set<Item> lastTagMatch = new HashSet<Item>(100);
    private static final int BETTER_Q = -1;
    private static final int WORSE_Q = 1;
    private static final int SAME_Q = 0;
    public static final int[] BITRATE_INT_ARRAY = new int[]{10000, 320, 256, 192, 160, 128, 1};
    public static final Object[] BITRATE_DESC_ARRRAY = new Object[]{"greater bitrate", "gravity 320Kb/s", "gravity 256Kb/s", "gravity 192Kb/s", "gravity 160Kb/s", "gravity 128Kb/s", "lesser bitrate"};
    private static final String version = "1.0";
    private static final Log log = LogFactory.getLog(Strategy.class);
    private static final double MIN_LEN_SIMILARITY = 0.6;
    private static final int LOOSE_MIN_LEN = 1;
    private static final int MIN_LEN = 3;
    private static final int MAX_DEPTH = 1;
    private static final int MAX_REPLACEMENTS = 1;

    public static Strategy defaultStrategy() {
        Strategy q = new Strategy();
        q.setCompareData(true);
        q.setCompareStrictTags(true);
        q.setPreferBitrate(true);
        q.setPreferredBitrate(BITRATE_INT_ARRAY[0]);
        q.setPreferVBR(true);
        return q;
    }

    public static Strategy readFromPreferneces(PersistentPreferences preferences) {
        try {
            return (Strategy)preferences.get(Strategy.getPreferencesKey());
        }
        catch (Exception e) {
            log.error(Strategy.getPreferencesKey(), e);
            preferences.remove(Strategy.getPreferencesKey());
            return null;
        }
    }

    public String toString() {
        return "Quality{compareData=" + this.compareData + ", compareStrictTags=" + this.compareStrictTags + ", compareNormalTags=" + this.compareLessStrictTags + ", compareLooseTags=" + this.compareLooseTags + ", compareSound=" + this.compareSound + ", preferVBR=" + this.preferVBR + ", preferMp3=" + this.preferMp3 + ", preferOgg=" + this.preferOgg + ", preferBiggerFile=" + this.preferBiggerFile + ", preferSmallerFile=" + this.preferSmallerFile + ", preferBitrate=" + this.preferBitrate + ", preferLongerTime=" + this.preferLongerTime + ", preferredBitrate=" + this.preferredBitrate + "}";
    }

    public String getDescription() {
        String prefix;
        StringBuffer compare = new StringBuffer();
        if (this.compareData) {
            compare.append("data");
        }
        String string = prefix = compare.length() > 0 ? ", " : "";
        if (this.compareStrictTags) {
            compare.append(prefix + "strict tags");
        }
        if (prefix == "") {
            String string2 = prefix = compare.length() > 0 ? ", " : "";
        }
        if (this.compareLessStrictTags) {
            compare.append(prefix + "less strict tags");
        }
        if (prefix == "") {
            String string3 = prefix = compare.length() > 0 ? ", " : "";
        }
        if (this.compareLooseTags) {
            compare.append(prefix + "loose tags");
        }
        StringBuffer prefer = new StringBuffer();
        if (this.preferMp3) {
            prefer.append("mp3");
        }
        String string4 = prefix = prefer.length() > 0 ? ", " : "";
        if (this.preferOgg) {
            prefer.append(prefix + "ogg");
        }
        if (prefix == "") {
            String string5 = prefix = prefer.length() > 0 ? ", " : "";
        }
        if (this.preferVBR && this.isCompareTags() && !this.preferBiggerFile && !this.preferSmallerFile) {
            prefer.append(prefix + "vbr");
        }
        if (prefix == "") {
            String string6 = prefix = prefer.length() > 0 ? ", " : "";
        }
        if (this.preferBiggerFile) {
            prefer.append(prefix + "bigger file");
        }
        if (prefix == "") {
            String string7 = prefix = prefer.length() > 0 ? ", " : "";
        }
        if (this.preferSmallerFile) {
            prefer.append(prefix + "smaller file");
        }
        if (prefix == "") {
            String string8 = prefix = prefer.length() > 0 ? ", " : "";
        }
        if (this.preferBitrate) {
            prefer.append(prefix + BITRATE_DESC_ARRRAY[Strategy.indexOfBitrate(this.preferredBitrate)] + "/longer time");
        }
        if (prefix == "") {
            String string9 = prefix = prefer.length() > 0 ? ", " : "";
        }
        if (this.preferLongerTime) {
            prefer.append(prefix + "longer time/" + BITRATE_DESC_ARRRAY[Strategy.indexOfBitrate(this.preferredBitrate)]);
        }
        return "MATCH DUPLICATES STRATEGY: " + compare + ". KEEP FILE CRITERION: " + prefer + ".";
    }

    public void writeToPreferences(PersistentPreferences preferences) {
        preferences.put(Strategy.getPreferencesKey(), this);
    }

    public void removeFromPreferences(PersistentPreferences preferences) {
        preferences.remove(Strategy.getPreferencesKey());
    }

    public static String getVersion() {
        return version;
    }

    public static String getPreferencesKey() {
        return "strategy-" + Strategy.getVersion();
    }

    public static int indexOfBitrate(int bitrate) {
        for (int i = 0; i < BITRATE_INT_ARRAY.length; ++i) {
            if (BITRATE_INT_ARRAY[i] != bitrate) continue;
            return i;
        }
        return 0;
    }

    public boolean isCompareTags() {
        return this.compareStrictTags || this.compareLessStrictTags || this.compareLooseTags;
    }

    public boolean isCompareData() {
        return this.compareData;
    }

    public void setCompareData(boolean compareData) {
        this.compareData = compareData;
    }

    public boolean isCompareLessStrictTags() {
        return this.compareLessStrictTags;
    }

    public void setCompareLessStrictTags(boolean compareLessStrictTags) {
        this.compareLessStrictTags = compareLessStrictTags;
    }

    public boolean isCompareStrictTags() {
        return this.compareStrictTags;
    }

    public void setCompareStrictTags(boolean compareStrictTags) {
        this.compareStrictTags = compareStrictTags;
    }

    public boolean isCompareLooseTags() {
        return this.compareLooseTags;
    }

    public void setCompareLooseTags(boolean compareLooseTags) {
        this.compareLooseTags = compareLooseTags;
    }

    public boolean isCompareSound() {
        return this.compareSound;
    }

    public void setCompareSound(boolean compareSound) {
        this.compareSound = compareSound;
    }

    public boolean isPreferVBR() {
        return this.preferVBR;
    }

    public void setPreferVBR(boolean preferVBR) {
        this.preferVBR = preferVBR;
    }

    public boolean isPreferMp3() {
        return this.preferMp3;
    }

    public void setPreferMp3(boolean preferMp3) {
        this.preferMp3 = preferMp3;
    }

    public boolean isPreferOgg() {
        return this.preferOgg;
    }

    public void setPreferOgg(boolean preferOgg) {
        this.preferOgg = preferOgg;
    }

    public boolean isPreferBiggerFile() {
        return this.preferBiggerFile;
    }

    public void setPreferBiggerFile(boolean preferBiggerFile) {
        this.preferBiggerFile = preferBiggerFile;
    }

    public boolean isPreferSmallerFile() {
        return this.preferSmallerFile;
    }

    public void setPreferSmallerFile(boolean preferSmallerFile) {
        this.preferSmallerFile = preferSmallerFile;
    }

    public boolean isPreferBitrate() {
        return this.preferBitrate;
    }

    public void setPreferBitrate(boolean preferBitrate) {
        this.preferBitrate = preferBitrate;
    }

    public boolean isPreferLongerTime() {
        return this.preferLongerTime;
    }

    public void setPreferLongerTime(boolean preferLongerTime) {
        this.preferLongerTime = preferLongerTime;
    }

    public int getPreferredBitrate() {
        return this.preferredBitrate;
    }

    public void setPreferredBitrate(int preferredBitrate) {
        this.preferredBitrate = preferredBitrate;
    }

    public Set<Item> compareStrictTags(TagDescriptors desc, PatternPlant patternPlant, boolean firstMatchFound) {
        this.lastTagMatch.clear();
        String album = desc.getAlbum();
        if (album == null) {
            return null;
        }
        String artist = desc.getArtist();
        if (artist == null) {
            return null;
        }
        Set<Item> patterns = patternPlant.get(PatternPlant.Tag.albumOfArtis, album + "." + artist);
        if (patterns == null) {
            return null;
        }
        int track = desc.getTrack();
        for (Item pattern : patterns) {
            String filename;
            String title;
            TagDescriptors pDesc = pattern.getTagDescriptors();
            int pTrack = pDesc.getTrack();
            if (track > 0 && pTrack > 0) {
                if (pDesc.getTrack() != track) continue;
                title = desc.getTitle();
                filename = desc.getFileName();
                if ((title == null || !this.compareToken(title, pDesc.getTitle(), true)) && (filename == null || !this.compareToken(filename, pDesc.getFileName(), true))) continue;
                this.lastTagMatch.add(pattern);
                if (!firstMatchFound) continue;
                return this.lastTagMatch;
            }
            title = desc.getTitle();
            filename = desc.getFileName();
            if ((title == null || !this.compareToken(title, pDesc.getTitle(), false)) && (filename == null || !this.compareToken(filename, pDesc.getFileName(), false))) continue;
            this.lastTagMatch.add(pattern);
            if (!firstMatchFound) continue;
            return this.lastTagMatch;
        }
        return this.lastTagMatch;
    }

    public Set<Item> compareLessStrictTags(TagDescriptors desc, PatternPlant patternPlant, boolean firstMatchFound) {
        this.lastTagMatch.clear();
        String album = desc.getAlbum();
        if (album == null) {
            return null;
        }
        String artist = desc.getArtist();
        if (artist == null) {
            return null;
        }
        Set<Item> patterns = patternPlant.getIntersection(new PatternPlant.Tag[]{PatternPlant.Tag.album, PatternPlant.Tag.artist}, new String[]{album, artist}, 1, 3, 0.6);
        if (patterns == null) {
            return null;
        }
        int track = desc.getTrack();
        for (Item pattern : patterns) {
            String filename;
            String title;
            TagDescriptors pDesc = pattern.getTagDescriptors();
            int pTrack = pDesc.getTrack();
            if (track > 0 && pTrack > 0) {
                if (pDesc.getTrack() != track) {
                    title = desc.getTitle();
                    filename = desc.getFileName();
                    if (title == null || !this.compareToken(title, pDesc.getTitle(), true) || filename == null || this.compareToken(filename, pDesc.getFileName(), true)) continue;
                    continue;
                }
                title = desc.getTitle();
                filename = desc.getFileName();
                if ((title == null || !this.compareToken(title, pDesc.getTitle(), true)) && (filename == null || !this.compareToken(filename, pDesc.getFileName(), true))) continue;
                this.lastTagMatch.add(pattern);
                if (!firstMatchFound) continue;
                return this.lastTagMatch;
            }
            title = desc.getTitle();
            filename = desc.getFileName();
            if ((title == null || !this.compareToken(title, pDesc.getTitle(), true)) && (filename == null || !this.compareToken(filename, pDesc.getFileName(), true))) continue;
            this.lastTagMatch.add(pattern);
            if (!firstMatchFound) continue;
            return this.lastTagMatch;
        }
        return this.lastTagMatch;
    }

    public Set<Item> compareLooseTags(TagDescriptors desc, PatternPlant patternPlant, boolean firstMatchFound) {
        Set<Item> union;
        String folder;
        String artist;
        this.lastTagMatch.clear();
        this.compareLessStrictTags(desc, patternPlant, firstMatchFound);
        if (this.lastTagMatch.size() > 0 && firstMatchFound) {
            return this.lastTagMatch;
        }
        Set<Item> albums = null;
        Set<Item> artists = null;
        Set<Item> folders = null;
        String album = desc.getAlbum();
        if (album != null) {
            albums = patternPlant.getSimilar(PatternPlant.Tag.album, album, 1, 1, 0.6);
        }
        if ((artist = desc.getArtist()) != null) {
            artists = patternPlant.getSimilar(PatternPlant.Tag.artist, artist, 1, 1, 0.6);
        }
        if ((folder = desc.getFolderName()) != null) {
            folders = patternPlant.getSimilar(PatternPlant.Tag.foldername, folder, 1, 1, 0.6);
        }
        if (!(albums != null && albums.size() != 0 || artists != null && artists.size() != 0 || folders != null && folders.size() != 0)) {
            return null;
        }
        Set<Item> filenames = null;
        String filename = desc.getFileName();
        if (filename != null) {
            filenames = patternPlant.getSimilar(PatternPlant.Tag.filename, filename, 1, 1, 0.6);
        }
        Set<Item> titles = null;
        String title = desc.getTitle();
        if (title != null) {
            titles = patternPlant.getSimilar(PatternPlant.Tag.title, title, 1, 1, 0.6);
        }
        HashSet<Item> sub = new HashSet<Item>();
        if (filenames != null) {
            sub.addAll(filenames);
        }
        if (titles != null) {
            int track = desc.getTrack();
            for (Item item : titles) {
                if (track != item.getTagDescriptors().getTrack() && track > 0 && item.getTagDescriptors().getTrack() > 0) continue;
                sub.add(item);
            }
        }
        if (albums != null) {
            Strategy.doIntersection(albums, sub);
            this.lastTagMatch.addAll(albums);
            if (firstMatchFound && this.lastTagMatch.size() > 0) {
                return this.lastTagMatch;
            }
        }
        Set<Item> set = artists != null ? artists : (union = folders != null ? folders : null);
        if (union != null && artists != null && folders != null) {
            union.addAll(folders);
        }
        if (union != null) {
            Strategy.doIntersection(union, sub);
            this.lastTagMatch.addAll(union);
        }
        return this.lastTagMatch;
    }

    public Set<Item> matchTagDescriptors(TagDescriptors desc, PatternPlant patternPlant, boolean firstMatchFound) {
        try {
            if (this.compareStrictTags) {
                return this.compareStrictTags(desc, patternPlant, firstMatchFound);
            }
            if (this.compareLessStrictTags) {
                return this.compareLessStrictTags(desc, patternPlant, firstMatchFound);
            }
            if (this.compareLooseTags) {
                return this.compareLooseTags(desc, patternPlant, firstMatchFound);
            }
        }
        catch (Throwable e) {
            log.error("desc=" + desc, e);
        }
        return null;
    }

    public int compareItems(Item i1, Item i2) {
        double pathQ2;
        if (i1.isFileLocked() && !i2.isFileLocked()) {
            return -1;
        }
        if (!i1.isFileLocked() && i2.isFileLocked()) {
            return 1;
        }
        if (this.preferMp3 || this.preferOgg) {
            int typeQ2;
            int typeQ1 = this.typeQuality(i1);
            if (typeQ1 > (typeQ2 = this.typeQuality(i2))) {
                return -1;
            }
            if (typeQ1 < typeQ2) {
                return 1;
            }
        }
        if (this.preferBiggerFile) {
            if (i1.getContentLength() > i2.getContentLength()) {
                return -1;
            }
            if (i1.getContentLength() < i2.getContentLength()) {
                return 1;
            }
        } else if (this.preferSmallerFile) {
            if (i1.getContentLength() < i2.getContentLength()) {
                return -1;
            }
            if (i1.getContentLength() > i2.getContentLength()) {
                return 1;
            }
        }
        if (this.preferBitrate) {
            double timeQ2;
            double bitrateQ2;
            double bitrateQ1 = this.bitrateQuality(i1);
            if (bitrateQ1 > (bitrateQ2 = this.bitrateQuality(i2))) {
                return -1;
            }
            if (bitrateQ1 < bitrateQ2) {
                return 1;
            }
            double timeQ1 = this.timeQuality(i1);
            if (timeQ1 > (timeQ2 = this.timeQuality(i2))) {
                return -1;
            }
            if (timeQ1 < timeQ2) {
                return 1;
            }
        } else if (this.preferLongerTime) {
            double bitrateQ2;
            double timeQ2;
            double timeQ1 = this.timeQuality(i1);
            if (timeQ1 > (timeQ2 = this.timeQuality(i2))) {
                return -1;
            }
            if (timeQ1 < timeQ2) {
                return 1;
            }
            double bitrateQ1 = this.bitrateQuality(i1);
            if (bitrateQ1 > (bitrateQ2 = this.bitrateQuality(i2))) {
                return -1;
            }
            if (bitrateQ1 < bitrateQ2) {
                return 1;
            }
        }
        if (i1.getContentLength() > i2.getContentLength()) {
            return -1;
        }
        if (i1.getContentLength() < i2.getContentLength()) {
            return 1;
        }
        double pathQ1 = this.pathQuality(i1);
        if (pathQ1 > (pathQ2 = this.pathQuality(i2))) {
            return -1;
        }
        if (pathQ1 < pathQ2) {
            return 1;
        }
        if (i1.getDirPath().length() > i2.getDirPath().length()) {
            return -1;
        }
        if (i1.getDirPath().length() < i2.getDirPath().length()) {
            return 1;
        }
        if (i1.getFileName().length() > i2.getFileName().length()) {
            return -1;
        }
        if (i1.getFileName().length() < i2.getFileName().length()) {
            return 1;
        }
        return 0;
    }

    public static void doIntersection(Set<Item> set, Set<Item> with) {
        Iterator<Item> i = set.iterator();
        while (i.hasNext()) {
            Item item = i.next();
            if (with.contains(item)) continue;
            i.remove();
        }
    }

    private boolean compareToken(String s1, String s2, boolean loose) {
        if (s1 != null && s2 != null) {
            int maxLen;
            int minLen;
            int len2;
            if (!loose) {
                return s1.equals(s2);
            }
            int len1 = s1.length();
            if (len1 == (len2 = s2.length())) {
                return s1.equals(s2);
            }
            int n = minLen = len1 > len2 ? len2 : len1;
            if (minLen < 3) {
                return false;
            }
            int n2 = maxLen = len1 > len2 ? len1 : len2;
            if ((double)((float)minLen / (float)maxLen) < 0.6) {
                return false;
            }
            if (len1 > len2 && s1.indexOf(s2) >= 0) {
                return true;
            }
            if (len1 < len2 && s2.indexOf(s1) >= 0) {
                return true;
            }
        }
        return false;
    }

    private int typeQuality(Item item) {
        String type = item.getType();
        if (this.preferMp3 && "mp3".equals(type)) {
            return 1;
        }
        if (this.preferOgg && "ogg".equals(type)) {
            return 1;
        }
        return 0;
    }

    private double pathQuality(Item item) {
        return this.computeDistanceFromRootDir(item.getDirPath());
    }

    private double timeQuality(Item item) {
        TagDescriptors d = item.getTagDescriptors();
        if (d != null) {
            return d.getPlayTime();
        }
        return 0.0;
    }

    private double bitrateQuality(Item item) {
        TagDescriptors d = item.getTagDescriptors();
        if (d != null) {
            double quality = 1.0 / (double)(Math.abs(this.preferredBitrate - d.getBitRate()) + 1);
            if (this.preferVBR && !d.isVariableBitRate()) {
                quality *= 0.01;
            }
            return quality;
        }
        return 0.0;
    }

    private int computeDistanceFromRootDir(String dirPath) {
        int d = 0;
        int i = 0;
        while ((i = dirPath.indexOf(File.separatorChar, i)) >= 0) {
            ++d;
            ++i;
        }
        return d;
    }

    public boolean isInsufficient(TagDescriptors desc) {
        if (this.compareStrictTags || this.compareLessStrictTags) {
            return desc.getAlbum() == null || desc.getArtist() == null;
        }
        return desc.getAlbum() == null && desc.getArtist() == null && desc.getFolderName() == null;
    }
}

