/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFileReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.music.tags.MP3Tags;
import tigor.music.tags.OGGTags;
import tigor.srdmusicduplicates.logic.DuplicateScanner;
import tigor.srdmusicduplicates.logic.FilteredTokens;
import tigor.srdmusicduplicates.logic.ItemDescriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagDescriptors
extends ItemDescriptors {
    private String album;
    private String artist;
    private String title;
    private String fileName;
    private String folderName;
    private String playTimeString;
    private int track;
    private int bitRate;
    private int samplingRate;
    private boolean isVariableBitRate;
    private boolean isMono;
    private long playTime;
    public static final String[] SUPPORTED_FILE_TYPES = new String[]{"mp3", "ogg"};
    private static String[] FileTypes = SUPPORTED_FILE_TYPES;
    private static boolean TEST_COMPUTE_TRACK_FROM_FILE_NAME = false;
    private static final Log log = LogFactory.getLog(TagDescriptors.class);
    private static MpegAudioFileReader mpegReader = new MpegAudioFileReader();
    private static VorbisAudioFileReader oggReader = new VorbisAudioFileReader();

    public TagDescriptors(File file) {
        super(file);
    }

    public static void SetFileTypes(String[] types) {
        FileTypes = types;
    }

    public static String[] FileTypes() {
        return FileTypes;
    }

    @Override
    public String[] getFileTypes() {
        return TagDescriptors.FileTypes();
    }

    @Override
    public boolean isInsufficient() {
        return DuplicateScanner.getStrategy().isInsufficient(this);
    }

    public String getAlbum() {
        return this.album;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public boolean isVariableBitRate() {
        return this.isVariableBitRate;
    }

    public int getTrack() {
        return this.track;
    }

    public boolean isMono() {
        return this.isMono;
    }

    public String getPlayTimeString() {
        return this.playTimeString;
    }

    public long getPlayTime() {
        return this.playTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setup(File file) {
        if (!super.setup(file)) {
            return false;
        }
        try {
            block17: {
                this.track = -1;
                File folder = file.getParentFile();
                this.folderName = folder != null ? FilteredTokens.parse(folder.getName()) : null;
                String fn = file.getName();
                this.type = fn.substring(fn.lastIndexOf(".") + 1).toLowerCase();
                this.fileName = FilteredTokens.parse(fn);
                try {
                    if ("mp3".equals(this.type)) {
                        this.setupUsingJavaZoomPackage(file);
                    } else if ("ogg".equals(this.type)) {
                        this.setupUsingJorbisPackage(file);
                    }
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block17;
                    log.info(file, e);
                }
            }
            if (!Track.inRange(this.track) || TEST_COMPUTE_TRACK_FROM_FILE_NAME) {
                this.track = this.extractTrack(this.fileName);
            }
            Object var6_5 = null;
            if (this.artist == null && log.isDebugEnabled()) {
                log.debug("artist decoded as null in: " + file);
            }
            if (this.album == null && log.isDebugEnabled()) {
                log.debug("album decoded as null in: " + file);
            }
            if (this.title == null && log.isDebugEnabled()) {
                log.debug("title decoded as null in: " + file);
            }
            if (this.track == -1 && log.isDebugEnabled()) {
                log.debug("track decoded as null in: " + file);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.artist == null && log.isDebugEnabled()) {
                log.debug("artist decoded as null in: " + file);
            }
            if (this.album == null && log.isDebugEnabled()) {
                log.debug("album decoded as null in: " + file);
            }
            if (this.title == null && log.isDebugEnabled()) {
                log.debug("title decoded as null in: " + file);
            }
            if (this.track == -1 && log.isDebugEnabled()) {
                log.debug("track decoded as null in: " + file);
            }
            throw throwable;
        }
        return !this.isInsufficient();
    }

    private void setupUsingJavaZoomPackage(File file) throws IOException, UnsupportedAudioFileException {
        MP3Tags tags = new MP3Tags();
        AudioFileFormat format = mpegReader.getAudioFileFormat(file);
        tags.load(file, format);
        this.album = FilteredTokens.parse(tags.getAlbum());
        this.artist = FilteredTokens.parse(tags.getArtist());
        this.title = FilteredTokens.parse(tags.getTitle());
        String channelMode = tags.getChannelsMode();
        this.isMono = channelMode != null && channelMode.toLowerCase().contains("single");
        this.bitRate = tags.getBitRate() / 1000;
        if (this.bitRate < 0 || this.bitRate > 5000) {
            this.bitRate = 0;
        }
        this.isVariableBitRate = tags.getVBR();
        this.samplingRate = tags.getSamplingRate();
        this.playTime = tags.getPlayTime();
        this.setPlayTimeString();
        this.track = this.computeTrackNumber(tags.getTrack());
    }

    private void setupUsingJorbisPackage(File file) throws IOException, UnsupportedAudioFileException {
        OGGTags tags = new OGGTags();
        AudioFileFormat format = oggReader.getAudioFileFormat(file);
        tags.load(file, format);
        this.album = FilteredTokens.parse(tags.getAlbum());
        this.artist = FilteredTokens.parse(tags.getArtist());
        this.title = FilteredTokens.parse(tags.getTitle());
        this.isMono = tags.getChannels() == 1;
        this.bitRate = tags.getBitRate() / 1000;
        if (this.bitRate < 0 || this.bitRate > 5000) {
            this.bitRate = 0;
        }
        this.isVariableBitRate = true;
        this.samplingRate = tags.getSamplingRate();
        this.playTime = tags.getPlayTime();
        this.setPlayTimeString();
        this.track = this.computeTrackNumber(tags.getTrack());
    }

    public int computeTrackNumber(String trackStr) {
        if (trackStr == null) {
            return -1;
        }
        String str = trackStr.trim();
        int i = str.indexOf("/");
        if (i >= 0) {
            str = str.substring(0, i);
        }
        for (i = 0; i < str.length() && Character.isDigit(str.charAt(i)); ++i) {
        }
        if (i < str.length()) {
            str = str.substring(0, i);
        }
        int num = -1;
        if (str.length() > 0) {
            try {
                num = Integer.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return num;
    }

    public void setPlayTimeString() {
        long time = this.getPlayTime();
        if (time == 0L) {
            this.playTimeString = "?";
            return;
        }
        long mins = time / 60L;
        long secs = Math.round(((double)time / 60.0 - (double)(time / 60L)) * 60.0);
        String str = mins + ":";
        str = secs < 10L ? str + "0" + secs : str + "" + secs;
        this.playTimeString = str;
    }

    public String toString() {
        return "TagDescriptors{album='" + this.album + "'" + ", artist='" + this.artist + "'" + ", title='" + this.title + "'" + ", fileName='" + this.fileName + "'" + ", folderName='" + this.folderName + "'" + ", playTimeString='" + this.playTimeString + "'" + ", track=" + this.track + ", bitRate=" + this.bitRate + ", samplingRate=" + this.samplingRate + ", isVariableBitRate=" + this.isVariableBitRate + ", isMono=" + this.isMono + ", playTime=" + this.playTime + "}";
    }

    private int extractTrack(String name) {
        if (name == null) {
            return -1;
        }
        List<Track> candidates = this.getTrackNumberCandidates(name);
        if (candidates == null) {
            return -1;
        }
        Track best = Track.computeFirstBest(candidates);
        return best != null ? best.getNumber() : -1;
    }

    private List<Track> getTrackNumberCandidates(String token) {
        ArrayList<Track> tracks = null;
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(token);
        while (m.find()) {
            String suffix;
            String trackToken = m.group();
            if (!Track.isValid(trackToken)) continue;
            MatchResult r = m.toMatchResult();
            String prefix = r.start() > 0 ? token.substring(0, r.start()) : null;
            String string = suffix = r.end() < token.length() - 1 ? token.substring(r.end()) : null;
            if (tracks == null) {
                tracks = new ArrayList<Track>();
            }
            tracks.add(new Track(prefix, trackToken, suffix));
        }
        return tracks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Track {
        private String prefix;
        private String suffix;
        private String token;
        private double quality;
        private static int MAX_TRACK = 69;

        public Track(String prefix, String token, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.token = token;
            this.quality = this.computeQuality();
        }

        private double computeQuality() {
            char ch;
            double q = 0.0;
            if (!Track.isValid(this.token)) {
                return q;
            }
            q = this.token.length() == 2 ? 1.0 : 1.0 / (double)(Math.abs(this.token.length() - 2) + 1);
            if (this.prefix != null && this.prefix.length() > 0 && !Track.isGoodDelimiter(ch = this.prefix.charAt(this.prefix.length() - 1))) {
                ch = (char)((double)ch / 2.0);
            }
            if (this.suffix != null && this.suffix.length() > 0 && !Track.isGoodDelimiter(ch = this.suffix.charAt(0))) {
                char c = (char)((double)ch / 2.0);
            }
            return q;
        }

        public static boolean isGoodDelimiter(char ch) {
            return Character.isWhitespace(ch);
        }

        public double getQuality() {
            return this.quality;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getToken() {
            return this.token;
        }

        public int getNumber() {
            return Integer.valueOf(this.token);
        }

        public String toString() {
            return "Track{prefix='" + this.prefix + "'" + ", suffix='" + this.suffix + "'" + ", token='" + this.token + "'" + ", quality=" + this.quality + "}";
        }

        public static Track computeFirstBest(List<Track> candidates) {
            Track best = null;
            int count = candidates.size();
            ListIterator<Track> i = candidates.listIterator(count);
            while (i.hasPrevious()) {
                Track track = i.previous();
                if (best != null && !(track.getQuality() > best.getQuality())) continue;
                best = track;
            }
            return best;
        }

        public static boolean isValid(String token) {
            try {
                int i = Integer.valueOf(token);
                if (!Track.inRange(i)) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public static boolean inRange(int n) {
            return n > 0 && n <= MAX_TRACK;
        }
    }
}

