/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic.event;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import tigor.srdmusicduplicates.common.Bytes2String;
import tigor.srdmusicduplicates.logic.event.ScannerEvent;

public class StatisticsEvent
extends ScannerEvent {
    private int numberOfFiles;
    private int numberOfScannedFiles;
    private int numberOfDuplicates;
    private int numberOFilesWithInvalidID3Information;
    private long duplicateBytes;
    private static NumberFormat nf = new DecimalFormat("########.##");
    private File scannerDirectory;
    private static Date StartTime;

    public StatisticsEvent(Object source) {
        super(source);
    }

    public StatisticsEvent(Object source, File scannerDirectory) {
        super(source);
        this.scannerDirectory = scannerDirectory;
    }

    public StatisticsEvent(Object source, int numberOfFiles, int numberOfScannedFiles, int numberOfDuplicates, long duplicateBytes, int numberOfInvalidID3Tags) {
        super(source);
        this.numberOfFiles = numberOfFiles;
        this.numberOfScannedFiles = numberOfScannedFiles;
        this.numberOfDuplicates = numberOfDuplicates;
        this.numberOFilesWithInvalidID3Information = numberOfInvalidID3Tags;
        this.duplicateBytes = duplicateBytes;
    }

    public File getScannerDirectory() {
        return this.scannerDirectory;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getNumberOfScannedFiles() {
        return this.numberOfScannedFiles;
    }

    public int getNumberOfDuplicates() {
        return this.numberOfDuplicates;
    }

    public long getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getNumberOfDuplicatesAsString() {
        return this.numberOfDuplicates + " (" + Bytes2String.format(this.duplicateBytes) + ")";
    }

    public int getNumberOFilesWithInvalidID3Information() {
        return this.numberOFilesWithInvalidID3Information;
    }

    public static void resetStopwatch() {
        StartTime = new Date();
    }

    public static long getCurrentStopwatchInSecs() {
        if (StartTime == null) {
            return -1L;
        }
        Date curr = new Date();
        return (curr.getTime() - StartTime.getTime()) / 1000L;
    }

    public String toString() {
        return "StatisticsEvent{duration=" + StatisticsEvent.getCurrentStopwatchInSecs() + ", numberOfFiles=" + this.numberOfFiles + ", numberOfScannedFiles=" + this.numberOfScannedFiles + ", numberOfDuplicates=" + this.numberOfDuplicates + ", numberOFilesWithInvalidID3Information=" + this.numberOFilesWithInvalidID3Information + ", duplicateBytes=" + this.duplicateBytes + '}';
    }
}

