/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.logic.DuplicateMover;
import tigor.srdmusicduplicates.logic.event.MoverEvent;
import tigor.srdmusicduplicates.logic.event.MoverEventListener;
import tigor.srdmusicduplicates.ui.Utilities;

public class DuplicateMoverProgressMonitor
extends JPanel
implements MoverEventListener {
    private JProgressBar progressBar;
    private JButton cancelButton;
    private JTextArea taskOutput;
    private DuplicateMover mover;
    private JDialog dialog;
    private static final String NEW_LINE = "\n";
    private static final Log log = LogFactory.getLog(DuplicateMover.class);

    public DuplicateMoverProgressMonitor(DuplicateMover mover) {
        super(new BorderLayout());
        this.mover = mover;
    }

    private void setup(JDialog dialog) {
        this.dialog = dialog;
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DuplicateMoverProgressMonitor.this.tearDown();
                DuplicateMoverProgressMonitor.this.close();
            }
        });
        this.setOpaque(true);
        dialog.setContentPane(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DuplicateMoverProgressMonitor.this.mover.isRunning()) {
                    DuplicateMoverProgressMonitor.this.tearDown();
                    DuplicateMoverProgressMonitor.this.cancelButton.setText("Done");
                } else {
                    DuplicateMoverProgressMonitor.this.close();
                }
            }
        });
        this.progressBar = new JProgressBar(0, this.mover.getNumberOfFiles());
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        JPanel panel = new JPanel();
        panel.add(this.cancelButton);
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setPreferredSize(new Dimension(500, 500));
        this.mover.addEventListener(this);
    }

    private void start() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mover.startRunning();
    }

    private void close() {
        this.dialog.setVisible(false);
    }

    private void tearDown() {
        this.mover.stopRunning();
        this.setCursor(null);
    }

    public void moverEvent(MoverEvent e) {
        this.progressBar.setValue(this.mover.getNumberOfMovedFiles());
        if (MoverEvent.Type.moved.equals((Object)e.getType())) {
            String s = "from " + e.getItem().getFile() + " to " + e.getToFile();
            this.taskOutput.append(s + NEW_LINE);
            this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
            if (log.isDebugEnabled()) {
                log.debug(s);
            }
        } else if (MoverEvent.Type.end.equals((Object)e.getType())) {
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.taskOutput.append("operation ended.\n");
            this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
            if (log.isDebugEnabled()) {
                log.debug("operation ended.");
            }
        } else if (MoverEvent.Type.interrupted.equals((Object)e.getType())) {
            this.taskOutput.append("operation interrupted.\n");
            this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
            if (log.isDebugEnabled()) {
                log.debug("operation interrupted.");
            }
        } else if (MoverEvent.Type.exception.equals((Object)e.getType())) {
            this.taskOutput.append("exception raised (see log): " + e.getException());
            this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
            log.error("exception raised", e.getException());
        }
        if (e.getType().isTerminator()) {
            this.cancelButton.setText("Done");
            this.tearDown();
        }
    }

    public static void run(JFrame parent, DuplicateMover mover) {
        JDialog dialog = new JDialog((Frame)parent, "SRD: Move task progress monitor");
        dialog.setModal(true);
        DuplicateMoverProgressMonitor monitor = new DuplicateMoverProgressMonitor(mover);
        monitor.setup(dialog);
        monitor.start();
        dialog.pack();
        Utilities.center(dialog);
        dialog.setVisible(true);
    }
}

