/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import tigor.srdmusicduplicates.logic.Group;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.ui.ItemRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatesTableModel
extends AbstractTableModel {
    private List<ItemRow> rows = new ArrayList<ItemRow>();

    public DuplicatesTableModel() {
        Group.resetSequenceNumberGenerator();
    }

    public void clear() {
        this.rows = new ArrayList<ItemRow>();
        Group.resetSequenceNumberGenerator();
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return ItemRow.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ItemRow.getColumnClass(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return ItemRow.getColumnCount();
    }

    public ItemRow getRowAt(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).getValueAt(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).isCellEditable(columnIndex);
    }

    public void recheckRows() {
        for (ItemRow row : this.rows) {
            row.recheck();
        }
        this.fireTableDataChanged();
    }

    public void uncheckAllRows() {
        for (ItemRow row : this.rows) {
            row.uncheck();
        }
        this.fireTableDataChanged();
    }

    public void uncheckDeviantRows() {
        for (ItemRow row : this.rows) {
            if (!row.hasDeviantTime()) continue;
            row.uncheck();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAddedToGroup(Group group, Item item) {
        try {
            group.acquireReadLock();
            try {
                int rowIndex = this.indexOfFirstRow(group);
                if (rowIndex == -1) {
                    rowIndex = this.rows.size();
                    this.insertRows(group, null);
                    group.setNextSequenceNumber();
                    this.fireTableRowsInserted(rowIndex, rowIndex + group.size());
                } else {
                    this.updateRows(rowIndex, group);
                    int insertedRowIndex = this.indexOfRow(this.rows, item);
                    if (insertedRowIndex < 0) {
                        throw new IllegalStateException("Ups, program consistency error...");
                    }
                    this.fireTableRowsInserted(insertedRowIndex, insertedRowIndex);
                    this.fireTableRowsUpdated(rowIndex, rowIndex + group.size());
                }
            }
            finally {
                group.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not acquire read-lock to update model for duplicateGroup: " + group);
        }
    }

    public void setDuplicates(Map<Item, Group> groups, List<ItemRow> fromRows) {
        this.rows.clear();
        Group.resetSequenceNumberGenerator();
        HashSet<Group> processed = new HashSet<Group>();
        for (Group group : groups.values()) {
            if (processed.contains(group)) continue;
            this.insertRows(group, fromRows);
            group.setNextSequenceNumber();
            processed.add(group);
        }
        this.fireTableDataChanged();
    }

    public List<ItemRow> collectRowsModifiedByUser() {
        ArrayList<ItemRow> collected = new ArrayList<ItemRow>();
        for (ItemRow row : this.rows) {
            if (!row.isModifiedByUser()) continue;
            collected.add(row);
        }
        return collected;
    }

    public List<ItemRow> getCheckedRows() {
        ArrayList<ItemRow> checked = new ArrayList<ItemRow>();
        for (ItemRow row : this.rows) {
            if (!row.isChecked()) continue;
            checked.add(row);
        }
        return checked;
    }

    public void launchPlayer(int selectedRow) {
        if (selectedRow >= 0) {
            this.rows.get(selectedRow).launchPlayer();
        }
    }

    public void launchFolderExplorer(int selectedRow) {
        if (selectedRow >= 0) {
            this.rows.get(selectedRow).launchFolderExplorer();
        }
    }

    void fireTableRowUpdated(ItemRow row) {
        int i = this.rows.indexOf(row);
        if (i >= 0) {
            this.fireTableRowsUpdated(i, i);
        }
    }

    private void updateRows(int fromRowIndex, Group group) {
        List<ItemRow> removed = this.removeAllRows(group.getSetOfMembers());
        this.rows.addAll(fromRowIndex, this.createRows(group, removed));
    }

    private List<ItemRow> removeAllRows(Set<Item> items) {
        ArrayList<ItemRow> removed = new ArrayList<ItemRow>();
        Iterator<ItemRow> e = this.rows.iterator();
        while (e.hasNext()) {
            ItemRow row = e.next();
            if (!items.contains(row.getItem())) continue;
            e.remove();
            removed.add(row);
        }
        return removed;
    }

    private void insertRows(Group group, List<ItemRow> fromRows) {
        Collection<ItemRow> fresh = this.createRows(group, fromRows);
        this.rows.addAll(fresh);
    }

    private Collection<ItemRow> createRows(Group group, List<ItemRow> fromRows) {
        ArrayList<ItemRow> result = new ArrayList<ItemRow>(group.size());
        for (Item item : group.getMembers()) {
            int i;
            ItemRow r = new ItemRow(this, group, item);
            if (fromRows != null && fromRows.size() > 0 && (i = this.indexOfRow(fromRows, item)) >= 0) {
                r.updateFrom(fromRows.get(i));
            }
            result.add(r);
        }
        return result;
    }

    private int indexOfRow(Collection<ItemRow> rows, Item item) {
        int i = 0;
        for (ItemRow row : rows) {
            if (row.getItem().equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfFirstRow(Group group) {
        int i = 0;
        for (ItemRow row : this.rows) {
            if (group.hasMember(row.getItem())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

