/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.launcher.BrowserLauncher;

public class HelpWindow
extends JFrame {
    private JPanel contentPane;
    private JTextPane textPane;
    private String resourceName;
    private static final Log log = LogFactory.getLog(HelpWindow.class);
    public static final String Q_A_TITLE = "S&D: Q & A";
    public static final String Q_A_RESOURCE_NAME = "resources/help/q_a.html";
    public static final String R_N_TITLE = "S&D: Release Notes";
    public static final String R_N_RESOURCE_NAME = "resources/help/release_notes.txt";

    public HelpWindow(String title, String resourceName) {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setTitle(title);
        this.setDefaultCloseOperation(1);
        this.setPreferredSize(new Dimension(600, 500));
        this.resourceName = resourceName;
        this.textPane.setContentType(resourceName.endsWith("html") ? "text/html" : "text/text");
    }

    public static HelpWindow createQAWindow() {
        return new HelpWindow(Q_A_TITLE, Q_A_RESOURCE_NAME);
    }

    public static HelpWindow createRNWindow() {
        return new HelpWindow(R_N_TITLE, R_N_RESOURCE_NAME);
    }

    public void load() {
        this.setFromResource(this.resourceName, this.textPane);
    }

    private void setFromResource(String path, JTextPane pane) {
        URL resource = this.getClass().getResource(path);
        if (resource != null) {
            try {
                pane.setPage(resource);
            }
            catch (IOException e) {
                log.error("Can't read " + resource, e);
            }
        }
        pane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    String url = null;
                    try {
                        url = e.getURL().toString();
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException e1) {
                        log.error("Can't launch " + url, e1);
                    }
                }
            }
        });
    }

    private void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(2, 2, 2, 2), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jScrollPane.setViewportView(jPanel2);
        this.textPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEnabled(true);
        jTextPane.setEditable(false);
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
    }
}

