/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import tigor.srdmusicduplicates.launcher.FolderExplorerLauncher;
import tigor.srdmusicduplicates.launcher.PlayerLauncher;
import tigor.srdmusicduplicates.logic.DataDescriptors;
import tigor.srdmusicduplicates.logic.Group;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.TagDescriptors;
import tigor.srdmusicduplicates.ui.DuplicatesTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemRow
implements Serializable {
    private transient DuplicatesTableModel model;
    private transient Group group;
    private transient JCheckBox checkBox;
    private Item item;
    private boolean checked;
    private boolean modifiedByUser;
    private Boolean isOverruled;
    private transient int overruledCount;
    private transient boolean hasDeviantTime;
    private static boolean SHOW_CHECKSUM = true;
    private static final Class[] columnClasses = new Class[]{JCheckBox.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static final String[] columnNames = new String[]{"X", "Match", "Directory", "Filename", "Type", "Time", "Artist", "Album", "Title", "Track", "Rate", "Filelen", "Checksum"};
    private static final String[] columnWidthStrings = new String[]{"XX", "XXXXX", "XXXXXXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXX", "XXXXX", "XXXXX", "XXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXXXXXXXXX", "XXXXXX", "XXXXX", "XXXXXXXX", "XXXXXXXXXXXXXXX", "XXXXXXXX"};
    private static final Color WARN1_COLOR = new MyColor("EDB301");
    private static final Color WARN2_COLOR = new MyColor("4197E3");
    private static final Color ALT1_COLOR = new MyColor("F1CE67");
    private static final Color ALT2_COLOR = new MyColor("9EB1E9");
    private static final Color SELECTION_COLOR = Color.YELLOW;
    private static final int CHECK_BOX_COLUMN = 0;
    private static final int TIME_COLUMN = 5;
    private static final int ROW_HEIGHT = 18;

    public ItemRow(DuplicatesTableModel model, Group group, Item item) {
        this.model = model;
        this.group = group;
        this.item = item;
        this.checkBox = new JCheckBox("");
        if (this.isLocked()) {
            this.checkBox.setEnabled(false);
        }
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ItemRow.this.checked = ItemRow.this.checkBox.isSelected();
                ItemRow.this.isOverruled = null;
                if (!ItemRow.this.isOverruled()) {
                    ItemRow.this.overruledCount++;
                }
                if (ItemRow.this.overruledCount % 2 == 0) {
                    ItemRow.this.modifiedByUser = ItemRow.this.isOverruled();
                } else {
                    ItemRow.this.modifiedByUser = true;
                }
                ItemRow.this.checkBox.setBackground(ItemRow.this.getCheckBoxColor(false));
                ItemRow.this.fireTableRowUpdated();
            }
        });
        this.update();
    }

    public static void setLayout(JTable table) {
        int lengthSum = 0;
        for (String s : columnWidthStrings) {
            lengthSum += s.length();
        }
        int w = (int)table.getPreferredScrollableViewportSize().getWidth();
        int i = 0;
        Enumeration<TableColumn> e = table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn col = e.nextElement();
            int colWidth = w * columnWidthStrings[i++].length() / lengthSum;
            col.setPreferredWidth(colWidth);
            col.setWidth(colWidth);
        }
        table.setRowHeight(18);
    }

    public DuplicatesTableModel getModel() {
        return this.model;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public static boolean isShowChecsum() {
        return SHOW_CHECKSUM;
    }

    public static void setShowChecsum(boolean v) {
        SHOW_CHECKSUM = v;
    }

    public void launchPlayer() {
        PlayerLauncher.getInstance().exec(this.getItem().getFile().getPath());
    }

    public void launchFolderExplorer() {
        FolderExplorerLauncher.getInstance().exec(this.getItem().getFile().getParentFile().getPath());
    }

    public boolean isModifiedByUser() {
        return this.modifiedByUser;
    }

    public boolean isOverruled() {
        if (this.isOverruled == null) {
            this.isOverruled = new Boolean(this.computeIsOverruled());
        }
        return this.isOverruled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public Group getDuplicates() {
        return this.group;
    }

    public Item getItem() {
        return this.item;
    }

    public static String getColumnName(int column) {
        return columnNames[column];
    }

    public static Class<?> getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public static int getColumnCount() {
        return columnClasses.length - (SHOW_CHECKSUM ? 0 : 1);
    }

    public boolean isMember(Group group) {
        return this.group == group;
    }

    public Object getValueAt(int columnIndex) {
        DataDescriptors dataDescriptors = this.item.getDataDescriptors();
        TagDescriptors tagDescriptors = this.item.getTagDescriptors();
        boolean i = false;
        if (columnIndex == 0) {
            return this.checkBox;
        }
        if (columnIndex == 1) {
            return this.item.getEquality();
        }
        if (columnIndex == 2) {
            return this.item.getDirPath();
        }
        if (columnIndex == 3) {
            return this.item.getFileName();
        }
        if (columnIndex == 4 && tagDescriptors != null) {
            return tagDescriptors.getType();
        }
        if (columnIndex == 4 && dataDescriptors != null) {
            return dataDescriptors.getType();
        }
        if (columnIndex == 5) {
            return tagDescriptors != null ? tagDescriptors.getPlayTimeString() : "";
        }
        if (columnIndex == 6) {
            return tagDescriptors != null ? tagDescriptors.getArtist() : "";
        }
        if (columnIndex == 7) {
            return tagDescriptors != null ? tagDescriptors.getAlbum() : "";
        }
        if (columnIndex == 8) {
            return tagDescriptors != null ? tagDescriptors.getTitle() : "";
        }
        if (columnIndex == 9) {
            return tagDescriptors != null ? Integer.valueOf(tagDescriptors.getTrack()) : "";
        }
        if (columnIndex == 10) {
            return tagDescriptors != null ? String.valueOf(tagDescriptors.getBitRate()) + (tagDescriptors.isVariableBitRate() ? "(VBR)" : "") : "";
        }
        if (columnIndex == 11) {
            return this.item.getContentLength();
        }
        if (columnIndex == 12) {
            return dataDescriptors != null ? Long.valueOf(dataDescriptors.getContentChecksum()) : null;
        }
        return null;
    }

    public boolean isCellEditable(int columnIndex) {
        return AbstractButton.class.isAssignableFrom(ItemRow.getColumnClass(columnIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            this.group.acquireReadLock();
            try {
                this.hasDeviantTime = this.group.hasDeviantPlayingTime();
                if (!this.modifiedByUser) {
                    boolean isDuplicate = this.group.isDuplicate(this.item) && !this.isLocked();
                    this.checkBox.setSelected(isDuplicate);
                    this.checked = isDuplicate;
                }
            }
            finally {
                this.group.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not acquire read-lock to update model for duplicateGroup: " + this.group);
        }
    }

    public boolean hasDeviantTime() {
        return this.hasDeviantTime;
    }

    public boolean isLocked() {
        return this.item.getRoot().isLocked();
    }

    public Color getColor(JTable table, int tableColumn) {
        int column = table.convertColumnIndexToModel(tableColumn);
        if (column == 0) {
            return this.getCheckBoxColor(false);
        }
        return this.getCellColor(false, column == 5 && this.hasDeviantTime);
    }

    private void fireTableRowUpdated() {
        this.model.fireTableRowUpdated(this);
    }

    private boolean computeIsOverruled() {
        if (this.isChecked() && !this.group.isDuplicate(this.item)) {
            return true;
        }
        return !this.isChecked() && this.group.isDuplicate(this.item);
    }

    private Color getCheckBoxColor(boolean isSelected) {
        return this.getCellColor(isSelected, this.isModifiedByUser());
    }

    public Color getSelectionColor(JTable table, int tableColumn) {
        int column = table.convertColumnIndexToModel(tableColumn);
        if (column == 5) {
            return this.getCellColor(true, column == 5 && this.hasDeviantTime);
        }
        if (column == 0) {
            return this.getCheckBoxColor(true);
        }
        return SELECTION_COLOR;
    }

    private Color getCellColor(boolean isSelected, boolean isWarining) {
        if (this.group.getSequenceNumber() % 2 == 0) {
            if (isWarining) {
                return WARN1_COLOR;
            }
            return isSelected ? SELECTION_COLOR : ALT1_COLOR;
        }
        if (isWarining) {
            return WARN2_COLOR;
        }
        return isSelected ? SELECTION_COLOR : ALT2_COLOR;
    }

    public void updateFrom(ItemRow row) {
        if (row.modifiedByUser) {
            this.modifiedByUser = row.modifiedByUser;
            this.isOverruled = null;
            this.checked = row.checked;
            this.checkBox.setSelected(this.checked);
        }
        this.update();
    }

    public void recheck() {
        this.modifiedByUser = false;
        this.update();
    }

    public void uncheck() {
        this.checkBox.setSelected(false);
        this.checked = false;
        this.modifiedByUser = true;
    }

    public static class MyColor
    extends Color {
        public MyColor(int rgb) {
            super(rgb);
        }

        public MyColor(String hexColor) {
            this(MyColor.hex2Rgb(hexColor));
        }

        private static int hex2Rgb(String hexColor) {
            if (hexColor.length() != 6) {
                throw new IllegalArgumentException("syntax error: hex color string length should be 7");
            }
            return Integer.valueOf(hexColor, 16);
        }
    }
}

