/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.ui.JComponentCellEditor;
import tigor.srdmusicduplicates.ui.JComponentCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootsAccessory
extends JPanel {
    private JFileChooser chooser;
    private List<Root> originalFileRoots;
    private JButton addButton;
    private JButton deleteButton;
    private JTable rootsTable;
    private JScrollPane tableScrollPane;
    private MyTableModel model;
    public static final String ADD_ROOT_COMMAND = "Add Root";
    public static final String REMOVE_ROOT_COMMAND = "Remove";
    public static final String SET_ROOTS_BUTTON_TEXT = "Set Roots";
    private static final String[] SET_ROOTS_BUTTON_PATTERN = new String[]{"Set Roots", "open", "save"};

    public RootsAccessory(JFileChooser chooser, List<Root> roots) {
        this.chooser = chooser;
        this.originalFileRoots = roots;
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "Root directory with music files";
            }
        });
        this.setGUI();
        this.addListeners();
        chooser.setAccessory(this);
        chooser.validate();
        this.updateButtons();
    }

    public List<Root> getChoosenRoots() {
        ArrayList<Root> choosen = new ArrayList<Root>();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            choosen.add((Root)this.model.getValueAt(i, 1));
        }
        return choosen;
    }

    private void setGUI() {
        this.setBorder(new TitledBorder("Roots"));
        this.setLayout(new BorderLayout());
        this.setRootsTable();
        this.add((Component)this.tableScrollPane, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        this.addButton = new JButton(ADD_ROOT_COMMAND);
        this.deleteButton = new JButton(REMOVE_ROOT_COMMAND);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(this.addButton);
        southPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        southPanel.add(this.deleteButton);
        southPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        southPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        southPanel.add(Box.createHorizontalGlue());
        this.add((Component)southPanel, "South");
        this.add((Component)new JLabel("Files from roots with lock will not be removed."), "North");
        Dimension size = new Dimension(300, 200);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
    }

    private void setRootsTable() {
        this.model = this.createModel();
        this.rootsTable = new JTable(this.model){

            public boolean getScrollableTracksViewportWidth() {
                if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                    return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
                }
                return false;
            }
        };
        this.rootsTable.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.rootsTable.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.rootsTable.setSelectionMode(1);
        this.rootsTable.getColumn("Lock").setMaxWidth(60);
        this.rootsTable.setPreferredSize(new Dimension(600, 50));
        this.rootsTable.setOpaque(true);
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                RootsAccessory.this.updateButtons();
            }
        });
        this.tableScrollPane = new JScrollPane(this.rootsTable);
        this.tableScrollPane.setHorizontalScrollBarPolicy(30);
        this.tableScrollPane.validate();
    }

    private void addListeners() {
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if (prop.equals("SelectedFileChangedProperty") || prop.equals("directoryChanged")) {
                    RootsAccessory.this.updateButtons();
                }
            }
        });
        this.rootsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Root root;
                int selectedIndex = RootsAccessory.this.rootsTable.getSelectedRow();
                if (selectedIndex >= 0 && (root = (Root)RootsAccessory.this.model.getValueAt(selectedIndex, 1)).canRead()) {
                    RootsAccessory.this.chooser.setCurrentDirectory(root);
                    RootsAccessory.this.chooser.setSelectedFile(null);
                }
                RootsAccessory.this.updateButtons();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                if (command.equals(RootsAccessory.REMOVE_ROOT_COMMAND)) {
                    int[] inds = RootsAccessory.this.rootsTable.getSelectedRows();
                    int i = inds.length;
                    while (--i >= 0) {
                        RootsAccessory.this.model.removeRow(inds[i]);
                    }
                }
                if (command.equals(RootsAccessory.ADD_ROOT_COMMAND)) {
                    Root root = new Root(RootsAccessory.this.getCurrentRootDirectory().getPath(), false);
                    List<Root> choosen = RootsAccessory.this.getChoosenRoots();
                    if (!choosen.contains(root)) {
                        Root conflictRoot = root.findFirstIntersection(choosen);
                        if (conflictRoot != null) {
                            JOptionPane.showMessageDialog(RootsAccessory.this.chooser, "Sorry, this directory has intersection with root " + conflictRoot.getPath() + ".");
                            return;
                        }
                        RootsAccessory.this.model.addRow(new MyTableModel.Row(RootsAccessory.this.model, new JCheckBox(), root));
                    }
                    RootsAccessory.this.rootsTable.doLayout();
                }
            }
        };
        this.addButton.addActionListener(actionListener);
        this.deleteButton.addActionListener(actionListener);
    }

    private File getCurrentRootDirectory() {
        File root = this.chooser.getSelectedFile();
        if (root == null || !root.isDirectory()) {
            root = this.chooser.getCurrentDirectory();
        }
        return root;
    }

    private void updateButtons() {
        this.deleteButton.setEnabled(this.rootsTable.getSelectedRow() >= 0);
        this.addButton.setEnabled(!this.getChoosenRoots().contains(this.getCurrentRootDirectory()));
        this.setApproveButtonEnabled(this.anyChanges());
    }

    private boolean anyChanges() {
        return !((Object)this.getChoosenRoots()).equals(this.originalFileRoots);
    }

    private void setApproveButtonEnabled(boolean isEnabled) {
        JButton approveButton = this.findApproveButton(this.chooser);
        approveButton.setEnabled(isEnabled);
    }

    private JButton findApproveButton(Container parent) {
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (JPanel.class.isAssignableFrom(child.getClass())) {
                JButton button = this.findApproveButton((Container)child);
                if (button == null) continue;
                return button;
            }
            if (!JButton.class.isAssignableFrom(child.getClass())) continue;
            JButton b = (JButton)children[i];
            for (String pattern : SET_ROOTS_BUTTON_PATTERN) {
                if (!pattern.equalsIgnoreCase(b.getText())) continue;
                return b;
            }
        }
        return null;
    }

    private MyTableModel createModel() {
        MyTableModel model = new MyTableModel();
        for (Root root : this.originalFileRoots) {
            model.addRow(new MyTableModel.Row(model, new JCheckBox(), new Root(root.getPath(), root.isLocked())));
        }
        return model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyTableModel
    extends AbstractTableModel {
        List<Row> rows = new ArrayList<Row>();

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void addRow(Row row) {
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        public void removeRow(int i) {
            this.rows.remove(i);
            this.fireTableRowsDeleted(i, i);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.rows.get(row).get(column);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return Row.getColumnClass(column);
        }

        @Override
        public String getColumnName(int column) {
            return Row.getColumnName(column);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Row {
            JCheckBox lockCheckBox;
            Root root;

            public Row(final MyTableModel model, final JCheckBox lockCheckBox, final Root root) {
                this.lockCheckBox = lockCheckBox;
                lockCheckBox.setSelected(root.isLocked());
                lockCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        root.setLocked(lockCheckBox.isSelected());
                        model.fireTableChanged(new TableModelEvent(model));
                    }
                });
                this.root = root;
            }

            public static String getColumnName(int column) {
                return column == 0 ? "Lock" : "Path";
            }

            public static Class<?> getColumnClass(int column) {
                return column == 0 ? JCheckBox.class : Root.class;
            }

            public static int getColumnIndex(String identifier) {
                return identifier.equalsIgnoreCase("lock") ? 0 : 1;
            }

            public JCheckBox getLockCheckBox() {
                return this.lockCheckBox;
            }

            public Root getRoot() {
                return this.root;
            }

            public Object get(int column) {
                return column == 0 ? this.lockCheckBox : this.root;
            }
        }
    }
}

