/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.ui.JComponentCellEditor;
import tigor.srdmusicduplicates.ui.JComponentCellRenderer;
import tigor.srdmusicduplicates.ui.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootsDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonNewRoot;
    private JButton buttonRemoveRoots;
    private JFileChooser chooser;
    private List<Root> originalRoots;
    private JTable rootsTable;
    private RootsTableModel rootsModel;
    private int option;
    public static final String SET_ROOTS_BUTTON = "Choose Root(s)";

    public RootsDialog(Frame owner, String title, List<Root> originalRoots) {
        super(owner, title);
        this.$$$setupUI$$$();
        this.originalRoots = originalRoots;
        this.setup();
    }

    public int run() {
        this.setModal(true);
        this.pack();
        Utilities.center(this);
        this.setVisible(true);
        return this.getOption();
    }

    public List<Root> getRoots() {
        ArrayList<Root> result = new ArrayList<Root>();
        int n = this.rootsModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            result.add((Root)this.rootsModel.getValueAt(i, 1));
        }
        return result;
    }

    public int getOption() {
        return this.option;
    }

    public boolean anyChanges() {
        return !((Object)this.getRoots()).equals(this.originalRoots);
    }

    private void setup() {
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RootsDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RootsDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RootsDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RootsDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.buttonRemoveRoots.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] inds = RootsDialog.this.rootsTable.getSelectedRows();
                int i = inds.length;
                while (--i >= 0) {
                    RootsDialog.this.rootsModel.removeRow(inds[i]);
                }
                RootsDialog.this.updateButtons();
            }
        });
        this.buttonNewRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List newRoots = RootsDialog.this.chooseRoots();
                if (newRoots == null) {
                    return;
                }
                List<Root> roots = RootsDialog.this.getRoots();
                for (Root newRoot : newRoots) {
                    if (roots.contains(newRoot)) continue;
                    Root conflictRoot = newRoot.findFirstIntersection(roots);
                    if (conflictRoot != null) {
                        JOptionPane.showMessageDialog(RootsDialog.this.chooser, "Sorry, " + newRoot.getPath() + " has intersection with existing root " + conflictRoot.getPath() + ".");
                        return;
                    }
                    RootsDialog.this.rootsModel.addRow(new RootsTableModel.Row(RootsDialog.this.rootsModel, new JCheckBox(), newRoot));
                }
                RootsDialog.this.updateButtons();
            }
        });
        this.rootsModel = new RootsTableModel(this.originalRoots);
        this.rootsTable.setModel(this.rootsModel);
        this.rootsTable.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.rootsTable.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.rootsTable.setSelectionMode(1);
        this.rootsTable.getColumn("Lock").setMaxWidth(60);
        this.rootsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RootsDialog.this.updateButtons();
            }
        });
        this.rootsModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                RootsDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        Dimension size = new Dimension(400, 300);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
    }

    private void updateButtons() {
        this.buttonRemoveRoots.setEnabled(this.rootsTable.getSelectedRow() >= 0);
        this.buttonOK.setEnabled(this.anyChanges());
    }

    private List<Root> chooseRoots() {
        int result;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }

                public String getDescription() {
                    return "Root directory with music files";
                }
            });
        }
        if ((result = this.chooser.showDialog(this, SET_ROOTS_BUTTON)) == 0) {
            File[] file;
            ArrayList<Root> roots = new ArrayList<Root>();
            for (File dir : file = this.chooser.getSelectedFiles()) {
                roots.add(new Root(dir.getPath(), false));
            }
            return roots;
        }
        return null;
    }

    private void onOK() {
        this.option = 0;
        this.dispose();
    }

    private void onCancel() {
        this.option = 2;
        this.dispose();
    }

    private void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JTable jTable;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(5, 1, 1, 1), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Roots"));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.rootsTable = jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonNewRoot = jButton4 = new JButton();
        jButton4.setText("New");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonRemoveRoots = jButton3 = new JButton();
        jButton3.setText("Remove");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RootsTableModel
    extends AbstractTableModel {
        List<Row> rows = new ArrayList<Row>();

        public RootsTableModel(List<Root> roots) {
            for (Root root : roots) {
                this.addRow(new Row(this, new JCheckBox(), new Root(root.getPath(), root.isLocked())));
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void addRow(Row row) {
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        public void removeRow(int i) {
            this.rows.remove(i);
            this.fireTableRowsDeleted(i, i);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.rows.get(row).get(column);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return Row.getColumnClass(column);
        }

        @Override
        public String getColumnName(int column) {
            return Row.getColumnName(column);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Row {
            JCheckBox lockCheckBox;
            Root root;
            public static final String LOCK_COLUMN = "Lock";
            public static final String PATH_COLUMN = "Path";

            public Row(final RootsTableModel model, final JCheckBox lockCheckBox, final Root root) {
                this.lockCheckBox = lockCheckBox;
                lockCheckBox.setSelected(root.isLocked());
                lockCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        root.setLocked(lockCheckBox.isSelected());
                        model.fireTableChanged(new TableModelEvent(model));
                    }
                });
                this.root = root;
            }

            public static String getColumnName(int column) {
                return column == 0 ? LOCK_COLUMN : PATH_COLUMN;
            }

            public static Class<?> getColumnClass(int column) {
                return column == 0 ? JCheckBox.class : Root.class;
            }

            public static int getColumnIndex(String identifier) {
                return identifier.equalsIgnoreCase("lock") ? 0 : 1;
            }

            public JCheckBox getLockCheckBox() {
                return this.lockCheckBox;
            }

            public Root getRoot() {
                return this.root;
            }

            public Object get(int column) {
                return column == 0 ? this.lockCheckBox : this.root;
            }
        }
    }
}

