/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.launcher.FolderExplorerLauncher;
import tigor.srdmusicduplicates.launcher.PlayerLauncher;
import tigor.srdmusicduplicates.logic.DataDescriptors;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.SoundDescriptors;
import tigor.srdmusicduplicates.logic.TagDescriptors;
import tigor.srdmusicduplicates.ui.Utilities;

public class Settings
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonDefault;
    private JCheckBox compareDataCheckBox;
    private JCheckBox compareSoundCheckBox;
    private JCheckBox compareTagsCheckBox;
    private JTextField launchPlayerTextField;
    private JTextField launchFolderExplorerTextField;
    private JPanel dataFileTypesPanel;
    private JPanel soundFileTypesPanel;
    private JPanel tagFileTypesPanel;
    private PersistentPreferences preferences;
    private Repository repository;
    private int option;
    private static final Log log = LogFactory.getLog(Settings.class);

    public Settings(Frame parent, String title, PersistentPreferences preferences) {
        super(parent, title);
        this.$$$setupUI$$$();
        this.preferences = preferences;
        this.repository = Repository.readFromPreferences(preferences);
        if (this.repository == null) {
            this.repository = new Repository();
            this.repository.initialize();
            this.repository.establishSettings();
        }
        try {
            this.setup();
        }
        catch (Exception e) {
            log.error("Can't initialize settings", e);
        }
    }

    public void setup() {
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.onCancel();
            }
        });
        this.buttonDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.repository.setToDefaults(Settings.this.preferences);
                Settings.this.updateUI();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Settings.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.compareDataCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.repository.setCompareData(Settings.this.compareDataCheckBox.isSelected());
                Settings.this.updateUI();
            }
        });
        this.compareTagsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.repository.setCompareTags(Settings.this.compareTagsCheckBox.isSelected());
                Settings.this.updateUI();
            }
        });
        this.compareSoundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings.this.repository.setCompareSound(Settings.this.compareSoundCheckBox.isSelected());
                Settings.this.updateUI();
            }
        });
        this.setFileTypesUI(this.dataFileTypesPanel);
        this.setFileTypesUI(this.tagFileTypesPanel);
        if (this.soundFileTypesPanel != null) {
            this.setFileTypesUI(this.soundFileTypesPanel);
        }
        this.updateUI();
    }

    private void updateUI() {
        this.launchFolderExplorerTextField.setText(this.repository.getLaunchFolderExplorer());
        this.launchPlayerTextField.setText(this.repository.getLaunchPlayer());
        this.repository.makeValid();
        this.compareDataCheckBox.setSelected(this.repository.isCompareData());
        this.compareTagsCheckBox.setSelected(this.repository.isCompareTags());
        this.compareSoundCheckBox.setSelected(this.repository.isCompareSound());
        this.compareDataCheckBox.setEnabled(this.repository.isCompareTags() || this.repository.isCompareSound());
        this.updateFileTypesUI(this.dataFileTypesPanel, this.repository.getDataDescriptorsFileTypes());
        this.updateFileTypesUI(this.tagFileTypesPanel, this.repository.getTagDescriptorsFileTypes());
        if (this.soundFileTypesPanel != null) {
            this.updateFileTypesUI(this.soundFileTypesPanel, this.repository.getSoundDescriptorsFileTypes());
        }
    }

    private void setFileTypesUI(JPanel panel) {
        for (Component comp : panel.getComponents()) {
            JCheckBox cb = (JCheckBox)comp;
            cb.addActionListener(new MyActionListener());
        }
    }

    private void updateFileTypesUI(JPanel panel, String[] types) {
        for (Component comp : panel.getComponents()) {
            JCheckBox cb = (JCheckBox)comp;
            String type = cb.getText();
            cb.setSelected(false);
            for (String enabled : types) {
                if (!type.equals(enabled)) continue;
                cb.setSelected(true);
            }
        }
    }

    public int getOption() {
        return this.option;
    }

    public boolean anyScannerPropertiesChanged() {
        return this.repository.isScannerPropertyChanged();
    }

    public boolean anyModifications() {
        return this.repository.isModified();
    }

    public int run() {
        this.setModal(true);
        this.pack();
        Utilities.center(this);
        this.setVisible(true);
        return this.getOption();
    }

    private void onOK() {
        this.repository.setLaunchFolderExplorer(this.launchFolderExplorerTextField.getText());
        this.repository.setLaunchPlayer(this.launchPlayerTextField.getText());
        this.option = 0;
        if (this.repository.isModified()) {
            this.repository.makeValid();
            this.repository.writeToPreferences(this.preferences);
        }
        this.repository.establishSettings();
        this.dispose();
    }

    private void onCancel() {
        this.option = 2;
        this.dispose();
    }

    private void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 1, new Insets(2, 0, 2, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton3 = new JButton();
        jButton3.setText("OK");
        jPanel5.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("Cancel");
        jPanel5.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonDefault = jButton = new JButton();
        jButton.setText("Use Default");
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel6.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 300), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Scanner", jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(3, 2, new Insets(0, 10, 0, 10), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Note: change of scanner settings will clear the current search result!");
        jPanel9.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.compareTagsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Match Tags (ID3v1, ID3v1.1, ID3v2.2, ID3v2.3, ID3v2.4 and Ogg-Vorbis) (98% safe)");
        jPanel9.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.compareSoundCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setEnabled(false);
        jCheckBox2.setText("Match Sound (under development)");
        jPanel9.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.compareDataCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Match Data (CRC32 on first blocks of file) (99.99% safe)");
        jPanel9.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel8.add((Component)spacer4, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Launchers", jPanel10);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(2, 2, new Insets(0, 10, 0, 10), -1, -1, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Launch Player: ");
        jPanel12.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Launch Folder Explorer:");
        jPanel12.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.launchPlayerTextField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel12.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.launchFolderExplorerTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel12.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel11.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(3, 3, new Insets(0, 10, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("File Types", jPanel13);
        Spacer spacer7 = new Spacer();
        jPanel13.add((Component)spacer7, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel13.add((Component)spacer8, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.tagFileTypesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Match Tags"));
        JCheckBox jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("mp3");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("ogg");
        jPanel2.add((Component)jCheckBox5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.dataFileTypesPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder("Match Data"));
        JCheckBox jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("mp3");
        jPanel.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("ogg");
        jPanel.add((Component)jCheckBox7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("wma");
        jPanel.add((Component)jCheckBox8, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("aac");
        jPanel.add((Component)jCheckBox9, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("m4a");
        jPanel.add((Component)jCheckBox10, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel13.add((Component)spacer9, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            String type = cb.getText();
            if (cb.getParent() == Settings.this.dataFileTypesPanel) {
                Settings.this.repository.setDataFileType(type, cb.isSelected());
            } else if (cb.getParent() == Settings.this.tagFileTypesPanel) {
                Settings.this.repository.setTagFileType(type, cb.isSelected());
            } else if (cb.getParent() == Settings.this.soundFileTypesPanel) {
                Settings.this.repository.setSoundFileType(type, cb.isSelected());
            }
        }
    }

    public static class Repository
    implements Serializable {
        private String launchPlayer;
        private String launchFolderExplorer;
        private String[] dataDescriptorsFileTypes;
        private String[] tagDescriptorsFileTypes;
        private String[] soundDescriptorsFileTypes;
        private boolean compareData;
        private boolean compareTags;
        private boolean compareSound;
        private transient boolean scannerPropertyChanged;
        private transient boolean modified;
        private static final Log log = LogFactory.getLog(Repository.class);

        public static Repository readFromPreferences(PersistentPreferences preferences) {
            try {
                return (Repository)preferences.get(Repository.getPreferencesKey());
            }
            catch (Exception e) {
                log.error(Repository.getPreferencesKey(), e);
                preferences.remove(Repository.getPreferencesKey());
                return null;
            }
        }

        public void writeToPreferences(PersistentPreferences preferences) {
            preferences.put(Repository.getPreferencesKey(), this);
        }

        public void removeFromPreferences(PersistentPreferences preferences) {
            preferences.remove(Repository.getPreferencesKey());
        }

        public static String getPreferencesKey() {
            return "settings-" + Repository.getVersion();
        }

        public static String getVersion() {
            return "1.1";
        }

        public void setToDefaults(PersistentPreferences preferences) {
            this.launchPlayer = PlayerLauncher.getInstance().getDefaultTemplate();
            this.launchFolderExplorer = FolderExplorerLauncher.getInstance().getDefaultTemplate();
            this.compareData = true;
            this.compareTags = true;
            this.compareSound = false;
            this.dataDescriptorsFileTypes = DataDescriptors.SUPPORTED_FILE_TYPES;
            this.tagDescriptorsFileTypes = TagDescriptors.SUPPORTED_FILE_TYPES;
            this.soundDescriptorsFileTypes = SoundDescriptors.SUPPORTED_FILE_TYPES;
            this.scannerPropertyChanged = true;
            this.modified = true;
            this.removeFromPreferences(preferences);
        }

        public void initialize() {
            this.launchPlayer = PlayerLauncher.getInstance().getTemplate();
            this.launchFolderExplorer = FolderExplorerLauncher.getInstance().getTemplate();
            this.compareData = Item.isCompareData();
            this.compareTags = Item.isCompareTags();
            this.compareSound = Item.isCompareSound();
            this.dataDescriptorsFileTypes = DataDescriptors.FileTypes();
            this.tagDescriptorsFileTypes = TagDescriptors.FileTypes();
            this.soundDescriptorsFileTypes = SoundDescriptors.FileTypes();
        }

        public void establishSettings() {
            PlayerLauncher.getInstance().setTemplate(this.getLaunchPlayer());
            FolderExplorerLauncher.getInstance().setTemplate(this.getLaunchFolderExplorer());
            Item.setCompareData(this.isCompareData());
            Item.setCompareTags(this.isCompareTags());
            Item.setCompareSound(this.isCompareSound());
            DataDescriptors.SetFileTypes(this.getDataDescriptorsFileTypes());
            TagDescriptors.SetFileTypes(this.getTagDescriptorsFileTypes());
            SoundDescriptors.SetFileTypes(this.getSoundDescriptorsFileTypes());
        }

        public void makeValid() {
            if (!(this.compareData || this.compareSound || this.compareTags)) {
                this.compareData = true;
            }
        }

        public String getLaunchPlayer() {
            return this.launchPlayer;
        }

        public boolean isModified() {
            return this.modified || this.scannerPropertyChanged;
        }

        public boolean isScannerPropertyChanged() {
            return this.scannerPropertyChanged;
        }

        public void setLaunchPlayer(String launchPlayer) {
            if (launchPlayer != null && launchPlayer.equals(this.launchPlayer)) {
                return;
            }
            this.launchPlayer = launchPlayer;
            this.modified = true;
        }

        public String getLaunchFolderExplorer() {
            return this.launchFolderExplorer;
        }

        public void setLaunchFolderExplorer(String launchFolderExplorer) {
            if (launchFolderExplorer != null && launchFolderExplorer.equals(this.launchFolderExplorer)) {
                return;
            }
            this.launchFolderExplorer = launchFolderExplorer;
            this.modified = true;
        }

        public boolean isCompareData() {
            return this.compareData;
        }

        public void setCompareData(boolean compareData) {
            this.compareData = compareData;
            this.scannerPropertyChanged = true;
        }

        public boolean isCompareTags() {
            return this.compareTags;
        }

        public void setCompareTags(boolean compareTags) {
            this.compareTags = compareTags;
            this.scannerPropertyChanged = true;
        }

        public boolean isCompareSound() {
            return this.compareSound;
        }

        public void setCompareSound(boolean compareSound) {
            this.compareSound = compareSound;
            this.scannerPropertyChanged = true;
        }

        public String[] getDataDescriptorsFileTypes() {
            return this.dataDescriptorsFileTypes;
        }

        public String[] getTagDescriptorsFileTypes() {
            return this.tagDescriptorsFileTypes;
        }

        public String[] getSoundDescriptorsFileTypes() {
            return this.soundDescriptorsFileTypes;
        }

        public void setDataFileType(String type, boolean selected) {
            this.dataDescriptorsFileTypes = selected ? this.addFileType(this.dataDescriptorsFileTypes, type) : this.removeFileType(this.dataDescriptorsFileTypes, type);
            this.scannerPropertyChanged = true;
        }

        public void setTagFileType(String type, boolean selected) {
            this.tagDescriptorsFileTypes = selected ? this.addFileType(this.tagDescriptorsFileTypes, type) : this.removeFileType(this.tagDescriptorsFileTypes, type);
            this.scannerPropertyChanged = true;
        }

        public void setSoundFileType(String type, boolean selected) {
            this.soundDescriptorsFileTypes = selected ? this.addFileType(this.soundDescriptorsFileTypes, type) : this.removeFileType(this.soundDescriptorsFileTypes, type);
            this.scannerPropertyChanged = true;
        }

        private String[] addFileType(String[] fileTypes, String type) {
            String[] newTypes = new String[fileTypes.length + 1];
            System.arraycopy(fileTypes, 0, newTypes, 0, fileTypes.length);
            newTypes[fileTypes.length] = type;
            return newTypes;
        }

        private String[] removeFileType(String[] fileTypes, String type) {
            String[] newTypes = new String[fileTypes.length - 1];
            int j = 0;
            for (int i = 0; i < fileTypes.length; ++i) {
                if (fileTypes[i].equals(type)) continue;
                newTypes[j++] = fileTypes[i];
            }
            return newTypes;
        }
    }
}

