/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.EventListenerList;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.logic.DuplicateScanner;
import tigor.srdmusicduplicates.logic.Strategy;
import tigor.srdmusicduplicates.ui.Utilities;

public class StrategyPanel {
    private JFrame frame;
    private JPanel mainPanel;
    private JCheckBox matchStrictTagsCheckBox;
    private JCheckBox matchLooseTagsCheckBox;
    private JCheckBox matchTagsCheckBox;
    private JCheckBox matchSoundCheckBox;
    private JCheckBox matchDataCheckBox;
    private JRadioButton timeRadioButton;
    private JRadioButton fileLenRadioButton;
    private JRadioButton bitrateRadioButton;
    private JComboBox fileLenComboBox;
    private JComboBox timeComboBox;
    private JComboBox bitrateComboBox;
    private JRadioButton mp3RadioButton;
    private JRadioButton oggRadioButton;
    private JButton defaultsButton;
    private JButton saveButton;
    private JButton applyButton;
    private JCheckBox vbrCheckBox;
    private Strategy strategy;
    private PersistentPreferences preferences;
    private transient EventListenerList listenerList;
    private static final Object[] FILESIZE_ARRRAY = new Object[]{"bigger file", "smaller file"};

    public StrategyPanel() {
        this.$$$setupUI$$$();
        this.listenerList = new EventListenerList();
    }

    public StrategyPanel(PersistentPreferences preferences) {
        this.$$$setupUI$$$();
        this.listenerList = new EventListenerList();
        this.preferences = preferences;
        this.setUI();
    }

    public void load() {
        this.strategy = DuplicateScanner.getStrategy();
        this.updateUI();
    }

    public void show() {
        this.frame.pack();
        Utilities.center(this.frame);
        this.frame.setVisible(true);
    }

    public void addEventListener(ApplyQualityListener listener) {
        this.listenerList.add(ApplyQualityListener.class, listener);
    }

    public void ApplyQualityListener(ApplyQualityListener listener) {
        this.listenerList.remove(ApplyQualityListener.class, listener);
    }

    private void save() {
        this.strategy.writeToPreferences(this.preferences);
    }

    private void setUI() {
        if (this.frame == null) {
            this.frame = new JFrame("S&D: Strategy");
            this.frame.setContentPane(this.mainPanel);
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StrategyPanel.this.frame.setVisible(false);
            }
        });
        this.mp3RadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.mp3RadioButton.isSelected()) {
                    StrategyPanel.this.oggRadioButton.setSelected(false);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.oggRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.oggRadioButton.isSelected()) {
                    StrategyPanel.this.mp3RadioButton.setSelected(false);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.fileLenRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.fileLenRadioButton.isSelected()) {
                    StrategyPanel.this.deselectAllCriterionsExcept(StrategyPanel.this.fileLenRadioButton);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.timeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.timeRadioButton.isSelected()) {
                    StrategyPanel.this.deselectAllCriterionsExcept(StrategyPanel.this.timeRadioButton);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.bitrateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.bitrateRadioButton.isSelected()) {
                    StrategyPanel.this.deselectAllCriterionsExcept(StrategyPanel.this.bitrateRadioButton);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.matchSoundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.matchStrictTagsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.matchStrictTagsCheckBox.isSelected()) {
                    StrategyPanel.this.matchTagsCheckBox.setSelected(false);
                    StrategyPanel.this.matchLooseTagsCheckBox.setSelected(false);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.matchTagsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.matchTagsCheckBox.isSelected()) {
                    StrategyPanel.this.matchStrictTagsCheckBox.setSelected(false);
                    StrategyPanel.this.matchLooseTagsCheckBox.setSelected(false);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.matchLooseTagsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StrategyPanel.this.matchLooseTagsCheckBox.isSelected()) {
                    StrategyPanel.this.matchStrictTagsCheckBox.setSelected(false);
                    StrategyPanel.this.matchTagsCheckBox.setSelected(false);
                }
                StrategyPanel.this.updateAfterChange();
            }
        });
        this.defaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StrategyPanel.this.strategy = Strategy.defaultStrategy();
                StrategyPanel.this.strategy.removeFromPreferences(StrategyPanel.this.preferences);
                StrategyPanel.this.updateUI();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StrategyPanel.this.updateQuality();
                StrategyPanel.this.save();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StrategyPanel.this.updateQuality();
                DuplicateScanner.setStrategy(StrategyPanel.this.strategy);
                StrategyPanel.this.fireEvent(new ApplyQualityEvent(this));
            }
        });
        this.fileLenComboBox.setModel(new DefaultComboBoxModel<Object>(FILESIZE_ARRRAY));
        this.timeComboBox.setModel(new DefaultComboBoxModel<Object>(Strategy.BITRATE_DESC_ARRRAY));
        this.bitrateComboBox.setModel(new DefaultComboBoxModel<Object>(Strategy.BITRATE_DESC_ARRRAY));
        this.frame.pack();
    }

    private void updateQuality() {
        this.strategy.setCompareData(this.matchDataCheckBox.isSelected());
        this.strategy.setCompareStrictTags(this.matchStrictTagsCheckBox.isSelected());
        this.strategy.setCompareLessStrictTags(this.matchTagsCheckBox.isSelected());
        this.strategy.setCompareLooseTags(this.matchLooseTagsCheckBox.isSelected());
        this.strategy.setCompareSound(this.matchSoundCheckBox.isSelected());
        this.strategy.setPreferMp3(this.mp3RadioButton.isSelected());
        this.strategy.setPreferOgg(this.oggRadioButton.isSelected());
        this.strategy.setPreferVBR(this.vbrCheckBox.isSelected());
        this.strategy.setPreferBiggerFile(this.fileLenRadioButton.isSelected() && this.fileLenComboBox.getSelectedIndex() == 0);
        this.strategy.setPreferSmallerFile(this.fileLenRadioButton.isSelected() && this.fileLenComboBox.getSelectedIndex() == 1);
        if (this.bitrateRadioButton.isSelected() && this.bitrateRadioButton.isEnabled()) {
            this.strategy.setPreferBitrate(true);
            this.strategy.setPreferredBitrate(Strategy.BITRATE_INT_ARRAY[this.bitrateComboBox.getSelectedIndex()]);
        } else {
            this.strategy.setPreferBitrate(false);
        }
        if (this.timeRadioButton.isSelected() && this.timeRadioButton.isEnabled()) {
            this.strategy.setPreferLongerTime(true);
            this.strategy.setPreferredBitrate(Strategy.BITRATE_INT_ARRAY[this.timeComboBox.getSelectedIndex()]);
        } else {
            this.strategy.setPreferLongerTime(false);
        }
    }

    private void updateUI() {
        this.matchDataCheckBox.setSelected(this.strategy.isCompareData());
        this.matchStrictTagsCheckBox.setSelected(this.strategy.isCompareStrictTags());
        this.matchTagsCheckBox.setSelected(this.strategy.isCompareLessStrictTags());
        this.matchLooseTagsCheckBox.setSelected(this.strategy.isCompareLooseTags());
        this.matchSoundCheckBox.setSelected(this.strategy.isCompareSound());
        this.mp3RadioButton.setSelected(this.strategy.isPreferMp3());
        this.oggRadioButton.setSelected(this.strategy.isPreferOgg());
        this.vbrCheckBox.setSelected(this.strategy.isPreferVBR());
        if (this.strategy.isPreferBiggerFile()) {
            this.fileLenRadioButton.setSelected(true);
            this.fileLenComboBox.setSelectedIndex(0);
        } else if (this.strategy.isPreferSmallerFile()) {
            this.fileLenRadioButton.setSelected(true);
            this.fileLenComboBox.setSelectedIndex(1);
        } else {
            this.fileLenRadioButton.setSelected(false);
        }
        if (this.strategy.isPreferBitrate()) {
            this.bitrateRadioButton.setSelected(true);
            this.bitrateComboBox.setSelectedIndex(Strategy.indexOfBitrate(this.strategy.getPreferredBitrate()));
        } else {
            this.bitrateRadioButton.setSelected(false);
        }
        if (this.strategy.isPreferLongerTime()) {
            this.timeRadioButton.setSelected(true);
            this.timeComboBox.setSelectedIndex(Strategy.indexOfBitrate(this.strategy.getPreferredBitrate()));
        } else {
            this.timeRadioButton.setSelected(false);
        }
        this.updateAfterChange();
    }

    private void updateAfterChange() {
        if (!this.hasMpegTags()) {
            this.matchDataCheckBox.setSelected(true);
            this.matchDataCheckBox.setEnabled(false);
            this.deselectAllCriterionsExcept(this.fileLenRadioButton);
            this.disableAllCriterionsExcept(this.fileLenRadioButton);
        } else {
            this.matchDataCheckBox.setEnabled(true);
            this.enableAllCriterions();
        }
        this.fileLenComboBox.setEnabled(this.fileLenRadioButton.isSelected());
        this.timeComboBox.setEnabled(this.timeRadioButton.isSelected());
        this.bitrateComboBox.setEnabled(this.bitrateRadioButton.isSelected());
        if (this.oggRadioButton.isSelected()) {
            this.vbrCheckBox.setSelected(true);
        }
        this.vbrCheckBox.setEnabled(this.hasMpegTags() && !this.fileLenRadioButton.isSelected() && !this.oggRadioButton.isSelected());
    }

    private boolean hasMpegTags() {
        return this.matchTagsCheckBox.isSelected() || this.matchLooseTagsCheckBox.isSelected() || this.matchStrictTagsCheckBox.isSelected() || this.matchSoundCheckBox.isSelected();
    }

    private void enableAllCriterions() {
        this.fileLenRadioButton.setEnabled(true);
        this.timeRadioButton.setEnabled(true);
        this.bitrateRadioButton.setEnabled(true);
        this.fileLenRadioButton.setEnabled(true);
    }

    private void disableAllCriterionsExcept(JRadioButton button) {
        this.fileLenRadioButton.setEnabled(this.fileLenRadioButton == button);
        this.timeRadioButton.setEnabled(this.timeRadioButton == button);
        this.bitrateRadioButton.setEnabled(this.bitrateRadioButton == button);
        this.fileLenRadioButton.setEnabled(this.fileLenRadioButton == button);
    }

    private void deselectAllCriterionsExcept(JRadioButton button) {
        if (this.fileLenRadioButton != button) {
            this.fileLenRadioButton.setSelected(false);
        }
        if (this.timeRadioButton != button) {
            this.timeRadioButton.setSelected(false);
        }
        if (this.bitrateRadioButton != button) {
            this.bitrateRadioButton.setSelected(false);
        }
    }

    private void fireEvent(ApplyQualityEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ApplyQualityListener.class) continue;
            ((ApplyQualityListener)listeners[i + 1]).applyQuality(event);
        }
    }

    private void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Match duplicates strategy"));
        this.matchDataCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Data");
        jPanel2.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.matchSoundCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Sound");
        jCheckBox5.setEnabled(false);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.matchLooseTagsCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Loose Tags");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.matchTagsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Less Strict Tags");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.matchStrictTagsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Strict Tags");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Keep file criterion order"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.applyButton = jButton3 = new JButton();
        jButton3.setText("Apply");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.saveButton = jButton2 = new JButton();
        jButton2.setText("Save");
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.defaultsButton = jButton = new JButton();
        jButton.setText("Use Defaults");
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.bitrateRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Bitrate/Longer Time");
        jPanel5.add((Component)jRadioButton5, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.fileLenRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("File Length");
        jPanel5.add((Component)jRadioButton4, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.timeRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Longer Time/Bitrate");
        jPanel5.add((Component)jRadioButton3, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.bitrateComboBox = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText("bitrate");
        jPanel5.add(jComboBox3, new GridConstraints(2, 2, 1, 2, 8, 1, 2, 0, null, null, null));
        this.timeComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText("bitrate");
        jPanel5.add(jComboBox2, new GridConstraints(3, 2, 1, 2, 8, 1, 2, 0, null, null, null));
        this.fileLenComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText("bitrate");
        jPanel5.add(jComboBox, new GridConstraints(1, 2, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("1:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("2:");
        jPanel5.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("2:");
        jPanel5.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mp3RadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("mp3");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.oggRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("ogg");
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.vbrCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("VBR");
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("2:");
        jPanel5.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public static interface ApplyQualityListener
    extends EventListener {
        public void applyQuality(ApplyQualityEvent var1);
    }

    public static class ApplyQualityEvent
    extends EventObject {
        public ApplyQualityEvent(Object source) {
            super(source);
        }
    }
}

