/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.common.Bytes2String;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.common.Release;
import tigor.srdmusicduplicates.launcher.BrowserLauncher;
import tigor.srdmusicduplicates.logic.DuplicateMover;
import tigor.srdmusicduplicates.ui.AboutDialog;
import tigor.srdmusicduplicates.ui.JTextPaneWithBGImage;
import tigor.srdmusicduplicates.ui.Utilities;

public class TeaseDialog
extends JDialog {
    private JPanel contentPane;
    private DuplicateMover mover;
    private PersistentPreferences preferences;
    private JTextPaneWithBGImage donatePane;
    private JButton donateButton;
    private JButton laterButton;
    private JButton dontAskButton;
    private JButton voteButton;
    private JLabel label;
    private JTabbedPane tabbedPane;
    private static final Log log = LogFactory.getLog(AboutDialog.class);
    private JTextPane aboutGirlPane;
    private static final String DONATE_URL = "http://sourceforge.net/donate/index.php?group_id=159149";
    private static final String VOTE_URL = "http://www.download.com/Seek-and-Destroy-Music-Duplicates/3000-2141-10523962.html?part=dl-SeekandDe&subj=uo&tag=button";
    private static final long TEASE_INTERVAL_IN_BYTES = 0x20000000L;

    public TeaseDialog(Frame owner, PersistentPreferences preferences, DuplicateMover mover, boolean auto) {
        super(owner);
        this.$$$setupUI$$$();
        this.mover = mover;
        this.preferences = preferences;
        this.setup(auto);
    }

    public static boolean wantsTease(PersistentPreferences preferences, DuplicateMover mover) {
        return mover.getTotalMovedBytes(preferences) - mover.getTotalMovedBytesMark(preferences) >= 0x20000000L && !TeaseDialog.isDeactivated(preferences);
    }

    public static boolean isDeactivated(PersistentPreferences preferences) {
        Boolean deactivated = (Boolean)preferences.get(TeaseDialog.deactivationKey());
        return deactivated != null && deactivated != false;
    }

    public static void open(Frame owner, PersistentPreferences preferences, DuplicateMover mover, boolean auto) {
        TeaseDialog d = new TeaseDialog(owner, preferences, mover, auto);
        d.pack();
        Utilities.center(d);
        d.setVisible(true);
    }

    private void doClose() {
        this.dispose();
    }

    private void setup(boolean auto) {
        this.setTitle("S&D: Donation Dialog");
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.laterButton);
        this.label.setText(this.getLabel());
        this.dontAskButton.setEnabled(auto);
        this.laterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeaseDialog.this.mover.updateTotalMovedBytesMark(TeaseDialog.this.preferences);
                TeaseDialog.this.doClose();
            }
        });
        this.donateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeaseDialog.this.mover.updateTotalMovedBytesMark(TeaseDialog.this.preferences);
                try {
                    BrowserLauncher.openURL(TeaseDialog.DONATE_URL);
                }
                catch (IOException e1) {
                    log.error(e1);
                }
            }
        });
        this.voteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeaseDialog.this.mover.updateTotalMovedBytesMark(TeaseDialog.this.preferences);
                try {
                    BrowserLauncher.openURL(TeaseDialog.VOTE_URL);
                }
                catch (IOException e1) {
                    log.error(e1);
                }
            }
        });
        this.dontAskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeaseDialog.setIsDeactivated(TeaseDialog.this.preferences);
                TeaseDialog.this.doClose();
            }
        });
        URL resource = this.getClass().getResource("resources/about/About.jpg");
        if (resource != null) {
            ImageIcon bgIcon = new ImageIcon(resource);
            this.donatePane = new JTextPaneWithBGImage(bgIcon);
            this.donatePane.sizeToBGImage();
            this.donatePane.setEnabled(true);
            this.donatePane.setEditable(false);
            resource = this.getClass().getResource("resources/about/Donate.html");
            if (resource != null) {
                try {
                    this.donatePane.setPage(resource);
                }
                catch (IOException e) {
                    log.error("Can't read " + resource, e);
                }
            }
            this.tabbedPane.add((Component)this.donatePane, 0);
            this.tabbedPane.setTitleAt(0, "Donate");
            this.tabbedPane.setSelectedIndex(0);
            resource = this.getClass().getResource("resources/about/AboutTheGirl.html");
            if (resource != null) {
                try {
                    this.aboutGirlPane.setPage(resource);
                }
                catch (IOException e) {
                    log.error("Can't read " + resource, e);
                }
            }
            this.aboutGirlPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        String url = null;
                        try {
                            url = e.getURL().toString();
                            BrowserLauncher.openURL(url);
                        }
                        catch (IOException e1) {
                            log.error("Can't launch " + url, e1);
                        }
                    }
                }
            });
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    TeaseDialog.this.doClose();
                }
            });
            this.contentPane.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TeaseDialog.this.doClose();
                }
            }, KeyStroke.getKeyStroke(27, 0), 1);
        }
        this.validate();
    }

    private static void setIsDeactivated(PersistentPreferences preferences) {
        preferences.put(TeaseDialog.deactivationKey(), Boolean.TRUE);
    }

    private static String deactivationKey() {
        return "deactivate-teaser-" + new Release().getTitle();
    }

    private String getLabel() {
        return "Last removed: " + Bytes2String.format(this.mover.getMovedBytes()) + ", total removed: " + Bytes2String.format(this.mover.getTotalMovedBytes(this.preferences)) + " duplicates.";
    }

    private void $$$setupUI$$$() {
        JTextPane jTextPane;
        JTabbedPane jTabbedPane;
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(2, 2, 2, 2), 2, 2, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.donateButton = jButton4 = new JButton();
        jButton4.setText("Donate");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.laterButton = jButton3 = new JButton();
        jButton3.setText("Later");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.voteButton = jButton2 = new JButton();
        jButton2.setText("Rate");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.dontAskButton = jButton = new JButton();
        jButton.setText("Don't ask me again");
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.label = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tabbedPane = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JScrollPane jScrollPane = new JScrollPane();
        jTabbedPane.addTab("About girl", jScrollPane);
        this.aboutGirlPane = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jScrollPane.setViewportView(jTextPane);
    }
}

