
// -*-c++-*-
/* $Id: unwrap.h,v 1.4 2005/11/30 22:47:34 max Exp $ */

#ifndef _ASYNC_UNWRAP_H
#define _ASYNC_UNWRAP_H

#include "async.h"

class trig_t {
public:
  trig_t (cbv c) : _cb (c), _killed (false) {}
  ~trig_t () { if (!_killed) (*_cb) (); }
  void kill () { _killed = true; }
  static ptr<trig_t> alloc (cbv c) { return New refcounted<trig_t> (c); }
private:
  cbv _cb;
  bool _killed;
};

class closure_t : public virtual refcount {
public:
  closure_t () : _jumpto (0) {}
  virtual void reenter () = 0;
  void set_jumpto (int i) { _jumpto = i; }
  u_int jumpto () const { return _jumpto; }

protected:
  u_int _jumpto;
};

#define CLOSURE ptr<closure_t> __frame = NULL

#endif /* _ASYNC_UNWRAP_H */
