//
// Netscape Navigator plug-in wrapper.
//

#include <string.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#define stricmp strcasecmp

#include "npapi.h"

static const char playerName[] = "sidplug";
static char selectedSong = 0;  // 0 = use default
static const char logFile[] = "/tmp/sidplug.log";
static pid_t mySidplayChild = (-1);

// --------------------------------------------------------------------------

int killChild()
{
	if (mySidplayChild > 0)
	{
		if (0 != kill(mySidplayChild,SIGKILL))
			return 0;
		mySidplayChild = (-1);
		return 1;
	}
}

// --------------------------------------------------------------------------
// Netscape Plugin API functions

typedef struct _PluginInstance
{
    int nothing;
} PluginInstance;

char*
NPP_GetMIMEDescription(void)
{
 	return("audio/x-sidtune:.sid:This handles SID music files;audio/prs.sid:.sid:This handles SID music files");
}

NPError
NPP_GetValue(void *future, NPPVariable variable, void *value)
{
	NPError err = NPERR_NO_ERROR;
	
	switch (variable)
	{
	 case NPPVpluginNameString:
		*((char **)value) = "SIDPlug";
		break;
	 case NPPVpluginDescriptionString:
		*((char **)value) = "SIDPLAY wrapper plug-in, v1.1.5, requires a link from ``sidplug -> xsidplay'' for instance";
		break;
	 default:
		err = NPERR_GENERIC_ERROR;
	}
		
	return err;
}

NPError
NPP_Initialize(void)
{
	remove(logFile);
	freopen(logFile,"a",stdout);
	freopen(logFile,"a",stderr);
    fprintf(stdout,"NPP_Initialize()\n");
    fflush(stdout);
	
    return NPERR_NO_ERROR;
}

jref
NPP_GetJavaClass()
{
    fprintf(stdout,"NPP_GetJavaClass()\n");
    fflush(stdout);

    return NULL;
}

void
NPP_Shutdown(void)
{
    fprintf(stdout,"NPP_Shutdown()\n");
    fflush(stdout);
}

NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
	int x, i;
	int inputFileArg = (-1);
	int mimeTypeArg = (-1);

    fprintf(stdout,"NPP_New()\n");
    fflush(stdout);

	i = 0;
	while (i < argc)
	{
        fprintf(stdout,"    %s = %s\n",argn[i],argv[i]);
        fflush(stdout);

		if (stricmp("SRC",argn[i]) == 0)
			inputFileArg = i;
		else if (stricmp("TYPE",argn[i]) == 0)
			mimeTypeArg = i;
		else if (stricmp("SONG",argn[i]) == 0)
			selectedSong = atoi(argv[i]);
#ifdef CONFIGURABLE
		else if (stricmp("FILTER",argn[i]) == 0)
			myEmuConfig.emulateFilter = ((stricmp("true",argv[i]) == 0));
		else if (stricmp("FREQUENCY",argn[i]) == 0)
			myEmuConfig.frequency = atol(argv[i]);
		else if (stricmp("BITS",argn[i]) == 0)
		{
			if (atoi(argv[i]) == 8)
			{
				myEmuConfig.bitsPerSample = SIDEMU_8BIT;
				myEmuConfig.sampleFormat = SIDEMU_UNSIGNED_PCM;
			}
			else if (atoi(argv[i]) == 16)
			{
				myEmuConfig.bitsPerSample = SIDEMU_16BIT;
				myEmuConfig.sampleFormat = SIDEMU_SIGNED_PCM;
			}
		}
		else if (stricmp("STEREO",argn[i]) == 0)
		{
			if (stricmp("true",argv[i]) == 0)
				myEmuConfig.channels = SIDEMU_STEREO;
			else if (stricmp("false",argv[i]) == 0)
				myEmuConfig.channels = SIDEMU_MONO;
		}
		else if (stricmp("SURROUND",argn[i]) == 0)
		{
			if (stricmp("true",argv[i]) == 0)
				myEmuConfig.volumeControl = SIDEMU_STEREOSURROUND;
		}
		else if (stricmp("PANNING",argn[i]) == 0)
		{
			if (atoi(argv[i]) == 0)
				myEmuConfig.autoPanning = SIDEMU_NONE;
			else if (atoi(argv[i]) == 1)
				myEmuConfig.autoPanning = SIDEMU_AUTOPANNING;
			else if (atoi(argv[i]) == 2)
				myEmuConfig.autoPanning = SIDEMU_CENTEREDAUTOPANNING;
		}
#endif
		i++;
	};

	// Check MIME-type!
	if (mimeTypeArg >= 0)
	{
		if ((stricmp("audio/prs.sid",argv[mimeTypeArg]) != 0)
			&& (stricmp("audio/x-sidtune",argv[mimeTypeArg]) != 0))
		{
			fprintf(stderr,"Invalid MIME type!\n");
            fflush(stderr);
			return NPERR_NO_DATA;
		}
	}

	killChild();

    return NPERR_NO_ERROR;
}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;
	
    fprintf(stdout,"NPP_Destroy()\n");
    fflush(stdout);

	killChild();
	
	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	if (This != NULL) {
		NPN_MemFree(instance->pdata);
		instance->pdata = NULL;
	}

	return NPERR_NO_ERROR;
}

NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	PluginInstance* This;

    fprintf(stdout,"NPP_SetWindow()\n");
    fflush(stdout);

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	if (window == NULL)
		return NPERR_NO_ERROR;

	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}

NPError 
NPP_NewStream(NPP instance,
			  NPMIMEType type,
			  NPStream *stream, 
			  NPBool seekable,
			  uint16 *stype)
{
	NPError result = NPERR_GENERIC_ERROR;

	if (instance == NULL)
		result = NPERR_INVALID_INSTANCE_ERROR;
	else
	{
		PluginInstance* This = (PluginInstance*) instance->pdata;
		*stype = NP_ASFILEONLY;
        result = NPERR_NO_ERROR;
    }

    fprintf(stdout,"NPP_NewStream = %d\n",result);
    fflush(stdout);
	return result;
}

int32 STREAMBUFSIZE = 0X0FFFFFFF;

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
    fprintf(stdout,"NPP_WriteReady()\n");
    fflush(stdout);

	return STREAMBUFSIZE;
}


int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
    fprintf(stdout,"NPP_Write()\n");
    fflush(stdout);

	return len;
}

NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
    fprintf(stdout,"NPP_Destroy()\n");
    fflush(stdout);

	return NPERR_NO_ERROR;
}

void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	
	pid_t thisPID;
	char* argv[5];
	int a = 0;
	char songStr[15];
		
    fprintf(stdout,"NPP_StreamAsFile()\n");
    fflush(stdout);
    
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;
	
	if ( fname==NULL || fname[0]=='\0' )
		return;

    fprintf(stdout,"    File name = %s\n",fname);
    fflush(stdout);

	// ----------------------------------------------------------------------
	
	thisPID = fork();  // create child process
	if (thisPID < 0)
		return;
	else if (thisPID > 0)  // parent
		mySidplayChild = thisPID;  // save pid to later kill child
	else  // child
	{
		argv[a++] = strdup(playerName);
		argv[a++] = strdup(fname);
		if (selectedSong != 0)
		{
			sprintf(songStr,"-o%d",selectedSong);
			argv[a++] = songStr;
		}
		argv[a++] = 0;
		execvp(playerName,argv);  // replace child

		// Error condition if we get here.
		exit(-1);
	}
}

void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
    fprintf(stdout,"NPP_Print()\n");
    fflush(stdout);

	if (printInfo == NULL)
		return;
}
