#ifndef SKADNS_INTERNAL_H
#define SKADNS_INTERNAL_H

#include "uint16.h"
#include "buffer.h"
#include "bufalloc.h"
#include "skadns.h"

typedef enum { STATE_FREE = 0, STATE_SENT = 1, STATE_ARRIVED = 2, STATE_ERROR = 3, STATE_TIMEOUT = 4 } state_t ;

struct skadnsanswer
{
  state_t state ;
  stralloc data ;
} ;

struct skadnsinfo
{
  int fdr ;
  int fdw ; /* equal to fdr if socket */
  int pid ; /* undef if socket */
  unsigned int num ;
  unsigned int instate ;
  buffer in ;
  bufalloc out ;
  uint16 cur ;
  uint16 list[SKADNS_MAXCONCURRENCY] ;
  struct skadnsanswer q[SKADNS_MAXCONCURRENCY] ;
  char inbuf[BUFFER_INSIZE] ;
} ;

#endif
