#include "stralloc.h"
#include "skadns.h"

int skadns_ip4_check (stralloc *out, char const *s, unsigned int len)
{
  char code = 0 ;
  unsigned int i ;

  out->len = 0 ;
  for (i = 0 ; i <= len ; ++i)
  {
    char ch = (i < len) ? s[i] : '.' ;

    if ((ch == '[') || (ch == ']')) ;
    else if (ch == '.')
    {
      if (!stralloc_catb(out, &code, 1)) return -1 ;
      code = 0 ;
    }
    else if ((ch >= '0') && (ch <= '9'))
      code = 10 * code + (ch - '0') ;
    else
    {
      stralloc_free(out) ;
      return 0 ;
    }
  }
  return out->len ;
}
