/* MT-unsafe */

#include <errno.h>
#include "uint16.h"
#include "allreadwrite.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "djbunix.h"
#include "netstring.h"
#include "skadns.h"
#include "skadns_internal.h"

/*
    readanswers:
    We'd like to have fdout blocking and fdin non-blocking,
    but the socket API prevents it with the silly "one rw fd" concept.
    (Please kill the API designers. Slowly.)
    - so we workaround by changing the mode at run-time.
    This is not thread-safe : if you want to use threads, then allocate
    a new skadnsinfo for each thread. (Failure to do so would be insane
    anyway.)
    If we're using the forked version, there's no problem.
*/

int skadns_readanswers (skadnsinfo_ref a)
{
  static stralloc sa = GEN_ALLOC_ZERO ; /* normal use max leak = 3 bytes */
  int count = 0 ;
  int r ;
  if ((a->fdr == a->fdw) && (ndelay_on(a->fdr) == -1)) return -1 ;
  sa.len = 0 ;
  while ((r = sanitize_read(netstring_get(&a->in, &sa, &a->instate))) > 0)
  {
    char status ;
    uint16 id ;
    if (sa.len < 3)  /* server sent garbage */
    {
      sa.len = 0 ;
      continue ;
    }
    status = sa.s[sa.len - 1] ;
    uint16_unpack_big(sa.s + sa.len - 3, &id) ;
    sa.len -= 3 ;
    switch (status)
    {
      case 'D' :
      {
        a->q[id].state = STATE_ERROR ;
        a->list[count++] = id + 1 ;
        break ;
      }
      case 'T' :
      {
        a->q[id].state = STATE_TIMEOUT ;
        a->list[count++] = id + 1 ;
        break ;
      }
      case 'K' :
      {
        a->q[id].state = STATE_ARRIVED ;
        a->q[id].data = sa ;
        a->list[count++] = id + 1 ;
        sa.s = 0 ;
        break ;
      }
    }
    sa.len = 0 ;
  }
  if (a->fdr == a->fdw)
  {
    register int e = errno ;
    if (ndelay_off(a->fdr) == -1) return -1 ;
    errno = e ;
  }
  return (r == -1) ? -1 : count ;
}
