#include "uint16.h"
#include "bytestr.h"
#include "stralloc.h"
#include "skadns.h"
#include "skadns_internal.h"

int skadns_recv (skadnsinfo_ref a, uint16 id, stralloc *sa)
{
  if (!id) return -1 ;
  switch(a->q[id-1].state)
  {
    case STATE_FREE : return -1 ;
    case STATE_SENT : return 0 ;
    case STATE_ERROR :
    {
      byte_zero(&a->q[id-1], sizeof(struct skadnsanswer)) ;
      a->num-- ;
      return -2 ;
    }
    case STATE_TIMEOUT :
    {
      byte_zero(&a->q[id-1], sizeof(struct skadnsanswer)) ;
      a->num-- ;
      return -3 ;
    }
    case STATE_ARRIVED :
    {
      *sa = a->q[id-1].data ;
      byte_zero(&a->q[id-1], sizeof(struct skadnsanswer)) ;
      return a->num-- ;
    }
    default : return -1 ;
  }
}
