#include "uint16.h"
#include "bytestr.h"
#include "bufalloc.h"
#include "stralloc.h"
#include "netstring.h"
#include "skadns.h"
#include "skadns_internal.h"

uint16 skadns_send_tmp (skadnsinfo_ref a, char const *q, char const qtype[2], stralloc *tmp)
{
  unsigned int tmpbase = tmp->len ;
  char pack[2] ;
  if (a->num >= SKADNS_MAXCONCURRENCY) return 0 ;
  while (a->q[a->cur].state != STATE_FREE)
    if (++a->cur >= SKADNS_MAXCONCURRENCY) a->cur = 0 ;
  if (!stralloc_readyplus(tmp, 4 + str_len(q))) return 0 ;
  stralloc_cats(tmp, q) ;
  stralloc_catb(tmp, qtype, 2) ;
  uint16_pack_big(pack, a->cur) ;
  stralloc_catb(tmp, pack, 2) ;
  if (netstring_putba(&a->out, tmp->s + tmpbase, tmp->len - tmpbase) < 0)
  {
    tmp->len = tmpbase ;
    return 0 ;
  }
  tmp->len = tmpbase ;
  if (bufalloc_flush(&a->out) == -1) return 0 ;
  a->q[a->cur].state = STATE_SENT ;
  a->num++ ;
  return 1 + a->cur ;
}
