#include <unistd.h>
#include <errno.h>
#include "allreadwrite.h"
#include "alloc.h"
#include "bytestr.h"
#include "buffer.h"
#include "bufalloc.h"
#include "djbunix.h"
#include "webipc.h"
#include "skadns.h"
#include "skadns_internal.h"

skadnsinfo_ref skadns_start ()
{
  skadnsinfo_ref a = (skadnsinfo_ref)alloc(sizeof(skadnsinfo)) ;
  if (!a) return 0 ;
  byte_zero(a, sizeof(skadnsinfo)) ;
  if ((a->fdr = ipc_stream()) == -1) goto erra ;
  if ((coe(a->fdr) == -1)
   || (ipc_connect(a->fdr, SKADNS_IPCPATH) == -1)) goto err ;
  a->fdw = a->fdr ;
  {
    char c ;
    if ((allread(a->fdr, &c, 1) < 1) || (c != 'K')) goto err ;
  }
  buffer_init(&a->in, &buffer_unixread, a->fdr, a->inbuf, BUFFER_INSIZE) ;
  bufalloc_init(&a->out, &fd_write, a->fdw) ;
  return a ;

err:
  fd_close(a->fdr) ;
erra:
  alloc_free((char *)a) ;
  return 0 ;
}
