#include <unistd.h>
#include <errno.h>
#include "allreadwrite.h"
#include "alloc.h"
#include "bytestr.h"
#include "buffer.h"
#include "bufalloc.h"
#include "djbunix.h"
#include "skadns.h"
#include "skadns_internal.h"

skadnsinfo_ref skadns_startf ()
{
  int p[2][2] ;
  skadnsinfo_ref a = (skadnsinfo_ref)alloc(sizeof(skadnsinfo)) ;
  if (!a) return 0 ;
  byte_zero(a, sizeof(skadnsinfo)) ;
  if (pipe(p[0]) == -1) goto erra ;
  if (pipe(p[1]) == -1) goto errp0 ;

  switch (a->pid = fork())
  {
    case -1: goto err ;
    case 0 :
    {
      char *childargv[2] = { SKADNSD_PROG, 0 } ;
      char *childenvp[1] = { 0 } ;
      if ((fd_close(p[0][0]) == -1)
       || (fd_close(p[1][1]) == -1)
       || (fd_move(0, p[1][0]) == -1)
       || (fd_move(1, p[0][1]) == -1)) _exit(111) ;
      execve(childargv[0], childargv, childenvp) ;
      _exit(111) ;
    }
  }
  fd_close(p[0][1]) ;
  fd_close(p[1][0]) ;
  a->fdr = p[0][0] ;
  a->fdw = p[1][1] ;
  coe(a->fdr) ;
  coe(a->fdw) ;
  {
    char c ;
    if ((allread(a->fdr, &c, 1) < 1) || (c != 'K'))
    {
      register int e = errno ;
      fd_close(p[1][1]) ;
      errno = e ;
      goto errp00 ;
    }
  }
  if (ndelay_on(a->fdr) == -1)
  {
    fd_close(p[1][1]) ;
    goto errp00 ;
  }
  buffer_init(&a->in, &buffer_unixread, a->fdr, a->inbuf, BUFFER_INSIZE) ;
  bufalloc_init(&a->out, &fd_write, a->fdw) ;
  return a ;

err:
  fd_close(p[1][1]) ;
  fd_close(p[1][0]) ;
errp0:
  fd_close(p[0][1]) ;
errp00:
  fd_close(p[0][0]) ;
erra:
  alloc_free((char *)a) ;
  return 0 ;
}
