#include <unistd.h>
#include <errno.h>
#include "allreadwrite.h"
#include "uint16.h"
#include "error.h"
#include "strerr2.h"
#include "bytestr.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "buffer.h"
#include "bufalloc.h"
#include "netstring.h"
#include "tai.h"
#include "iopause.h"
#include "djbunix.h"
#include "skamisc.h"
#include "dns_transmit.h"
#include "skadns.h"

char const *PROG = "skadnsd" ;

struct dnsio
{
  unsigned int next ;
  unsigned int xindex ;
  uint16 id ; /* 0 = unallocated */
  struct dns_transmit dt ;
} ;

static inline void die (void)
{
  strerr_diefu1sys(111, "run") ;
}

int main ()
{
  struct dnsio a[1+SKADNS_MAXCONCURRENCY] ;  /* a[0] = sentinel */
  iopause_fd x[2+SKADNS_MAXCONCURRENCY] ;
  unsigned int maxconn = SKADNS_MAXCONCURRENCY, numconn = 0, lasti = 1, instate = 0 ;
  stralloc indata = GEN_ALLOC_ZERO ;

  byte_zero(a, (1+maxconn) * sizeof(struct dnsio)) ;
  x[0].fd = 0 ; x[1].fd = 1 ;

  ndelay_on(0) ;
  if (allwrite(1, "K", 1) < 1)
    strerr_diefu1sys(111, "sync with client") ;
  ndelay_on(1) ;

  for (;;)
  {
    struct taia stamp, deadline ;
    unsigned int i = a[0].next, j = 2 ;

    x[0].events = IOPAUSE_EXCEPT | ((numconn < maxconn) ? IOPAUSE_READ : 0) ;
    x[1].events = IOPAUSE_EXCEPT | (bufalloc_len(bufalloc_1) ? IOPAUSE_WRITE : 0) ;
    taia_now(&stamp) ;
    taia_addsec(&deadline, &stamp, 3600) ;
    for (; i > 0 ; i = a[i].next, j++)
    {
      dns_transmit_io(&a[i].dt, x + j, &deadline) ;
      a[i].xindex = j ;
    }

    iopause(x, 2 + numconn, numconn ? &deadline : 0, &stamp) ;

   /*  client closed => exit  */
    if ((x[0].revents | x[1].revents) & IOPAUSE_EXCEPT) break ;

   /*  client reading => flush  */
    if (x[1].revents & IOPAUSE_WRITE)
      if ((bufalloc_flush(bufalloc_1) == -1) && !error_isagain(errno))
        strerr_diefu1sys(111, "flush stdout") ;

   /*  scan pending connections  */
    for (j = 0, i = a[0].next ; i ; j = i, i = a[i].next)
    {
      char pack[3] ;
      int r = dns_transmit_get(&a[i].dt, x + a[i].xindex, &stamp) ;
      if (!r) continue ;
      uint16_pack_big(pack, a[i].id - 1) ;
      if (r > 0)
      {
        unsigned int tmpbase = satmp.len ;
        if (!stralloc_readyplus(&satmp, a[i].dt.packetlen + 3)) die() ;
        stralloc_catb(&satmp, a[i].dt.packet, a[i].dt.packetlen) ;
        dns_transmit_free(&a[i].dt) ;
        stralloc_catb(&satmp, pack, 2) ;
        stralloc_catb(&satmp, "K", 1) ;
        if (!netstring_putba(bufalloc_1, satmp.s + tmpbase, satmp.len - tmpbase)) die() ;
        satmp.len = tmpbase ;
      }
      else
      {
 /*
    TODO: find a better characterization of timeouts. The dns_transmit
          documentation is rather vague on the subject.
 */
        pack[2] = (error_isagain(errno) || (errno == EIO)) ? 'D' : 'T' ;
        if (!netstring_putba(bufalloc_1, pack, 3)) die() ;
      }
      a[j].next = a[i].next ;
      a[i].id = 0 ;
      i = j ;
      numconn-- ;
    }

   /*  client writing => get the stuff and send it */
    if (buffer_len(buffer_0) || (x[0].revents & IOPAUSE_READ))
    {
      int r = 1 ;
      for (;;)
      {
        uint16 tmp ;
        char qtype[2] ;
        char servers[64] ;
        int d = -1 ;
        if (numconn >= maxconn) break ;
        r = netstring_get(buffer_0, &indata, &instate) ;
        if (r <= 0) break ;
        i = lasti ;
        while (a[i].id) i = i % maxconn + 1 ;
        lasti = i ;
        byte_zero(&a[i].dt, sizeof(struct dns_transmit)) ;
        uint16_unpack_big(indata.s + indata.len - 2, &tmp) ;
        indata.len -= 2 ;
        qtype[0] = indata.s[indata.len - 2] ;
        qtype[1] = indata.s[indata.len - 1] ;
        indata.len -= 2 ;
        stralloc_0(&indata) ;
        if (dns_resolvconfip(servers) != -1)
          d = dns_transmit_start(&a[i].dt, servers, 1, indata.s, qtype, "\0\0\0") ;
        indata.len = 0 ;
        if (d == -1) /* report failure */
        {
          char pack[3] ;
          uint16_pack_big(pack, tmp) ;
          pack[2] = 'D' ;
          if (!netstring_putba(bufalloc_1, pack, 3)) die() ;
        }
        else /* queue it */
        {
          a[i].id = tmp + 1 ;
          a[i].next = a[0].next ;
          a[0].next = i ;
          numconn++ ;
        }
      }
      if (!r) break ; /* client closed */
      if ((r == -1) && !error_isagain(errno))
        strerr_diefu1sys(111, "read a netstring") ;
    }
  } /* main iopause loop */
  return 0 ;
}
