#include "uint16.h"
#include "bytestr.h"
#include "fmtscan.h"
#include "buffer.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "iopause.h"
#include "dns.h"
#include "skadns.h"

char const *PROG = "skadnsip" ;
#define USAGE "skadnsip fqdn"

int main (int argc, char const *const *argv)
{
  stralloc out = GEN_ALLOC_ZERO ;
  char const *fqdn ;
  unsigned int fqdnlen ;
  char str[IP4_FMT] ;
  int r ;

  if (argc < 2) strerr_dieusage(100, USAGE) ;

  fqdn = argv[1] ;
  fqdnlen = str_len(fqdn) ;

  r = skadns_ip4_check(&out, fqdn, fqdnlen) ;
  if (r == -1) strerr_diefu1sys(111, "check") ;

  if (!r)
  {
    uint16 id ;
    uint16 idrecv ;
    iopause_fd x[1] ;
    skadnsinfo_ref a = skadns_startf() ;
    if (!a) strerr_diefu2sys(111, "run ", SKADNSD_PROG) ;

    id = skadns_ip4_send(a, fqdn, fqdnlen) ;
    if (!id)
      strerr_diefu2sys(111, "send query for ", argv[1]) ;

    x[0].fd = skadns_fd(a) ;
    x[0].events = IOPAUSE_READ|IOPAUSE_EXCEPT ;
    iopause(x, 1, 0, 0) ;

    skadns_readanswers(a) ;
    idrecv = skadns_recvlist(a)[0] ;
    if (id != idrecv) strerr_dief1x(101, "query id mismatch") ;
    skadns_ip4_recv(a, id, &out) ;
    skadns_end(a) ;
  }

  if (out.len) buffer_putalign(buffer_1small, str, ip4_fmt(str, out.s)) ;
  if (buffer_putflush(buffer_1small, "\n", 1) == -1)
    strerr_diefu1sys(111, "write to stdout") ;
  return 0 ;
}
