#include "uint16.h"
#include "bytestr.h"
#include "fmtscan.h"
#include "buffer.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "iopause.h"
#include "dns.h"
#include "skadns.h"

char const *PROG = "skadnsmx" ;
#define USAGE "skadnsmx fqdn"

int main (int argc, char const *const *argv)
{
  stralloc out = GEN_ALLOC_ZERO ;
  char const *fqdn ;
  unsigned int fqdnlen ;
  int r ;

  if (argc < 2) strerr_dieusage(100, USAGE) ;

  fqdn = argv[1] ;
  fqdnlen = str_len(fqdn) ;

  r = skadns_ip4_check(&out, fqdn, fqdnlen) ;
  if (r == -1) strerr_diefu1sys(111, "check") ;

  if (!r)
  {
    uint16 id ;
    uint16 idrecv ;
    iopause_fd x[1] ;
    skadnsinfo_ref a = skadns_startf() ;
    if (!a) strerr_diefu2sys(111, "run ", SKADNSD_PROG) ;

    id = skadns_mx_send(a, fqdn, fqdnlen) ;
    if (!id)
      strerr_diefu2sys(111, "send query for ", argv[1]) ;

    x[0].fd = skadns_fd(a) ;
    x[0].events = IOPAUSE_READ|IOPAUSE_EXCEPT ;
    iopause(x, 1, 0, 0) ;

    skadns_readanswers(a) ;
    idrecv = skadns_recvlist(a)[0] ;
    if (id != idrecv) strerr_dief1x(101, "query id mismatch") ;
    skadns_mx_recv(a, id, &out) ;
    skadns_end(a) ;
  }
  {
    char fmt[FMT_ULONG] ;
    unsigned int n = 0 ;
    while (n < out.len)
    {
      unsigned int len = str_len(out.s + n + 2) ;
      uint16 priority ;
      uint16_unpack_big(out.s + n, &priority) ;
      buffer_putalign(buffer_1small, fmt, fmt_uint(fmt, priority)) ;
      buffer_putalign(buffer_1small, " ", 1) ;
      buffer_putalign(buffer_1small, out.s + n + 2, len) ;
      n += len + 3 ;
      if (buffer_putflush(buffer_1small, "\n", 1) == -1)
        strerr_diefu1sys(111, "write to stdout") ;
    }
  }
  return 0 ;
}
