/*
 * relay.h
 *
 * Description:	Basic definitions and Function prototypes
 *
 */

#ifndef _RELAY_H
#define _RELAY_H 1

/* check_connect return codes */
#define HOST_FOUND	1
#define HOST_UNKNOWN	0
#define ERROR_INT	-1
#define NOREC_DOMAIN	-2
#define NOREC_CLIENT	-3
#define NOREC_MX	-4

#define DNS_RETRANS	2
#define DNS_RETRY	2

int resolver_init ();
void resolver_close ();

int find_user (char *usersfile, char *name);
int check_relay (char *conn, char *access_db);
int check_dnsbl (char *dnsbl_domain, char *client_addr, int cache_time);
int check_connect (char *client_addr, char *domain_name, int cache_time);
int check_local (char *conn);
int verify (char *mail_addr, char *mail_host, char *msg_id, char *domain, int cache_time);

#endif /* RELAY */
