/*
 * smc-milter.h
 *
 * Description: Basic configuration
 *
 */

#ifndef _SMC_H
#define _SMC_H 1

#define PROJECT_NAME	"Sendmail Confirmation System (SMC)."
#define MILTER		"SMC-milter"
#define PROGNAME	"smc-milter"
#define VERSION		"1.6"
#define COPYRIGHT	"Copyright (c) 2003-2005 Alexander Djourik. All rights reserved."
#define DEVELOPERS	"Developed by:\n\n \
	Alexander Djourik <adju@iszf.irk.ru>\n \
	Anton Gorbunov <anton@iszf.irk.ru>\n \
	Pavel Zhilin <pzh@iszf.irk.ru>"

#define STAT_LOCAL	1
#define STAT_RELAY	2
#define STAT_BLOCK	4
#define STAT_WLIST	8
#define STAT_ULIST	16
#define STAT_CHECK	32

#define RBL_ID		"rbl"
#define DUL_ID		"dul"
#define RGX_ID		"rgx"

#define MAILER_HEADER	"X-Mailer"
#define FLAG_HEADER	"X-Spam-Flag"
#define REPORT_HEADER	"X-Spam-Report"
#define CHECKER_HEADER	"X-Spam-Checker-Version"
#define KAV_HEADER	"X-Antivirus-Report"
#define DEFAULT_USER	"root"
#define DEFAULT_DOMAIN	"localhost"
#define POSTMASTER	"postmaster"

#define SOCKET_TIMEOUT	1800
#define MQUEUE_COST	300
#define MQUEUE_LIMIT	1
#define MQUEUE_LIFETIME 3600
#define ACCESS_LIFETIME 604800
#define CACHE_LIFETIME  86400
#define MAXREC_LIMIT	100000

#define SM_ACCESS_FILE	"/etc/mail/access"

#define CONFDIR		"/opt/SMC"
#define STATEDIR	"/var"

#define CONFIG_FILE	CONFDIR "/smc-milter.conf"
#define USERS_FILE	CONFDIR "/smc-milter.users"
#define POLICY_FILE	CONFDIR "/smc-milter.policy"
#define SOCKET_FILE	STATEDIR "/run/smc-milter.sock"
#define PID_FILE	STATEDIR "/run/smc-milter.pid"
#define TMP_FILE        STATEDIR "/tmp/smc-file.XXXXXX"

#define MAXMX		8
#define MAXLINE		4096
#define HEADER_SIZE	MAXLINE
#define HEX_DIGEST	"0123456789ABCDEF"
#define MD5_STRING_LENGTH (MD5_DIGEST_LENGTH * 2)

#endif /* SMC */
