# $Id: TConfigfileBuffer.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

class TConfigfileBuffer {
    inherit itk::Widget
    #inherit iwidgets::Scrolledtext

    
    private {
	variable CFileName
	variable CType
	variable CFilM
	variable CSesM
	variable CChanged
	variable CClipboard
	variable CParent
	variable CText
	variable CUndoBuffer ;#Object
    }

    itk_option define -editable state State 1

    method getXName {} {
	if {$CChanged} {
	    return "* $CFileName"
	} else {
	    return ". $CFileName"
	}
    }

    variable CSel1
    variable CSel2
    
    method getSelectionIndices {} {
	set il [$itk_component(text) tag ranges sel]
	if {[llength $il]!=2} {
	    TInformer $itk_interior.mess \
		-information "Invalid selection!" -vanishafter 3
	    set CSel1 ""
	    set CSel2 ""
	    return 0
	}
	set CSel1 [lindex $il 0]
	set CSel2 [lindex $il 1]
	return 1
    }
    method bufclear {} {
	if {![getSelectionIndices]} { return }
	$itk_component(text) delete $CSel1 $CSel2
    }
    method bufcopy {} {
	if {![getSelectionIndices]} { return }

	clipboard clear
	clipboard append --    "[$itk_component(text) get $CSel1 $CSel2]"

	$CClipboard clipclear
	$CClipboard clipappend "[$itk_component(text) get $CSel1 $CSel2]"
    }
    method selall {} { $itk_component(text) tag add sel 0.0 end }
    method unselall {} { $itk_component(text) tag remove sel 0.0 end }
    method buffers {} { $CParent buffers}
    method closeEditor {} { $CParent close}
    method bufcut {} {
	if {![getSelectionIndices]} { return }

	clipboard clear
	clipboard append --    "[$itk_component(text) get $CSel1 $CSel2]"

	$CClipboard clipclear
	$CClipboard clipappend "[$itk_component(text) get $CSel1 $CSel2]"

	$itk_component(text) delete $CSel1 $CSel2
    }
    method bufpaste {} {
	$itk_component(text) insert insert "[$CClipboard clipget]"
    }
    method bufpasteFromSystem {} {
	global __TConfigfileBuffer
	if { ![catch {set __TConfigfileBuffer(seltext) "[selection get]"}] } {
	    $itk_component(text) insert insert $__TConfigfileBuffer(seltext)
	}
    }
    method takeFocus {} { focus [$itk_component(text) childsite] }
    method textwidget {} { return $itk_component(text) }
    constructor {aType aParent aFileName aFilM aSesM args} {
	set CFileName  $aFileName
	set CType      $aType
	set CFilM      $aFilM
	set CSesM      $aSesM
	set CClipboard $aParent
	set CParent    $aParent

	set CUndoBuffer       [TLimitedFIFO \#auto 50]
	
	set wid $itk_interior.f

	itk_component add mainframe {frame $wid -relief ridge -bd 2 } {keep -background}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add text {
	    iwidgets::scrolledtext $itk_component(mainframe).text \
		-visibleitems 80x25 \
		-wrap none \
		-setgrid true \
		-spacing1 0 -spacing2 0 -spacing3 0 \
		-textfont scDef \
		-exportselection true \
		-textbackground $TColor::SCBGdef \
		-foreground $TColor::SCFGdef \
		-insertbackground $TColor::SCcursor 
	} {ignore -background}
	pack $itk_component(text) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	bind [$itk_component(text) childsite] <KeyPress>           "[code $this changed]"
	bind [$itk_component(text) childsite] <ButtonRelease>      "[code $this newIndex]"
	bind [$itk_component(text) childsite] <KeyRelease>         "[code $this newIndex]"

	foreach ev [list Shift_L Shift_R Alt_L Alt_R Control_L Control_R] {
	    bind [$itk_component(text) childsite] <KeyPress-$ev> "break"
	    bind [$itk_component(text) childsite] <KeyRelease-$ev> "break"
	}

	bind [$itk_component(text) childsite] <Control-KeyPress-w> "[code $this bufcut];break"
	bind [$itk_component(text) childsite] <Alt-KeyPress-w>     "[code $this bufcopy];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-y> "[code $this bufpaste];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-Y> "[code $this bufpasteFromSystem];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-c> "[code $this bufclear];break"

	bind [$itk_component(text) childsite] <Control-KeyPress-minus>      "[code $this redo];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-underscore> "[code $this undo];break"
	bind [$itk_component(text) childsite] <Control-KeyRelease-minus>      "break"
	bind [$itk_component(text) childsite] <Control-KeyRelease-underscore> "break"
	bind [$itk_component(text) childsite] <Control-KeyPress-l>     "[code $this syntaxhl];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-L>     "[code $this syntaxunhl];break"
	bind [$itk_component(text) childsite] <Alt-Control-KeyPress-\> "[code $this align];break"
	bind [$itk_component(text) childsite] <KeyPress-Tab>           "[code $this alignline];break"
	bind [$itk_component(text) childsite] <Control-KeyPress-Tab>   "[code $this insertTab];break"

	bind [$itk_component(text) childsite] <Control-x><Control-b>   "[code $this buffers];break"
	bind [$itk_component(text) childsite] <Control-x><Control-s>   "[code $this save];break"
	bind [$itk_component(text) childsite] <Control-x><Control-c>   "[code $this closeEditor];break"

	foreach cat [list def comment string command variable special] {
	    set colorname TColor::SCFG$cat
	    eval set color $$colorname
	    [$itk_component(text) childsite] tag configure $cat -foreground $color
	}

	set CText [$itk_component(text) childsite]



	itk_component add statframe {frame $itk_component(mainframe).sf -relief raised -bd 1 } {keep -background}
	pack $itk_component(statframe) -side bottom -fill x -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	itk_component add statchange {
	    label $itk_component(statframe).change -width 15 -bd 1 -relief raised -anchor w -justify left
	} {keep -background}
	itk_component add stattype {
	    label $itk_component(statframe).type -width 15 -bd 1 -relief raised -anchor w -justify left
	} {keep -background}
	pack $itk_component(statchange) $itk_component(stattype) \
	    -side left -fill none -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0

	switch $CType {
	    sys {
		$itk_component(statchange) configure -text "unchangeable"
		$itk_component(stattype)   configure -text "SMM++ script"
	    }
	    ses {
		$itk_component(statchange) configure -text "unchanged"
		$itk_component(stattype)   configure -text "session script"
	    }
	    user {
		$itk_component(statchange) configure -text "unchanged"
		$itk_component(stattype)   configure -text "user script"
	    }
	}
	set CChanged 0

	itk_component add statname {
	    label $itk_component(statframe).name -text $CFileName \
		-width 30 -bd 1 -relief raised -anchor w -justify left
	} {keep -background}
	pack $itk_component(statname) \
	    -side left -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add index {
	    label $itk_component(statframe).index -width 9 -bd 1 -relief raised \
		-anchor w -justify right -text "0.0"
	} {keep -background}
	pack $itk_component(index) \
	    -side right -fill none -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0


	loadit
	eval itk_initialize $args
	
	$CUndoBuffer insert "[$CText get 1.0 end]"
	if {[$CParent isAutosh]} {
	    syntaxhl
	}

    }
    method getBracketLevel {aStr} {
	set qmode 0
	set l [string length $aStr]
	set b 0

	for {set i 0} {$i<$l} {incr i} {
	    set c [string index $aStr $i]
	    switch -- $qmode {
		0   { switch -- $c {
		    "\{" { incr b }
		    "\}" { incr b -1 }
		    "\\" { incr i }
		    "\"" { set qmode 1 } }
		} 1 { switch -- $c {
		    "\\" { incr i }
		    "\"" { set qmode 0 } }
		}
	    }
	}
	return $b
    }
    method syntaxunhl {} {
	foreach cat [list def comment string command variable special] {
	    $CText tag remove $cat 0.0 end
	}
    }
    method syntaxunhlline {aLine} {
	foreach cat [list def comment string command variable special] {
	    $CText tag remove $cat $aLine.0 $aLine.end
	}
    }
    method syntaxhl {} {
	syntaxunhl
	update idletasks
	regexp -- {([0-9]+)\.[0-9]+} [$CText index end] dummy maxlines
	
	# modes: n: none, q: quoted, v: variable, c: command, x: comment
	for {set i 1} {$i<=$maxlines} {incr i} {
	    syntaxhlline $i
	}
    }

    method syntaxhlline {aLine} {
	set mode n
	regexp -- {[0-9]+\.([0-9]+)} [$CText index $aLine.end] dummy maxchars
	for {set j 0} {$j<=$maxchars} {incr j} {
	    set c [$CText get $aLine.$j]
	    switch $mode {
		n   {
		    switch -- $c {
			"\{" - "\}" -
			"\;" { $CText tag add special $aLine.$j }
			"\\" { incr j }
			"\#" { 
			    set nnn [expr $j+1]
			    if {$nnn<$maxchars} {
				regexp -- {[0-9]+\.([0-9]+)} [$CText index "$aLine.[expr $j+1] wordend"] dummy j2
				set com [$CText get $aLine.$j $aLine.$j2]
				switch $com {
				    "\#nop" {
					$CText tag add comment $aLine.$j $aLine.end
					set j $maxchars
				    }
				    default {
					$CText tag add command $aLine.$j $aLine.$j2				
					set j $j2
				    }
				}
			    } else {
				set j $maxchars
			    }
			}
			"\"" { set mode q ; $CText tag add special $aLine.$j } 
			default { }
		    }			
		} 
		q { 
		    switch -- $c {
			"\;" { $CText tag add special $aLine.$j }
			"\\" { incr j }
			"\"" { set mode n ; $CText tag add special $aLine.$j } 
			default { $CText tag add string $aLine.$j}
		    }
		}
	    }
	}
    }
	
    method alignline {} {
	update idletasks
	regexp -- {([0-9]+)\.([0-9]+)} [$CText index insert] dummy li co
	set btext [$CText get 0.0   $li.0]
	
	set lineb [$CText get $li.0 $li.end]
	set line  [string trimleft $lineb]

 	set linebn [string length $lineb]
 	set linen [string length $line]
 	set delc  [expr $linebn-$linen]

	set bl [getBracketLevel $btext]
	if {[string match "\}*" $line]} {
	    incr bl -1
	}
	
	$CText delete $li.0 "$li.end"	
	for {set i 0} {$i<$bl} {incr i} {
	    $CText insert "$li.end" "  "
 	    incr delc -2
	}
	$CText insert "$li.end" "$line"

 	set cc [expr $co - $delc ]
	$CText mark set insert $li.$cc
    }
    method insertTab {} { $CText insert insert "\t" }
    method align {} {	
	set alllist [split [$CText get 1.0 end] "\n"]
	$CText delete 1.0 end

	set all ""
	foreach line $alllist {
	    append all "[string trim $line]\n"
	}

	set qmode 0
	set aLL [expr [string length $all] -2]
	set b 0
	set indent 0
	for {set i 0} {$i<$aLL} {incr i} {
	    set c [string index $all $i]
	    switch -- $qmode {
		0 {
		    switch -- $c {
			"\n" {
			    set indent 1
			    $CText insert end "$c"
			}
			"\{" {
			    if {$indent} {
				for {set j 0} {$j<$b} {incr j} {
				    $CText insert end "  "
				}
				set indent 0
			    }
			    incr b
			    $CText insert end "$c"
			}
			"\}" {
			    incr b -1
			    if {$indent} {
				for {set j 0} {$j<$b} {incr j} {
				    $CText insert end "  "
				}
				set indent 0
			    }
			    $CText insert end "$c"
			}
			"\\" {
			    incr i
			    $CText insert end "$c"
			    $CText insert end [string index $all $i]
			}
			"\"" {
			    if {$indent} {
				for {set j 0} {$j<$b} {incr j} {
				    $CText insert end "  "
				}
				set indent 0
			    }
			    set qmode 1
			    $CText insert end "$c"
			}
			default {
			    if {$indent} {
				for {set j 0} {$j<$b} {incr j} {
				    $CText insert end "  "
				}
				set indent 0
			    }
			    $CText insert end "$c"
			}
		    }
		}
		1 {
		    switch -- $c {
			"\\" {
			    incr i
			    $CText insert end "$c"
			    $CText insert end [string index $all $i]
			}
			"\"" {
			    set qmode 0
			    $CText insert end "$c"
			}
			default {
			    $CText insert end "$c"
			}
		    }
		}
	    }
	}

    }
    method hasChanged {} { return $CChanged }
    method undo {} {
	signChanged
	set ind [$CText index insert]
	$CText delete 1.0 end
	$CText insert 1.0 [$CUndoBuffer getUp]
    }
    method redo {} {
	signChanged
	$CText delete 1.0 end
	$CText insert 1.0 [$CUndoBuffer getDown]
    }
    method signChanged {} {
	set CChanged 1
	$itk_component(statchange) configure -text "changed"
	$itk_component(statchange) configure -bg red
    }
    method changed {} {
	# 	if {!$CChanged} {
	# 	    if {[string compare "" $aKey]} {
	# 		$itk_component(statchange) configure -text "changed"
	# 		$itk_component(statchange) configure -bg red
	# 		set CChanged 1
	# 	    }
	# 	}
	# 	if {[$CParent isAutoindent]} {
	# 	    alignline
	# 	}

	set act  [$CText get 1.0 end]

	if {[string compare $act [$CUndoBuffer getLast]]} {
	    signChanged
	    $CUndoBuffer insert $act
	    $CUndoBuffer resetPos
	}
	if {[$CParent isAutoindent]} {
	    alignline
	}
	if {[$CParent isAutosh]} {
	    regexp -- {([0-9]+)\.[0-9]+} [$CText index insert] dummy li	    
	    syntaxhlline $li
	}
    }
    method newIndex {} {
	set ii "[$CText index insert]"
	$itk_component(index) configure -text "$ii"
	changed
    }
    method unchanged {} {
	if {$CChanged} {
	    $itk_component(statchange) configure -text "unchanged"
	    $itk_component(statchange) configure -bg "\#daceaf"
	    set CChanged 0
	}
    }
    method filename {} {
	switch -- $CType {
	    sys {
		set fn [$CFilM getSysScriptFile $CFileName]
	    }
	    ses {
		set fn [$CFilM getMainSesConfFile [$CSesM getSesId $CFileName]]
	    }
	    user {
		set fn [$CFilM getScriptFile $CFileName]
	    }
	}
	return $fn
    }
    method getType {} { return $CType }
    method loadit {} {
	if {[file exists [filename]]} {
	    $itk_component(text) import [filename]
	}
	$CText mark set insert 1.0
    }
    method importFile {aFileName} {
	set fid [open $aFileName "r"]
	$CText insert insert [read $fid]
	close $fid
    }
    method save {} {
	if {$itk_option(-editable)} {
	    saveit
	} else {
	    TInformer $itk_interior.mess \
		-information "You cannot save this buffer!" \
		-vanishafter 3
	}
    }
    method exportFile {aFileName} {
	$itk_component(text) export $aFileName
    }
    method saveit {} {
	$itk_component(text) export [filename]
	unchanged
    }
}
configbody TConfigfileBuffer::editable {
    if {$itk_option(-editable)} {
	$itk_component(text) configure -state normal
    } else {
	$itk_component(text) configure -state disabled
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TConfigfileBuffer.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
