# $Id: TConfigfileBufferManager.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TConfigfileBufferManager {
    inherit itk::Widget
    
    variable CParent
    variable CEditor

    constructor {aParent aEditor args} {
	set CParent $aParent
	set CEditor $aEditor
	
	set wid $itk_interior.f

	itk_component add mainframe {
	    iwidgets::labeledframe $wid -relief ridge -borderwidth 2 -labeltext Buffers
	} {keep -background}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0


	set cl(sysbm)  "SMM++ scripts"
	set cl(sesbm)  "session scripts"
	set cl(userbm) "user scripts"
	foreach cat [array names cl] {
	    itk_component add $cat {
		iwidgets::scrolledlistbox [$itk_component(mainframe) childsite].$cat -labeltext $cl($cat) \
		    -relief ridge -selectioncommand "[code $this selected $cat]"
	    } {keep -background}
	    pack $itk_component($cat) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	}

	eval itk_initialize $args
    }
    method selected {aCat} {
	set eee [expr [string length $aCat] -3]
	$CEditor activateBuffer "[string range $aCat 0 $eee]" \
	    "[string range [$itk_component($aCat) get active] 2 end]"
    }
    method activate {} {

	$itk_component(sysbm) clear
	$itk_component(sesbm) clear
	$itk_component(userbm) clear
	foreach buf [$CEditor getAllSysBuffers] {
	    $itk_component(sysbm) insert end [$buf getXName]
	}
	foreach buf [$CEditor getAllSesBuffers] {
	    $itk_component(sesbm) insert end [$buf getXName]
	}
	foreach buf [$CEditor getAllUserBuffers] {
	    $itk_component(userbm) insert end [$buf getXName]
	}
	$itk_component(sysbm) sort
	$itk_component(sesbm) sort
	$itk_component(userbm) sort

	raise $itk_interior
	place $itk_interior -in $CParent \
	    -relx 0.5 -rely 0.5 \
	    -anchor center \
	    -relwidth 1 -relheight 1
	tkwait visibility $itk_interior
    }
    method deactivate {} {
	place forget $itk_interior
    }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TConfigfileBufferManager.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
