# $Id: TConfigfileEditor.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

class TConfigfileEditor {
    # all scriptfiles must have a name that fits the following
    # regular exp: {[a-z][a-z0-9_]*}
    inherit iwidgets::Mainwindow TClipboard

    private {
	variable CFilM
	variable CSesM
	variable CActBuffer
    }


    constructor {aFilM aSesM args} {
	set CFilM $aFilM
	set CSesM $aSesM

	configure -title "SMM++ Scriptfile Editor"
	configure -statusline no
	[childsite] configure -relief ridge -bd 0

	itk_component add bframe {
	    frame [childsite].bframe -bd 0
	} { keep -background }
	pack $itk_component(bframe) \
	    -side top -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0

	#-- these widgets dont show up yet
	itk_component add xsysScriptfileSelector {
	    TSysConfigfileSelector [childsite].sss $CFilM $this \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {keep -background}
	itk_component add xsesScriptfileSelector {
	    TSesConfigfileSelector [childsite].ses $CFilM $CSesM $this \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {keep -background}
	itk_component add xuserScriptfileSelector {
	    TUserConfigfileSelector [childsite].users $CFilM $this \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {keep -background}
	itk_component add bufferManager {
	    TConfigfileBufferManager [childsite].bm [childsite] $this
	} {keep -background}
 	itk_component add find {
 	    iwidgets::findreplacedialog [childsite].find -title "SMM++ Script Editor Find" \
		-replace on \
		-searchbackground   "\#bbaa99" \
		-patternforeground  "\#002299" \
		-patternbackground  "\#778899" \
		-searchforeground   "\#6688ff"
 	} {keep -background}
	[$itk_component(find) component bbox] configure -borderwidth 2

	itk_component add fsd {
	    iwidgets::fileselectiondialog [childsite].fsd -modality application 
	} { keep -background }
	[$itk_component(fsd) component bbox] configure -borderwidth 2
	[$itk_component(fsd) component fsb]  configure -selectdircommand "[code $this filter2Sel]"

	menubarUif
	eval itk_initialize $args

	set CActBuffer ""
	addSysBuffer "welcome"
    }

    method close {} { deactivate }
    method find {}  { $itk_component(find) activate }
    method sysScriptfileUIF {}  { $itk_component(xsysScriptfileSelector) activate }
    method sesScriptfileUIF {}  { $itk_component(xsesScriptfileSelector) activate }
    method userScriptfileUIF {} { $itk_component(xuserScriptfileSelector) activate }
    method buffers {} {	$itk_component(bufferManager) activate }
    method saveActBuf {} {
	switch [$itk_component(bframe).$CActBuffer getType] {
	    ses -
	    user {
		TConfirmer $itk_interior.savebuf \
		    -command "[code $this reallysave]" \
		    -question "Really save?"
	    }
	    default {
		TInformer $itk_interior.mess \
		    -information "You cannot save this buffer!" \
		    -vanishafter 3
	    }
	}
    }
    method undo  {} { $itk_component(bframe).$CActBuffer undo }
    method redo  {} { $itk_component(bframe).$CActBuffer redo }
    method reallysave  {} { $itk_component(bframe).$CActBuffer save }
    method reallyalign {} { $itk_component(bframe).$CActBuffer align }
    method syntaxhl    {} { $itk_component(bframe).$CActBuffer syntaxhl }
    method syntaxunhl  {} { $itk_component(bframe).$CActBuffer syntaxunhl }
    method cut {} { $itk_component(bframe).$CActBuffer bufcut}
    method copy {} { $itk_component(bframe).$CActBuffer bufcopy}
    method paste {} { $itk_component(bframe).$CActBuffer bufpaste}
    method pasteFromSystem {} { $itk_component(bframe).$CActBuffer bufpasteFromSystem}
    method clear {} { $itk_component(bframe).$CActBuffer bufclear }
    method selall {} { $itk_component(bframe).$CActBuffer selall }
    method unselall {} { $itk_component(bframe).$CActBuffer unselall }
    method align {} {
	switch [$itk_component(bframe).$CActBuffer getType] {
	    ses -
	    user {
		TConfirmer $itk_interior.align \
		    -command "[code $this reallyalign]" \
		    -question "Really align?"
	    }
	    default {
		TInformer $itk_interior.mess \
		    -information "You cannot edit this buffer!" \
		    -vanishafter 3
	    }
	}
    }
    method killActBuf {} {
	if {[$itk_component(bframe).$CActBuffer hasChanged]} {
	    TConfirmer $itk_interior.killbuf \
		-command "[code $this reallykill]" \
		-question "Buffer changed!\nReally kill?"	
	} else {
	    reallykill
	}
    }
    method reallykill {} {
	destroy $itk_component($CActBuffer)
	unset    itk_component($CActBuffer)	
	set CActBuffer ""
	addSysBuffer "welcome"	
    }
    method deleteActBuf {} {
	switch [$itk_component(bframe).$CActBuffer getType] {
	    user {
		TConfirmer $itk_interior.deletebuf \
		    -command "[code $this reallydelete]" \
		    -question "Really delete?"
	    }
	    default {
		TInformer $itk_interior.mess \
		    -information "You cannot delete this buffer!" \
		    -vanishafter 3
	    }
	}
    }
    method activateBuffer {aCat aName} {
	switch $aCat {
	    sys  { addSysBuffer $aName }
	    ses  { addSesBuffer $aName }
	    user { addUserBuffer $aName }
	}
    }
    method reallydelete {} {
	file delete [$itk_component(bframe).$CActBuffer filename]
	reallykill
    }
    method getAllSysBuffers {} {
	set l [list]
	foreach b [array names itk_component sys*] {
	    lappend l $itk_component($b)
	}
	return $l
    }
    method getAllSesBuffers {} {
	set l [list]
	foreach b [array names itk_component ses*] {
	    lappend l $itk_component($b)
	}
	return $l
    }
    method getAllUserBuffers {} {
	set l [list]
	foreach b [array names itk_component user*] {
	    lappend l $itk_component($b)
	}
	return $l
    }
    method readjustFind {aWid} {
	catch "$itk_component(find) clear"
	$itk_component(find) configure -textwidget [$aWid textwidget]
    }
    method addSysBuffer {aFileName} {
	set wid $itk_component(bframe).sys$aFileName
	

	if {![winfo exists $wid]} {
	    itk_component add sys$aFileName {
		TConfigfileBuffer $wid \
		    sys $this $aFileName $CFilM $CSesM \
		    -editable 0 
	    } {keep -background}
	}
	if {[string compare "" $CActBuffer]} {
	    pack forget $itk_component(bframe).$CActBuffer
	}
	pack $wid -side top -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0
	set CActBuffer sys$aFileName 
	$itk_component($CActBuffer) takeFocus

	readjustFind $itk_component($CActBuffer)
	$itk_component(bufferManager) deactivate
    }
    method addUserBuffer {aFileName} {
	set wid $itk_component(bframe).user$aFileName

	if {![winfo exists $wid]} {
	    itk_component add user$aFileName {
		TConfigfileBuffer $wid \
		    user $this $aFileName $CFilM $CSesM \
		    -editable 1 
	    } {keep -background}
	}
	if {[string compare "" $CActBuffer]} {
	    pack forget $itk_component(bframe).$CActBuffer
	}
	pack $wid -side top -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0
	set CActBuffer user$aFileName 
	$itk_component($CActBuffer) takeFocus

	readjustFind $itk_component($CActBuffer)
	$itk_component(bufferManager) deactivate
    }
    method addSesBuffer {aSesName} {
	set sid [$CSesM getSesId $aSesName]
	set wid $itk_component(bframe).ses$sid

	if {![winfo exists $wid]} {
	    itk_component add ses$sid {
		TConfigfileBuffer $wid \
		    ses $this $aSesName $CFilM $CSesM \
		    -editable 1 
	    } {keep -background}
	}
	if {[string compare "" $CActBuffer]} {
	    pack forget $itk_component(bframe).$CActBuffer
	}
	pack $wid -side top -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0
	set CActBuffer ses$sid 
	$itk_component($CActBuffer) takeFocus

	readjustFind $itk_component($CActBuffer)
	$itk_component(bufferManager) deactivate
    }
    method isAutoindent {} {
	global  _TConfigfileEditor
	return $_TConfigfileEditor($this,autoindent)
    }
    method isAutosh {} {
	global  _TConfigfileEditor
	return $_TConfigfileEditor($this,autosh)
    }
    method menubarUif {} {
	menubar add menubutton file -text "File" -padx 8 -pady 2 \
	    -menu {options -tearoff no
		command bbb   -label "Buffers"  \
		       -accelerator "  C-x C-b" \
		       -helpstr "Lets you choose another buffer." \
		       -command "[TMainUif::master $itk_interior] buffers"
		separator sep7
		command sss   -label "SMM++ scriptfile"     \
		       -helpstr "Loads a SMM++ scriptfile (not editable)." \
		       -command "[TMainUif::master $itk_interior] sysScriptfileUIF"
		command uss   -label "user scriptfile"     \
		       -helpstr "Loads a user scriptfile." \
		       -command "[TMainUif::master $itk_interior] userScriptfileUIF"		    
		command uuu   -label "session scriptfile"     \
		       -helpstr "Loads a session scriptfile." \
		       -command "[TMainUif::master $itk_interior] sesScriptfileUIF"		    
		separator sep3
		command save  -label "Save" \
		       -accelerator "  C-x C-s" \
		       -helpstr "Saves the actual buffer."      \
		       -command "[TMainUif::master $itk_interior] saveActBuf"		    
		command kill  -label "Kill"     \
		       -helpstr "Removes the actual buffer from memory."      \
		       -command "[TMainUif::master $itk_interior] killActBuf"		    
		command dele  -label "Delete"     \
		       -helpstr "Deletes the actual buffer."      \
		       -command "[TMainUif::master $itk_interior] deleteActBuf"		    
		separator sep11
		command import -label "Import" \
		       -helpstr "Inserts the contents of a file at cursor position." \
		       -command "[TMainUif::master $itk_interior] importFile"	
		command export -label "Export" \
		       -helpstr "Writes the content of the Buffer to a file." \
		       -command "[TMainUif::master $itk_interior] exportFile"	
		separator sep1
		command close -label "Close"\
		       -accelerator "  C-x C-c" \
		       -helpstr "Closes the Configfile Editor."      \
		       -command "[TMainUif::master $itk_interior] close"
	    }
	menubar add menubutton edit -text "Edit" -padx 8 -pady 2 \
	    -menu {options -tearoff no
		command undo       -label "Undo" \
		       -accelerator "  C-_" \
		       -helpstr "Undoes last actions."      \
		       -command "[TMainUif::master $itk_interior] undo"		    
		command redo       -label "Redo" \
		       -accelerator "  C--" \
		       -helpstr "Undoes undoes."      \
		       -command "[TMainUif::master $itk_interior] redo"
		separator ssss
		command cut       -label "Cut" \
		       -accelerator "  C-w" \
		       -helpstr "Cuts selection into clipboard."      \
		       -command "[TMainUif::master $itk_interior] cut"		    
		command copy      -label "Copy" \
		       -accelerator "  A-w" \
		       -helpstr "Copies selection into clipboard."      \
		       -command "[TMainUif::master $itk_interior] copy"		    
		command paste     -label "Paste" \
		       -accelerator "  C-y" \
		       -helpstr "Inserts clipboard contents at cursor position."  \
		       -command "[TMainUif::master $itk_interior] paste"		    
		command pastefs   -label "Sys.-Paste" \
		       -accelerator "  C-Y" \
		       -helpstr "Inserts system clipboard contents at cursor position."  \
		       -command "[TMainUif::master $itk_interior] pasteFromSystem"		    
		command clear     -label "Clear"  \
		       -accelerator "  C-d" \
		       -helpstr "Removes selected text."      \
		       -command "[TMainUif::master $itk_interior] clear"
		separator sep1
		command selall    -label "Select all" \
		       -accelerator "  C-/" \
		       -helpstr "Selects whole buffer."\
		       -command "[TMainUif::master $itk_interior] selall"
		command unselall  -label "Unselect all" \
		       -accelerator "  C-\\" \
		       -helpstr "Unselects whole buffer."\
		       -command "[TMainUif::master $itk_interior] unselall"
	    }
	menubar add menubutton option -text "Option" -padx 8 -pady 2 \
	    -menu {options -tearoff no 
		command sss        -label "Indent"  \
		       -accelerator "  A-C-\\" \
		       -helpstr "Indents all lines of buffer."      \
		       -command "[TMainUif::master $itk_interior] align"		
 		checkbutton autoindent -label "Autoindent" \
 		       -helpstr "Turn on/off autoindention." 
		separator sssss
		command ssss       -label "Syntax Highlightning"  \
		       -accelerator "  C-l" \
		       -helpstr "Colorizes the text according the syntax." \
		       -command "[TMainUif::master $itk_interior] syntaxhl"		
		command sssh       -label "Syntax Unhighlightning"  \
		       -accelerator "  C-L" \
		       -helpstr "Turns text into bw." \
		       -command "[TMainUif::master $itk_interior] syntaxunhl"		
		checkbutton autosh -label "Auto Syntax Highlightning" \
		       -helpstr "Turn on/off auto syntax highlightning." 
	    }

	menubar menuconfigure .option.autoindent -variable _TConfigfileEditor($this,autoindent)
	menubar menuconfigure .option.autosh -variable _TConfigfileEditor($this,autosh)
	global _TConfigfileEditor
	set _TConfigfileEditor($this,autoindent) 0
	set _TConfigfileEditor($this,autosh)     0


	menubar add menubutton find -text "Find" -padx 8 -pady 2 \
	    -menu {options -tearoff no
		command find -label "Find" \
		       -helpstr "Launches find interface." \
		       -command "[TMainUif::master $itk_interior] find"
	    }

	menubar add menubutton help -text "Help" -padx 8 -pady 2 \
	    -menu {options -tearoff no
		command onwindow -label "No help, sorry!" \
		       -helpstr "Please refer to the html docu." \
	    }

    }

    method exportFile {} {
	if {[$itk_component(fsd) activate]} {		    
	    $itk_component(bframe).$CActBuffer exportFile [$itk_component(fsd) get]
	}
    }
    method filter2Sel {} {
	set f  [[[$itk_component(fsd) component fsb] component filter] get]
	set fn [expr [string length $f] - 2]
	set ff [string range $f 0 $fn]
	[[$itk_component(fsd) component fsb] component selection] clear
	[[$itk_component(fsd) component fsb] component selection] insert end $ff
	[[$itk_component(fsd) component fsb] component selection] xview end
    }
    method importFile {} {
	switch [$itk_component(bframe).$CActBuffer getType] {
	    ses -
	    user {
		if {[$itk_component(fsd) activate]} {		    
		    $itk_component(bframe).$CActBuffer importFile [$itk_component(fsd) get]
		}
	    }
	    default {
		TInformer $itk_interior.mess \
		    -information "You cannot edit this buffer!" \
		    -vanishafter 3
	    }
	}
    }

}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TConfigfileEditor.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
