# $Id: TConfigfileSelectors.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

class TSesConfigfileSelector {
    inherit iwidgets::Shell

    variable CFilM
    variable CCFEditor
    variable CSesM

    constructor {aFilM aSesM aCFEditor args} {
	configure -title "Session Scriptfiles"
	set CFilM     $aFilM
	set CSesM     $aSesM
	set CCFEditor $aCFEditor

 	itk_component add   msframe {frame [childsite].msframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(msframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add files {
	    iwidgets::scrolledlistbox $itk_component(msframe).ms \
		-labeltext "Files: " -labelpos nw \
		-selectioncommand "[code $this selected]" -visibleitems 30x10
	} {keep -background}
 	pack $itk_component(files) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0


	updateUifList

	### button
 	itk_component add   butframe {frame [childsite].butframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(butframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add cancel {
	    button $itk_component(butframe).cancel -text "cancel" \
		-command "[code $this cancel]"
	} { keep -background }
 	pack $itk_component(cancel) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	

	eval itk_initialize $args
    }
    method updateUifList {} {
	$itk_component(files) delete 0 end
	foreach mn [$CSesM getSesNames] {
	    $itk_component(files) insert end $mn
	}
    }
    method activate {} { updateUifList ; iwidgets::Shell::activate }
    method cancel {} { deactivate }
    method selected {} {
	set name [$itk_component(files) getcurselection]
	$CCFEditor addSesBuffer $name
	cancel
    }
}
class TUserConfigfileSelector {
    inherit iwidgets::Shell

    variable CFilM
    variable CCFEditor

    method updateUifList {} {
	$itk_component(files) delete 0 end
	foreach mn [$CFilM getAllScriptFileNames] {
	    $itk_component(files) insert end $mn
	}
    }
    constructor {aFilM aCFEditor args} {
	configure -title "SMM++ Scriptfiles"
	set CFilM $aFilM
	set CCFEditor $aCFEditor

 	itk_component add   msframe {frame [childsite].msframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(msframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add files {
	    iwidgets::scrolledlistbox $itk_component(msframe).ms \
		-labeltext "Files: " -labelpos nw \
		-selectioncommand "[code $this selected]" -visibleitems 30x10
	} {keep -background}
 	pack $itk_component(files) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	updateUifList

	### new
 	itk_component add   newframe {frame [childsite].newframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(newframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	itk_component add   newname {
	    iwidgets::entryfield $itk_component(newframe).ef -labeltext "new file: " \
		-textvariable __TUserConfigfileSelector($this) -width 25 \
		-validate "[code $this filenameValidation %P]"
	} {keep -background}
 	pack $itk_component(newname) -side left -fill both -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add   newbutton { 
	    button $itk_component(newframe).bb -text new -command "[code $this new]"
	} { keep -background }
 	pack $itk_component(newbutton) -side right -fill y -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0

	### button
 	itk_component add   butframe {frame [childsite].butframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(butframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add cancel {
	    button $itk_component(butframe).cancel -text "cancel" \
		-command "[code $this cancel]"
	} { keep -background }
 	pack $itk_component(cancel) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	

	eval itk_initialize $args
    }
    method filenameValidation {aStr} {
	return [regexp -- {^[a-z][a-z0-9_]*$} $aStr]
    }
   
    method new {} {
	global __TUserConfigfileSelector

	if {![string compare "" [string trim $__TUserConfigfileSelector($this)]]} {
	    TInformer $itk_interior.mess \
		-information "You must enter a filename!" \
		-vanishafter 3	    
	    return 
	}
	set filename [$CFilM getScriptFile $__TUserConfigfileSelector($this)]

	if {[file exists $filename ]} {
	    TInformer $itk_interior.mess \
		-information "This file already exists!" \
		-vanishafter 3	    
	} else {
	    set fid [open $filename "w+"]
	    close $fid
	    $CCFEditor addUserBuffer $__TUserConfigfileSelector($this)
	    cancel
	}
	

    }
    method activate {} { updateUifList ; iwidgets::Shell::activate }
    method cancel {} { deactivate }
    method selected {} {
	set name [$itk_component(files) getcurselection]
	if {[string compare "" $name]} {
	    $CCFEditor addUserBuffer $name
	    cancel
	}
    }
}
class TSysConfigfileSelector {
    inherit iwidgets::Shell

    variable CFilM
    variable CCFEditor

    constructor {aFilM aCFEditor args} {
	configure -title "SMM++ Scriptfiles"
	set CFilM $aFilM
	set CCFEditor $aCFEditor

 	itk_component add   msframe {frame [childsite].msframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(msframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add files {
	    iwidgets::scrolledlistbox $itk_component(msframe).ms \
		-labeltext "Files: " -labelpos nw \
		-selectioncommand "[code $this selected]" -visibleitems 30x10
	} {keep -background}
 	pack $itk_component(files) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0


	$itk_component(files) delete 0 end
	foreach mn [$CFilM getSysAllScriptFileNames] {
	    $itk_component(files) insert end $mn
	}

	### button
 	itk_component add   butframe {frame [childsite].butframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(butframe) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add cancel {
	    button $itk_component(butframe).cancel -text "cancel" \
		-command "[code $this cancel]"
	} { keep -background }
 	pack $itk_component(cancel) \
	    -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	

	eval itk_initialize $args
    }
    method cancel {} { deactivate }
    method selected {} {
	set name [$itk_component(files) getcurselection]
	$CCFEditor addSysBuffer $name
	cancel
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TConfigfileSelectors.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
