# $Id: TErrorLogger.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TErrorLogger {
    inherit iwidgets::Mainwindow

    variable CErrNum
    variable CErrLines
    constructor {args} {
	set CErrNum     0
	set CErrLines 200
	itk_component add textout {
	    iwidgets::scrolledtext [childsite].text \
		-visibleitems 80x24 \
		-setgrid true \
		-spacing1 0 \
		-spacing2 0 \
		-spacing3 0 \
		-textfont mudDef \
		-textbackground $TColor::BGMud \
		-foreground $TColor::FGMud \
		-wrap none \
	}
	pack $itk_component(textout) -fill both -expand true
	[childsite] configure -relief ridge -bd 0
	configure -title "SMM++: Errorlogger"


	menubar add menubutton file -text "File" -padx 8 -pady 2 \
	    -menu {options -tearoff no }
	menubar add command   .file.close \
	    -label   "Close" \
	    -helpstr "Closes the errorlog window." \
	    -command "[code $this close]"
	eval itk_initialize $args
    }
    method close {} {
	deactivate
    }

    
    method msgError {aStr} {
	incr CErrNum 
	$itk_component(textout)	insert end \
	    "===============================================================================\n"
	$itk_component(textout)	insert end "Error $CErrNum:\n"
	$itk_component(textout)	insert end \
	    "-------------------------------------------------------------------------------\n"
	$itk_component(textout)	insert end "$aStr\n"

	clearOutdatedLines	
	$itk_component(textout) see end
    }

    method clearOutdatedLines {} {
	::scan [$itk_component(textout) index end] "%u" numlines
	if {$numlines > $CErrLines} {
	    $itk_component(textout) delete 1.0 50.0
	}
    }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TErrorLogger.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
