# $Id: texteddialog.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

#
# Texteddialog
# ----------------------------------------------------------------------
# Implements a message dialog composite widget.  The Texteddialog is 
# derived from the Dialog class and is composed of an childsite and text
# component. The text can extend mutliple lines by embedding newlines.
# The whole base of the code is taken from the messagedialog code.
# 
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts              EMAIL: mulferts@austin.dsccc.com
#          Selim Issever                EMAIL: selim.issever@desy.de
#
#  @(#) $Id: texteddialog.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

#
# Usual options.
#
itk::usual Texteddialog {
    keep -background -cursor -font -foreground -modality
    #ignore -foreground 
}

# ------------------------------------------------------------------
#                            TEXTEDDIALOG
# ------------------------------------------------------------------
class iwidgets::Texteddialog {
    inherit iwidgets::Dialog

    constructor {args} {}

    method childsite {} 
    private {
	method _padding {}
    }

    itk_option define -textpos textPos Position n
    itk_option define -ipadx   iPadX   Pad      10
    itk_option define -ipady   iPadY   Pad      10
}

#
# Provide a lowercased access method for the Texteddialog class.
# 
proc ::iwidgets::texteddialog {pathName args} {
    uplevel ::iwidgets::Texteddialog $pathName $args
}

#
# Use option database to override default resources of base classes.
#
option add *Texteddialog.title "Dialog" widgetDefault
option add *Texteddialog.master "." widgetDefault

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
body iwidgets::Texteddialog::constructor {args} {
    configure -padx 0 -pady 0

    #
    # Create the childsite
    #
    itk_component add childsite {
	frame $itk_interior.childsite
    } {
	keep -background
    }
    
    #
    # Create separator between text and childsite
    #
    itk_component add separaton {
	iwidgets::line $itk_interior.separaton 
    } {
	usual
    }
    
    #
    # Create the text message component.  The message may extend over
    # several lines by embedding '\n' characters.
    #
    itk_component add message {
	message $itk_interior.message
    } {
	keep -background -cursor -font -foreground -text -aspect -justify
    }
    
    #
    # Hide the apply and help buttons.
    #
    hide Apply
    hide Help
    
    #
    # Initialize the widget based on the command line options.
    #
    eval itk_initialize $args
}   

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -textpos
#
# Specifies the image position relative to the message: n, s,
# e, or w.  The default is w.
# ------------------------------------------------------------------
configbody iwidgets::Texteddialog::textpos {
    switch $itk_option(-textpos) {
    	s {
	    grid $itk_component(childsite) -row 0 -column 0 
	    grid $itk_component(separaton) -row 1 -column 0 
	    grid $itk_component(message)   -row 2 -column 0 
    	}
    	n {
	    grid $itk_component(message)   -row 0 -column 0 
	    grid $itk_component(separaton) -row 1 -column 0 
	    grid $itk_component(childsite) -row 2 -column 0 
    	}
    	w {
	    grid $itk_component(message)   -row 0 -column 0 
	    grid $itk_component(separaton) -row 0 -column 1
	    grid $itk_component(childsite) -row 0 -column 2
    	}
    	e {
	    grid $itk_component(childsite) -row 0 -column 0 
	    grid $itk_component(separaton) -row 0 -column 1
	    grid $itk_component(message)   -row 0 -column 2
    	}
	
    	default {
    	    error "bad textpos option \"$itk_option(-imagepos)\":\
		    should be n, e, s, or w"
    	}
    }
    _padding
}
configbody iwidgets::Texteddialog::ipadx {
    _padding
}
configbody iwidgets::Texteddialog::ipady {
    _padding
}


body iwidgets::Texteddialog::_padding {} {
    grid configure $itk_component(message)   -sticky nswe
    grid configure $itk_component(childsite) -padx $itk_option(-ipadx)
    grid configure $itk_component(message)   -padx $itk_option(-ipadx)
    grid configure $itk_component(childsite) -pady $itk_option(-ipady)
    grid configure $itk_component(message)   -pady $itk_option(-ipady)
    switch $itk_option(-textpos) {
    	s - n {
	    grid configure $itk_component(separaton) -padx $itk_option(-ipadx)
	    grid configure $itk_component(separaton) -pady 0
    	}
    	w - e {
	    grid configure $itk_component(separaton) -padx 0
	    grid configure $itk_component(separaton) -pady $itk_option(-ipady)
    	}
    }
}
body iwidgets::Texteddialog::childsite {} {
    return $itk_component(childsite)
}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: texteddialog.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
