# $Id: TMainUif.tcl,v 1.10 2002/04/28 11:13:33 issever Exp $

class TMainUif {
    inherit iwidgets::Mainwindow

    variable CFilM
    variable CImaM
    variable CMudM
    variable CSesM

    variable CTicker

    variable CVInfStr

    variable CWinWid

    method setHelpStr {aStr} {
	set [[$this component help] cget -textvariable] $aStr
    }
    method setStatusStr {aStr} {
	set [[$this component status] cget -textvariable] $aStr
    }

    proc master {wid} {
	regsub -- {.shellchildsite.menubar$} $wid {} retval
	regsub -- {.shellchildsite.mwchildsite$} $retval {} retval
	return "$retval"
    }


    method saveLayout {} 
    method loadLayout {} 

    method editMainSessionConfigurationFile {} { $itk_component(configEditor) activate }
    method sesUif {}       { $itk_component(sesManagerUif) launchUif }

    method newMapUif {}    { $itk_component(mapManager)    newMapReq }
    method resizeMapUif {} { $itk_component(mapManager)    resizeMapReq }
    method saveMap {}      { $itk_component(mapManager)    saveMap }
    method remMap {}       { $itk_component(mapManager)    remMap } 


    # --- edit menu:

    # ---

    method confFont {}    { $CGUIM activateFont $itk_interior}
    method confColor {}    { $CGUIM activateColor $itk_interior}
    method confLines {}    { $itk_component(histLinesConfig) activate}
    method confMouseButtons {}    { $itk_component(mouseButtonConfigurer) activate }


    method stopSession {} {
	if {![$CSesM sessionStarted]} {
	    TInformer $itk_interior.stopsession \
		-information "No active Session."
	    return
	}


	set wid $itk_interior.stopsession
	iwidgets::messagedialog $wid \
	    -modality application \
	    -master [winfo toplevel $itk_interior] \
	    -tops [winfo toplevel $itk_interior] \
	    -bitmap questhead \
	    -text "Do you really want to stop\nthe current session?" \
	    -title "Question: stop session?" 

	$wid buttonconfigure OK -text "Yes"
	$wid buttonconfigure Cancel -text "No"

	$wid center
	if {[$wid activate]} {
	    destroy $wid
	    $CSesM stopSession
	    $itk_component(sesManagerUif) sessionHasBeenStopped
	} else {
	    destroy $wid
	}

    }



    method reconnectSession {} {
	if {[$CSesM sessionStarted]} {
	    $CSesM connectActSes $this 1
	} else {
	    TInformer $itk_interior.stopsession \
		-information "No active Session."
	}
    }
    method quitnow {} { 
	TConfirmer $itk_interior.quitnow \
	    -command exit \
	    -question "Really leave SMM?\
                     \n\
                     \nIf you choose 'Yes' the program will\
                     \nbe aborted. Make sure that your\
                     \nsession is stoped/saved."
    }
    

    method helpMain {}  { 
	TInformer $itk_interior.help \
	    -information \
	    "The SMM++ manual is distributed separately\
             \nin various formats.\
             \nPlease download the version you need\
	     \nfrom the SMM++ download site at sourceforge."
    }
    method helpVersion {} { 
	TInformer $itk_interior.version \
	    -information $CVInfStr -autoactivate 0
	[$itk_interior.version component message] configure -justify left
	$itk_interior.version activate
    }

    method sesDisconnected {} { 
	$CSesM sesDisconnected 
	newSes
    }

    method newSes {} { 
	set ses [$CSesM getActSes]	
	if {[string match "" $ses]} {
	    # no session
	    $this configure -title "SMM++: Selim's Magic Mapper"
	    $itk_component(mapManager) stopMapping 
	} else {
	    # a session
	    $this configure -title \
		"SMM++: Selim's Magic Mapper       ---       Active Session: [$ses name]"
	    $itk_component(mapManager) startMapping [$CSesM getActMud] 
	}
    }
    method getMudderUif {} { return $itk_component(mudder) }
    method getMapManager {} { return $itk_component(mapManager) }

    method filter2Sel {} {
	set f  [[[$itk_component(fsd) component fsb] component filter] get]
	set fn [expr [string length $f] - 2]
	set ff [string range $f 0 $fn]
	[[$itk_component(fsd) component fsb] component selection] clear
	[[$itk_component(fsd) component fsb] component selection] insert end $ff
	[[$itk_component(fsd) component fsb] component selection] xview end
    }
    method exportMap {} {
	if {[$itk_component(mapManager) hasMap]} {
	    if {[$itk_component(fsd) activate]} {		    
		$itk_component(mapManager) exportMap [$itk_component(fsd) get]
	    }
	} else {
	    TInformer $itk_interior.exmap \
		-information \
		"There is no map available!"
	}
    }
    method importMap {} {
	if {[$CSesM sessionStarted]} {
	    if {[$itk_component(fsd) activate]} {		    
		$itk_component(mapManager) importMap [$itk_component(fsd) get]
	    }
	} else {
	    TInformer $itk_interior.immap \
		-information \
		"There is no active Session!"
	}
    }

    variable Cdmvarindex
    variable Csmvarindex
    variable Cbuttonsvarindex
    variable CSMW ;# separate map window
    variable CErr
    variable CGUIM

    constructor {
	aGUIM
	aFileManager aMudManager aSesManager aImageManager 
	aVInfStr 
	aSeparateMapWindow aErr
	args
    } {} {
	global _TMainUif
	configure -foreground black
	configure -menubarforeground black
	addFGCom [code $this configure -foreground %c] 
	addFGCom [code $this configure -menubarforeground %c] 

	set CGUIM $aGUIM
	set CErr $aErr
	set CSMW $aSeparateMapWindow

	set CVInfStr  $aVInfStr

	set Cdmvarindex      "$this,dm"
	set Csmvarindex      "$this,sm"
	set _TMainUif($Cdmvarindex)   0
	set _TMainUif($Csmvarindex)   0

	regsub -- {^::} $this {} CWinWid
	wm geometry $CWinWid +0+0
	[childsite] configure -relief ridge -bd 0

	# config
	set CFilM   $aFileManager
	set CImaM   $aImageManager
	set CMudM   $aMudManager
	set CSesM   $aSesManager

	set CTicker [TTicker ::\#auto]

	######## these components dont show up jet,...
	# mud/ses managers uif
	itk_component add   sesManagerUif  { 
	    TSesMudManager    [childsite].sesM $this  $CSesM $CMudM $CFilM \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior]
	} {keep -background}
	itk_component add   configEditor   { 
	    TConfigfileEditor [childsite].ced  $CFilM $CSesM 
	} {keep -background}

	itk_component add   mouseButtonConfigurer { 
	    TMouseButtonConfigurer [childsite].mbc $CFilM \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {keep -background}

	itk_component add fsd {
	    iwidgets::fileselectiondialog [childsite].fsd -modality application \
		-mask "*.smap"
	} { keep -background }
	[$itk_component(fsd) component bbox] configure -borderwidth 2
	[$itk_component(fsd) component fsb]  configure -selectdircommand "[code $this filter2Sel]"


	
	######## these do,..
	# main: mapUIF, mudUIF
	itk_component add   pw {
	    iwidgets::panedwindow [$this childsite].pw -width 1000 -height 670 \
		-orient vertical
	} {keep -background}
	pack $itk_component(pw) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	$itk_component(pw) add mapper -margin 0
	$itk_component(pw) add mudder -margin 0

	itk_component add   mudder { 
	    TMudderUif [$itk_component(pw) childsite 1].mudder [$CGUIM getColorManager]
	} {
	    keep -background
	    keep -foreground
	}
	

	set pwww [$itk_component(pw) childsite 0].map
	if {$CSMW} {
	    
	    itk_component add mapperwin {
		toplevel  $pwww -width 700 -height 500
	    } { keep -background ; ignore -width ; ignore -height}

	    pack propagate $pwww 0
	    wm title $pwww "SMM++: Mapping"
		
	    set mapwid  $pwww.m
	} else {
	    set mapwid  $pwww
	}

	itk_component add   mapManager { 
	    TMapManager $mapwid $CImaM 
	} {keep -background}
	addFGCom [code $itk_component(mapManager) configure -foreground %c] 

	pack $itk_component(mapManager) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left	
	pack $itk_component(mudder) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	setMM mm

	# menubar 
	_createMenubar

	# ............
	newSes
	$this activate
	eval itk_initialize $args

	tkwait visibility $itk_component(mudder)
	$itk_component(mudder) takeFocus
	$itk_component(mudder) fraction 10 90
	if {$CSMW} {
	    $itk_component(pw)     hide mapper
	} else {
	    $itk_component(pw)     fraction 45 55
	}
	loadLayout

	######## these components dont show up jet,...
	itk_component add  histLinesConfig { 
	    THLinesConfig [$this childsite].lc $CFilM $itk_component(mudder) \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {keep -background}
 	itk_component add find {
 	    iwidgets::finddialog [childsite].find \
		-title "SMM++ Find" \
		-textwidget [$itk_component(mudder) getOutput]\
		-searchbackground   "\#ddccbb" \
		-patternforeground  "\#002299" \
		-patternbackground  "\#99aabb" \
		-searchforeground   "\#6688ff"
 	} {keep -background; keep -foreground}
	[$itk_component(find) component bbox] configure -borderwidth 2
	itk_component add findKeyname {
	    TFindKeyname [childsite].findKeyname \
		-master [winfo toplevel $itk_interior]
	} {keep -background; keep -foreground}
	
	# --- start session gui
	sesUif
    }
    method launchFind           {} { $itk_component(find)          activate }
    method launchFindKeyname  {} { 
	$itk_component(findKeyname) activate 
	$itk_component(findKeyname) center
    }

    method getMMVarName {} { return "_TMainUif($this,mm)"}
    method setMM {aMode} {
	global _TMainUif
	switch -- $aMode {	    
	    "mud" {
		set _TMainUif($this,mm) "Mudding"
		$itk_component(pw) show mudder
		$itk_component(pw) hide mapper 
	    }
	    "map" {
		set _TMainUif($this,mm) "Mapping"
		$itk_component(pw) show mapper 
		$itk_component(pw) hide mudder
	    }
	    default {
		if {$CSMW} {
		    set _TMainUif($this,mm) "Mudding"
		    $itk_component(pw) show mudder
		    $itk_component(pw) hide mapper 
		} else {
		    set _TMainUif($this,mm) "Mud & Map"
		    $itk_component(pw) show mapper 
		    $itk_component(pw) show mudder
		    $itk_component(pw) fraction 45 55
		}
	    }
	}
    }
    method launchErrl {} {
	$CErr activate
    }
    # ----
    method showButtons {} {
	global [$itk_component(mudder) getGlobalVar]
	if {[$itk_component(mudder) getShowButtons] } {
	    $itk_component(mudder) showButtons
	} else {
	    $itk_component(mudder) hideButtons
	}
    }
    # ---- TICK 
    method getTicker {} { return $CTicker }
    method getTickerLabelVarName {} { return [$CTicker getLabelVarName] }
    method getTickerIndicatorVarName {} { return [$CTicker getIndicatorVarName] }
    method tick {} { $CTicker toggle }

    method raiseMap {} {
	wm deiconify $itk_component(mapperwin)
	raise $itk_component(mapperwin) 
    }

    # ---
    private {
	method _createMenubar {} 
	method _createMenuFile {} 
	method _createMenuMap {} 
	method _createMenuEdit {} 
	method _createMenuConfigure {} 
	method _createMenuFind {} 
	method _createMenuTick {} 
	method _createMenuMapAndMud {} 
	method _createMenuHelp {} 
    }

}

# this is to prevent <Alt-Key> events to be passed to somewhere(?) and
# producing errors!
proc tkTraverseToMenu {a b} {}


###################################################################

# ----------------------------------------------------------
# public method: saveLayout
# ----------------------------------------------------------
body TMainUif::saveLayout {} {
    if {$CSMW} { set id sepMapWin } else { set id def }
    set fn [$CFilM getLayoutFile $id]
    set fid [open $fn "w"]

    ### real saving
    # version
    puts $fid 1
    #
    # main window geometry
    puts $fid [wm geometry $CWinWid] 
    set x [winfo x $CWinWid]
    set y [winfo y $CWinWid]
    if {$x>=0} { set x "+$x" }
    if {$y>=0} { set y "+$y" }
    puts $fid "$x$y"

    if {$CSMW} { 
	# separate map window geometry
	puts $fid [wm geometry $itk_component(mapperwin)] 
	set x [winfo x $itk_component(mapperwin)]
	set y [winfo y $itk_component(mapperwin)]
	if {$x>=0} { set x "+$x" }
	if {$y>=0} { set y "+$y" }
	puts $fid "$x$y"
    } else { 
	# or panes of mainwindow
	global _TMainUif
	switch  -- $_TMainUif($this,mm) {
	    "Mudding" { puts $fid mud }
	    "Mapping" { puts $fid map }
	    default   { puts $fid [$itk_component(pw) getFractions]}
	}
    }

    puts $fid [$itk_component(mudder) getLayout]
    puts $fid [$itk_component(mapManager) getLayout]

    close $fid
}

# ----------------------------------------------------------
# public method: loadLayout
# ----------------------------------------------------------
body TMainUif::loadLayout {} {
    if {$CSMW} { set id sepMapWin } else { set id def }
    set fn [$CFilM getLayoutFile $id]
    if {![file exists $fn]} { return }
    set fid [open $fn "r"]

    ### real loading
    # version
    gets $fid var 
    #
    # main window
    gets $fid var 
    eval wm geometry $CWinWid $var
    gets $fid var
    eval wm geometry $CWinWid $var

    if {$CSMW} { 
	# separate map window geometry
	gets $fid var
	eval wm geometry $itk_component(mapperwin) $var
	gets $fid var
	eval wm geometry $itk_component(mapperwin) $var
    } else { 
	# or panes of mainwindow
	gets $fid var
	switch -- $var {
	    mud - map {
		setMM $var
	    }
	    default {
		setMM mm
		eval $itk_component(pw) fraction $var		    
	    }
	}
    }
    gets $fid var
    $itk_component(mudder) setLayout $var
    gets $fid var
    $itk_component(mapManager) setLayout $var

    close $fid
}

# ----------------------------------------------------------
# private method: _createMenubar
# ----------------------------------------------------------
body TMainUif::_createMenubar {} {
    _createMenuFile
    _createMenuMap
    _createMenuEdit
    _createMenuConfigure
    _createMenuFind
    _createMenuTick
    _createMenuMapAndMud
    _createMenuHelp
}
body TMainUif::_createMenuFile {} {
    menubar add menubutton file -text "File" -padx 8 -pady 2 \
	-menu { options -tearoff no }
    menubar add command   .file.stopses \
	-label   "Stop Session" \
	-helpstr "Stops and unloads the current session." \
	-command [code $this stopSession]
    menubar add command   .file.reconses \
	-label   "Reconnect Session" \
	-helpstr "Reconnects the current session." \
	-command [code $this reconnectSession]
    menubar add command   .file.session \
	-label   "Muds & Sessions..." \
	-helpstr "Open Mud and Session Manager" \
	-command [code $this sesUif]
    menubar add separator .file.filesep1
    menubar add command   .file.errl   \
	-label   "Error Logger..." \
	-helpstr "Launch the error logger." \
	-command [code $this launchErrl]
    menubar add separator .file.filesep2
    menubar add command   .file.exit   \
	-label   "Exit"   \
	-helpstr "Exit SMM."      \
	-command [code $this quitnow]
}
body TMainUif::_createMenuMap {} {
    menubar add menubutton map -text "Map" -padx 8 -pady 2 \
	-menu { options -tearoff no }
    menubar add command     .map.newmap \
	-label    "New map..." \
	-helpstr  "Create a new map." \
	-command  [code $this newMapUif]
    menubar add command     .map.remmap \
	-label    "Remove map" \
	-helpstr  "Removes the actual map." \
	-command  [code $this remMap]
    menubar add command     .map.resizemap \
	-label    "Resize map..." \
	-helpstr  "Resize current map." \
	-command  [code $this resizeMapUif]
    menubar add separator   .map.mapsep1
    menubar add command     .map.savemap \
	-label    "Save map" \
	-helpstr  "Save current map." \
	-command  [code $this saveMap]
    menubar add command     .map.saveallmaps \
	-label    "Save all maps" \
	-helpstr  "Saves all maps." \
	-command  "$itk_component(mapManager) saveAllMaps"
    menubar add separator   .map.mapsep1b
    menubar add command     .map.export \
	-label    "Export map..." \
	-helpstr  "Exports the current map to a file." \
	-command  [code $this exportMap]
    menubar add command     .map.import \
	-label    "Import map..." \
	-helpstr  "Imports a map from a file." \
	-command  [code $this importMap]
    menubar add separator   .map.mapsep2
    menubar add checkbutton .map.developmentMode \
	-label    "Development Mode" \
	-helpstr  "Turn on/off development mode." \
	-selectcolor black \
	-variable "[$itk_component(mapManager) getDevModeVariable]"
    
}
body TMainUif::_createMenuEdit {} {
    menubar add menubutton medit -text "Edit" -padx 8 -pady 2 \
	-menu {options -tearoff no }
    menubar add command     .medit.selClear \
	-label    "Clear Selection" \
	-helpstr  "Unselects all and clears the clipboard." \
	-command  [code $itk_component(mapManager) selClear]
    menubar add separator   .medit.meditsep1
    menubar add command     .medit.selDelete \
	-label    "Delete Selection" \
	-helpstr  "Deletes all selected rooms." \
	-command  [code $itk_component(mapManager) selDelete]
    menubar add command     .medit.selCopy \
	-label    "Copy" \
	-helpstr  "Copy selection into clipboard (relative to zoomposition)." \
	-command  [code $itk_component(mapManager) selCopy 1]
    menubar add command     .medit.selCut \
	-label    "Cut" \
	-helpstr  "Cut selection into clipboard (relative to zoomposition)." \
	-command  [code $itk_component(mapManager) selCut]
    menubar add command     .medit.selPaste \
	-label    "Paste" \
	-helpstr  "Paste clipboard into map at zoom position." \
	-command  [code $itk_component(mapManager) selPaste]
    menubar add separator   .medit.meditsep2
    menubar add command     .medit.selFillZif \
	-label    "Fill with ZIF" \
	-helpstr  "All Selected Rooms will be changed to be like the one in the ZIF." \
	-command  [code $itk_component(mapManager) selFillZif]
}
body TMainUif::_createMenuConfigure {} {
    menubar add menubutton config -text "Configuration" -padx 8 -pady 2 \
	-menu {options -tearoff no }
    menubar add command .config.sesmain \
	-label "Scriptfile Editor..."  \
	-helpstr "Launches the scriptfile editor."\
	-command [code $this editMainSessionConfigurationFile]
    menubar add separator .config.confsep1
    menubar add command .config.conffont \
	-label   "Font Configuration..."  \
	-helpstr "Configure Fonts"\
	-command [code $this confFont]
    menubar add command .config.confcolor \
	-label   "Color Configuration..."  \
	-helpstr "Configure Colors"\
	-command [code $this confColor]
    menubar add command .config.histLines \
	-label "History Lines..."  \
	-helpstr "Configure Number of History Lines"\
	-command [code $this confLines]
    menubar add command .config.mouseButtons \
	-label "Mouse Buttons..."  \
	-helpstr "Configure Mouse Button Bindings."\
	-command [code $this confMouseButtons]
    menubar add separator .config.confsep2
    menubar add checkbutton .config.showButtons \
	-label   "Show Buttons" \
	-helpstr "Show/hide command buttons." \
	-selectcolor black \
	-variable "[$itk_component(mudder) getShowButtonsVar]" \
	-command [code $this showButtons]
    menubar add cascade .config.zif \
	-label "Zoom Interface" \
	-helpstr "Configure the zoom interface." \
	-menu { options -tearoff no }
    menubar add separator  .config.confsep3
    menubar add command    .config.savelayout \
	-label     "Save Layout" \
	-helpstr   "Save the current layout of all windows."\
	-command   [code $this saveLayout] 
    menubar add command    .config.loadlayout \
	-label     "Load Layout" \
	-helpstr   "Loads a previously saved layout."\
	-command   [code $this loadLayout] 

    #... a cascade menu
    set zif [$itk_component(mapManager) getZif]
    menubar add checkbutton .config.zif.sel \
	-label     "Selector"\
	-selectcolor black \
	-helpstr   "Show/hide selector buttons." \
	-variable  "[$zif getVariable]([$zif getIndex selector])"\
	-command   "$zif toggle selector"
    menubar add checkbutton .config.zif.ex \
	-selectcolor black \
	-label     "Exits"\
	-helpstr   "Show/hide exit buttons." \
	-variable  "[$zif getVariable]([$zif getIndex exits])"\
	-command   "$zif toggle exits"
    menubar add checkbutton .config.zif.stuff \
	-selectcolor black \
	-label     "Stuff"\
	-helpstr   "Show/hide stuff buttons." \
	-variable  "[$zif getVariable]([$zif getIndex stuff])"\
	-command   "$zif toggle stuff"
    menubar add checkbutton .config.zif.rest \
	-selectcolor black \
	-label     "Main"\
	-helpstr   "Show/hide main buttons." \
	-variable  "[$zif getVariable]([$zif getIndex rest])"\
	-command   "$zif toggle rest"
    menubar add checkbutton .config.zif.squ \
	-selectcolor black \
	-label     "Squeezer"\
	-helpstr   "Show/hide squeezer." \
	-variable  "[$zif getVariable]([$zif getIndex squeezer])"\
	-command   "$zif toggle squeezer"
}
body TMainUif::_createMenuFind {} {
    menubar add menubutton find -text "Find" -padx 8 -pady 2 -menu { options -tearoff no }
    menubar add command   .find.find \
	-label "Find..." \
	-helpstr "This find searches in the mud output area" \
	-command [code $this launchFind]
    menubar add command   .find.findKeyname \
	-label "Find keyname..." \
	-helpstr "Displays the names of the key, that have to be used in the ::smm::keycom command." \
	-command [code $this launchFindKeyname]
}
body TMainUif::_createMenuTick {} {
    menubar add menubutton tick \
	-relief groove \
	-textvariable "[[TMainUif::master $itk_interior] getTickerLabelVarName]" \
	-padx 8 -pady 2 \
	-menu {options -tearoff no
	    checkbutton tick -label "Tick" \
		   -selectcolor black \
		   -helpstr "Turn on/off tick." \
		   -variable "[[TMainUif::master $itk_interior] getTickerIndicatorVarName]" \
		   -command "[TMainUif::master $itk_interior] tick"
	}
}
body TMainUif::_createMenuMapAndMud {} {
    menubar add menubutton mud  -textvariable "[[TMainUif::master $itk_interior] getMMVarName]" \
	-indicatoron 1 -relief groove -width 9 \
	-padx 8 -pady 2 \
	-menu {options -tearoff no 
	    command mudonly -label "Mudding" \
		   -helpstr "Show only Mud Interface" \
		   -command "[TMainUif::master $itk_interior] setMM mud"
	}
    if {[expr !$CSMW]} {
	menubar add command .mud.maponly -label "Mapping" \
	    -helpstr "Show only Map Interface" \
	    -command "[TMainUif::master $itk_interior] setMM map"
	menubar add	command .mud.mudmap -label "Mud & Map" \
	    -helpstr "Show Map and Mud Interface" \
	    -command "[TMainUif::master $itk_interior] setMM mm"
    } else {
	menubar add command .mud.maponly -label "Mapping" \
	    -helpstr "Show Map Interface" \
	    -command "[TMainUif::master $itk_interior] raiseMap"
    }
}
body TMainUif::_createMenuHelp {} {
    menubar add menubutton help -text "Help" -padx 8 -pady 2 \
	-menu {options -tearoff no
	    command onwindow -label "Main..." \
		   -helpstr "This is where everything begins." \
		   -command "[TMainUif::master $itk_interior] helpMain"
	    command version -label "Version..." \
		   -helpstr "Show configuration and version." \
		   -command "[TMainUif::master $itk_interior] helpVersion"
	}

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMainUif.tcl,v $
# Revision 1.10  2002/04/28 11:13:33  issever
# put menu->stop session back in place
# debug: sesManagerUif buttons showed wrong state,
#   when the menu was used to stop the session
# added save all maps menu entry
#
# Revision 1.9  2002/04/27 20:58:54  issever
# again changed some gui colors and
# implmented Hamlets getselection
#
# Revision 1.8  2002/04/27 19:26:55  issever
# adjusted linux GUI colors
#
# Revision 1.7  2002/04/20 16:31:46  issever
# adjusted colors for windows
#
# Revision 1.6  2002/02/17 15:19:13  issever
# removed old out-commented code.
#
# Revision 1.5  2002/02/17 15:14:12  issever
# resolving merging errors
#
# Revision 1.4  2001/12/23 01:45:18  issever
# Help menu text updated
#
# Revision 1.3  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
# Revision 1.2  2001/12/08 13:38:54  issever
# reorganized session manager code.
# It is now in a separate file and has more comments.
# The functionality hasnt been extended.
#
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
# Revision 1.5  2001/12/01 14:57:38  issever
# Added Findkey GUI.
#
# Revision 1.4  2001/12/01 12:05:18  issever
# Slight reorganization of code (menubar)
#
# Revision 1.3  2001/11/25 20:30:31  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
