# $Id: TMudEditor.tcl,v 1.1 2001/12/07 23:58:05 issever Exp $

class TMudEditor {
    inherit iwidgets::Dialogshell
    public {
	constructor {aParent aMudManager args} {} {}
	method setMode {aMode} 
	method setMud {aMud} 
	method addMud {} 
	method cancel {}
    }
    private {
	variable _mudManager
	variable _parent
	variable _mode
	variable _mud
    }
}

# ==========================================================
# === class code
# ==========================================================

# ----------------------------------------------------------
# --- constructor
# ----------------------------------------------------------
body TMudEditor::constructor {aParent aMudManager args} {
    set _mudManager $aMudManager
    set _parent     $aParent
    set _mode       "new"
    set _mud        ""

    configure -modality application

    # --- buttons
    add ok     -text OK     -command [code $this addMud]
    add cancel -text Cancel -command [code $this cancel]
    default ok

    # --- name
    itk_component add   name {
	iwidgets::entryfield [childsite].name \
	    -labeltext "mud name: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}
    itk_component add   host {
	iwidgets::entryfield [childsite].host \
	    -labeltext "host: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}
    itk_component add   port {
	iwidgets::entryfield [childsite].port \
	    -labeltext "port: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}

    pack $itk_component(name) $itk_component(host) $itk_component(port) \
	-side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

    # align all that stuff
    iwidgets::Labeledwidget::alignlabels \
	$itk_component(name) $itk_component(host) \
	$itk_component(port)

    eval itk_initialize $args	
}
body TMudEditor::setMode {aMode} {
    set _mode $aMode

    $itk_component(name) configure -state normal
    $itk_component(name) clear
    $itk_component(host) clear
    $itk_component(port) clear
    
    switch -- $_mode {
	edit {
	    configure -title "Edit mud"
	    $itk_component(name) insert 0 [$_mud name]
	    $itk_component(host) insert 0 [$_mud host]
	    $itk_component(port) insert 0 [$_mud port]
	    $itk_component(name) configure -state disabled
	}
	default {
	    configure -title "Create new mud"
	}
    }
}
body TMudEditor::setMud {aMud} {set _mud $aMud}
body TMudEditor::addMud {} {
    set name [string trim [$itk_component(name) get]]
    set host [$itk_component(host)   get]
    set port [$itk_component(port) get]
    

    if {![string compare $name ""]} {
	TInformer [childsite].mess \
	    -information "You have to enter a 'name'\nfor the mud!"
	return
    }
    if {[string compare $_mode edit]} {
	if {[$_mudManager exists $name]} {
	    TInformer [childsite].mess \
		-information "The mud name '$name' exists\nalready. Mud names must be unique."
	    return
	}
    }
    
    $_mudManager add $name $host $port 
    $_parent updateMudList $name

    deactivate $name
}
body TMudEditor::cancel {} {
    deactivate
}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMudEditor.tcl,v $
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
