# $Id: TMudManagerUif.tcl,v 1.1 2001/12/07 23:58:05 issever Exp $

class TMudManagerUif {
    inherit itk::Widget

    constructor {aParent aMudM args} {} {}

    # --- variables
    private variable _name
    private variable _host
    private variable _port

    private variable _parent
    private variable _mudManager

    # --- methods: buttons
    public method buttonNew {} 
    public method buttonEdit {}
    public method buttonRemove {} 
    
    # --- methods other
    public method reallyRemove {aName} 
    public method selected {} 
    public method updateMudList {args} 
    
}

# ==========================================================
# === class code
# ==========================================================

# ----------------------------------------------------------
# --- constructor
# ----------------------------------------------------------
body TMudManagerUif::constructor {aParent aMudM args} {

    # === class variables
    # --- store passed information
    set _parent     $aParent
    set _mudManager $aMudM
    # --- init class variables
    set _name     ""
    set _host     ""
    set _port     ""


    # === create widgets
    # --- main structure from left to right: 
    #     mudbox, separator-line, buttonbox
    #     plus a dialog to edit or add muds

    # ... mudbox
    itk_component add mudbox {
	frame $itk_interior.mudbox
    } {keep -background}
    pack $itk_component(mudbox) -side left -fill both -expand true 
    # ... separator-line
    itk_component add mudsep {
	iwidgets::line $itk_interior.mudsep \
	    -orient vertical
    } { keep -background }
    pack $itk_component(mudsep) -side left -fill both -expand true
    # ... buttonbox
    itk_component add mudbuttons {
	iwidgets::buttonbox $itk_interior.bb \
	    -orient vertical
    } { keep -background ; keep -foreground }
    pack $itk_component(mudbuttons) -side left -fill both -expand false 
    # ... mud editor
    itk_component add mudEditor {
	TMudEditor $itk_interior.mudDialog $this $_mudManager \
	    -master [winfo toplevel $itk_interior] \
	    -tops [winfo toplevel $itk_interior]
    } {keep -background ; keep -foreground }

    
    # === fill mudbox
    # ... Muds selector
    itk_component add mudselector {
	iwidgets::scrolledlistbox $itk_component(mudbox).ms \
	    -labeltext "Muds:" -labelpos wn \
	    -selectmode browse \
	    -selectioncommand "[code $this selected]" \
	    -height 1 -foreground black
    } {keep -background}
    pack $itk_component(mudselector) -side top -fill both -expand true 

    # ... Mud details
    itk_component add muddetails {
	frame $itk_component(mudbox).muddetails
    } {keep -background}
    pack $itk_component(muddetails) -side left -fill both -expand true 
    
    itk_component add detailstitle {
	iwidgets::labeledwidget $itk_component(muddetails).muddet \
	    -labeltext "Mud details:" -labelpos wn
    } { keep -background ; keep -foreground }
    itk_component add name {
	iwidgets::entryfield $itk_component(muddetails).name \
	    -labeltext "  mud name: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _name] \
	    -foreground black
    } {keep -background}
    itk_component add host {
	iwidgets::entryfield $itk_component(muddetails).host \
	    -labeltext "  host: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _host] \
	    -foreground black
    } {keep -background}
    itk_component add port {
	iwidgets::entryfield $itk_component(muddetails).port \
	    -labeltext "  port: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _port] \
	    -foreground black
    } {keep -background}
    pack $itk_component(detailstitle) $itk_component(name) \
	$itk_component(host) $itk_component(port) \
	-side top -fill both -expand true 

    # ... align labels
    iwidgets::Labeledwidget::alignlabels \
	$itk_component(mudselector) \
	$itk_component(detailstitle) $itk_component(name) \
	$itk_component(host) $itk_component(port) 

    # ... fill the selectorbox
    updateMudList


    # === fill buttonbox
    $itk_component(mudbuttons) add new     -text "New..."     -command "[code $this buttonNew]"
    $itk_component(mudbuttons) add edit    -text "Edit..."    -command "[code $this buttonEdit]"
    $itk_component(mudbuttons) add remove  -text "Remove..."  -command "[code $this buttonRemove]"


    # === now at last trigger itk
    eval itk_initialize $args	
}


# ----------------------------------------------------------
# --- buttoncommands
# ----------------------------------------------------------
body TMudManagerUif::buttonNew {} {
    $itk_component(mudEditor) setMode new
    $itk_component(mudEditor) center
    $itk_component(mudEditor) activate
}
body TMudManagerUif::buttonEdit {} {
    set name [$itk_component(mudselector) getcurselection]
    if {![string compare "" $name]} { return }
    set mud  [$_mudManager getMud $name]
    $itk_component(mudEditor) setMud $mud
    $itk_component(mudEditor) setMode edit
    $itk_component(mudEditor) center
    $itk_component(mudEditor) activate
}
body TMudManagerUif::buttonRemove {} {
    set name [string trim $_name]
    if {![$_mudManager exists $name]} {
	TInformer [childsite].mess \
	    -master [winfo toplevel $itk_interior] \
	    -information "A Mud with the name '$name' does not exist!"
	return
    }
    TConfirmer $itk_interior.remove -command "[code $this reallyRemove $name]" \
	-master "[winfo toplevel $itk_interior]" \
	-question "Do you really want to remove the\nmud '$name'?\nYou will loose all information\nbelonging to this mud." 	
}

# ----------------------------------------------------------
# --- other methods
# ----------------------------------------------------------
body TMudManagerUif::updateMudList {args} {
    set ref  0
    set refn 0
    set reff 0
    set refs ""
    if {[llength args]>0} {
	set ref  1
	set refs [lindex $args 0]
    }

    $itk_component(mudselector) delete 0 end
    foreach mn [$_mudManager getMudNames] {
	$itk_component(mudselector) insert end $mn
	if {$ref} {
	    if {![string compare $mn $refs]} {
		set reff 1
	    }
	    if {!$reff} { incr refn }
	}	    
    }
    $itk_component(mudselector) selection clear 0 end
    if {$ref && $reff} {	    
	$itk_component(mudselector) selection set $refn
    } else {
	$itk_component(mudselector) selection set 0
    }
    selected
}
body TMudManagerUif::reallyRemove {aName} {
    $_mudManager rem $aName
    updateMudList
}
body TMudManagerUif::selected {} {
    set name [string trim [$itk_component(mudselector) getcurselection]]
    if {![string compare "" $name]} { return }
    set mud  [$_mudManager getMud $name]
    set _name      $name
    set _host     [$mud host]
    set _port     [$mud port]
}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMudManagerUif.tcl,v $
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
