# $Id: TNamecreator.tcl,v 1.1 2001/12/08 18:53:35 issever Exp $

class TNamecreator {
    inherit iwidgets::Dialogshell

    private variable _fileManager
    private variable _name

    constructor {aFilM args} {} {
	# === configure window
	configure -title "SMM++ Namecreator"
	configure -modality application

	# === set class variables
	set _fileManager $aFilM

	# === create buttons
	add OK          -text OK      -command [code $this buttonOK]
	add Cancel      -text Cancel  -command [code $this buttonCancel]
	default OK	

	# === fill childsite
	# ... name-DB selector
	itk_component add namedb {
	    TNameDB [childsite].db $this $aFilM
	} {keep -background}
	pack $itk_component(namedb) -side top -fill both -expand true 
	# ... randomizer
	itk_component add namernd {
	    TNameRandomizer [childsite].rnd $this $aFilM
	} {keep -background}
	pack $itk_component(namernd) -side top -fill both -expand 0
	# ... name entry
	itk_component add name {
	    iwidgets::entryfield [childsite].name \
		-labeltext "Choosen name: " \
		-state normal \
		-width 30  \
		-textvariable [scope _name] \
		-foreground black
	} {keep -background}
	pack $itk_component(name) \
	    -side top -fill both -expand 0

	# ... align labels
	iwidgets::Labeledwidget::alignlabels \
	    $itk_component(namedb) $itk_component(namernd) \
	    $itk_component(name)

	eval itk_initialize $args	
    }
    method setName {aName} { set _name $aName }
    method buttonOK {} { deactivate "$_name" }
    method buttonCancel {} { deactivate "" }

}
class TNameDB {
    inherit iwidgets::Scrolledlistbox 
    private variable _parent
    private variable _fileManager

    constructor {aParent aFilM args} {} {
	set _parent      $aParent
	set _fileManager $aFilM
	configure -labeltext "Name DB:" 
	configure -labelpos wn 
	configure -selectmode browse 
	configure -selectioncommand "[code $this selected]" 
	configure -foreground black 
	configure -visibleitems 30x15
	_fillNameDB
	eval itk_initialize $args	
    }
    method selected {} {
	set name [string trim [getcurselection]]
	if {![string compare "" $name]} { return }
	$_parent setName $name
    }
    private method _fillNameDB {} {
	set fid [open [$_fileManager getSysNameDB] r]
	foreach dbname [lsort [split [read $fid] "\n"]] {
	    set name [string trim $dbname]
	    if {[string length $name]==0} { continue }
	    insert end $name
	}
	close $fid
    }

}

class TNameRandomizer {
    inherit iwidgets::Labeledwidget
    private variable _parent
    private variable _fileManager

    private variable _vlist 
    private variable _clist
    private variable _vxlist 
    private variable _cxlist

    constructor {aParent aFileManager args} {} {
	configure -labeltext "Random names:"
	set _parent $aParent
	set _fileManager $aFileManager

	itk_component add rbut {
	    iwidgets::pushbutton [childsite].rbut -text Create -command [code $this create]
	} { keep -background }
	pack $itk_component(rbut) -side top -fill both -expand true

	set _vlist [list a e i o u]
	set _vxlist [list ee aa y]
	set _clist [list b c d f g h j k l m n p q r s t v w x y z]
	set _cxlist [list sh ch dsch tsch ll nn mm ph yg qu]

	eval itk_initialize $args	
    }
    private method _initRandom {} {
	expr srand([clock seconds])
    }
    private method _getRandom {aMax} {
	return [expr int(rand()*($aMax+1))]
    }
    private {
	method _getC {}  { return [lindex $_clist  [_getRandom [llength $_clist]]] }
	method _getCx {} { return [lindex $_cxlist [_getRandom [llength $_cxlist]]] }
	method _getV {}  { return [lindex $_vlist  [_getRandom [llength $_vlist]]] }
	method _getVx {} { return [lindex $_vxlist [_getRandom [llength $_vxlist]]] }
	method _getCVC  {}  { return "[_getC][_getV][_getC]"}
	method _getCxVC {}  { return "[_getCx][_getV][_getC]"}
	method _getCVxC {}  { return "[_getC][_getVx][_getC]"}
	method _getVC   {}  { return "[_getV][_getC]"}
	method _getVCx  {}  { return "[_getV][_getCx]"}
	method _getCxV  {}  { return "[_getCx][_getV]"}
	method _getCV   {}  { return "[_getC][_getV]"}
	method _getCVx  {}  { return "[_getC][_getVx]"}
    }

    private method _getSyllable {} {
	set what [_getRandom 7]
	
	switch $what {
	    0 { return [_getCxVC] }
	    1 { return [_getCVxC] }
	    2 { return [_getVC] }
	    3 { return [_getVCx] }
	    4 { return [_getCxV] }
	    5 { return [_getCV] }
	    6 { return [_getCVx] }
	    default { return [_getCVC] }
	}
    }
    method create {} {
	_initRandom
	set numSyllable [_getRandom 2]+2
	set name ""
	for {set i 0} {$i<$numSyllable} {incr i} {
	    append name [_getSyllable]
	}
	set ret "[string toupper [string index $name 0]][string range $name 1 end]"
	$_parent setName $ret
    }

}

# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TNamecreator.tcl,v $
# Revision 1.1  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
#
