# $Id: TSesEditor.tcl,v 1.2 2001/12/08 18:53:35 issever Exp $

class TSesEditor {
    inherit iwidgets::Dialogshell
    public {
	constructor {aParent aSesManager aFilM args} {} {}
	method setMode {aMode} 
	method setSes {aSes} 
	method addSession {} 
	method newMud {}
	method namecreator {}
    }
    private {
	variable _sesManager
	variable _parent
	variable _mode
	variable _ses
	method   _updateMudList {args} 
    }
}

# ##############################################################################

body TSesEditor::constructor {aParent aSesManager aFilM args} {
    set _sesManager $aSesManager
    set _parent     $aParent
    set _mode       "new"
    set _ses        ""

    configure -modality application

    # --- buttons
    add newMud      -text "New Mud..."      -command [code $this newMud]
    add namecreator -text "Namecreator..."  -command [code $this namecreator]
    add ok          -text OK                -command [code $this addSession]
    add cancel      -text Cancel            -command [code $this deactivate]
    default ok

    # --- entries
    itk_component add   name {
	iwidgets::entryfield [childsite].name \
	    -labeltext "session name: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}
    itk_component add   player {
	iwidgets::entryfield [childsite].player \
	    -labeltext "player: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}
    itk_component add   password {
	iwidgets::entryfield [childsite].password \
	    -labeltext "password: " \
	    -width 30 -labelmargin 0 \
	    -foreground black
    } {keep -background}
    itk_component add   mudname {
	iwidgets::combobox [childsite].mn \
	    -popupcursor hand1 -listheight 100  \
	    -labeltext "mud: " -editable 0 \
	    -foreground black
    } {keep -background}

    pack $itk_component(name) $itk_component(player) $itk_component(password) $itk_component(mudname) \
	-side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

    # ... align all that stuff
    iwidgets::Labeledwidget::alignlabels \
	$itk_component(name) $itk_component(player) \
	$itk_component(password) $itk_component(mudname)

    # --- namecreator
    # the name creator doesnt need to be packed, as it is a 
    # separate dialog and will be launched when needed.
    itk_component add namecreator {
	TNamecreator [childsite].nc $aFilM \
	    -master [winfo toplevel [childsite]] \
	    -tops [winfo toplevel [childsite]]
    } {keep -background}

    eval itk_initialize $args	
    _updateMudList
}
body TSesEditor::_updateMudList {args} {
    # this procedure updates the mudselector
    $itk_component(mudname) configure -editable 1 
    $itk_component(mudname) clear 
    foreach mudname [$_sesManager getMudNames] {
	$itk_component(mudname) insert list end $mudname
    }
    $itk_component(mudname) configure -editable 0

    set i 0
    if {[llength $args]>0} {
	foreach mudname [$_sesManager getMudNames] {
	    if {![string compare $mudname [lindex $args 0]]} {
		$itk_component(mudname) configure -editable 1
		$itk_component(mudname) selection clear 0 end
		$itk_component(mudname) selection set $i
		$itk_component(mudname) configure -editable 0
		break
	    }
	    incr i
	}
    }
}
body TSesEditor::setMode {aMode} {
    set _mode $aMode

    $itk_component(name) configure -state normal
    $itk_component(name) clear
    $itk_component(player) clear
    $itk_component(password) clear
    _updateMudList
    
    switch -- $_mode {
	edit {
	    configure -title "Edit session"
	    $itk_component(name)     insert 0 [$_ses name]
	    $itk_component(player)   insert 0 [$_ses player]
	    $itk_component(password) insert 0 [$_ses password]
	    $itk_component(mudname)  configure -editable 1 
	    $itk_component(mudname)  insert entry 0 [$_ses mudName]
	    $itk_component(mudname)  configure -editable 0
	    $itk_component(name) configure -state disabled
	}
	default {
	    configure -title "Create new session"
	}
    }
}
body TSesEditor::setSes {aSes} {set _ses $aSes}
body TSesEditor::addSession {} {
    set name     [string trim [$itk_component(name)     get]]
    set player   [$itk_component(player)   get]
    set password [$itk_component(password) get]
    set mudname  [$itk_component(mudname)  get]
    

    if {![string compare $name ""]} {
	TInformer [childsite].mess \
	    -information "You have to enter a 'name'\nfor the session!"
	return
    }
    if {[string compare $_mode edit]} {
	if {[$_sesManager exists $name]} {
	    TInformer [childsite].mess \
		-information "The session name '$name' exists\nalready. Session names must be unique."
	    return
	}
    }
    
    $_sesManager add $name $player $password $mudname
    $_parent updateSessionList $name

    deactivate
}
body TSesEditor::newMud {} {
    set mudname [lindex [$_parent launchNewMudUif] 0]
    if {[string compare "" $mudname]!=0} {
	_updateMudList $mudname
    }
}
body TSesEditor::namecreator {} {
    $itk_component(namecreator) center
    set player [lindex [$itk_component(namecreator) activate] 0]

    if {[string length $player]>0} {	
	$itk_component(player) clear
	$itk_component(player) insert 0 $player
    }
}

# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TSesEditor.tcl,v $
# Revision 1.2  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
