# $Id: TSesLogging.tcl,v 1.1 2002/05/02 19:47:53 issever Exp $

# ==========================================================
# TSes::TLogging
#     This class is a helper class for the TSession class.
#     it will be inherited by it.
#
# --- This class takes care of logging the trafic between
#     the mud and SMM++. It will log the parsed output.
# ==========================================================

namespace eval TSes {
    class TLogging {
	private {
	    variable _logFile
	    variable _logging
	    variable _logFID
	    variable _logTiming
	    variable _logToMud
	}
	public {
	    # ----------------------------------------------
	    constructor {} {} {}
	    destructor {}
	    # ----------------------------------------------
	    method isLogging {} 
	    # ----------------------------------------------
	    method isLogTiming {} 
	    # ----------------------------------------------
	    method isLogToMud {} 
	    # ----------------------------------------------
	    method logfileExists {} 
	    # ----------------------------------------------
	    method logfile {aFile}  
	    # ----------------------------------------------
	    method logInject {aPart}  
	    # ----------------------------------------------
	    method logFlush {}  
	    # ----------------------------------------------
	    method logTimeOn {}
	    # ----------------------------------------------
	    method logTimeOff {}
	    # ----------------------------------------------
	    method logToMudOn {}
	    # ----------------------------------------------
	    method logToMudOff {}
	    # ----------------------------------------------
	    method logOn {}  
	    # ----------------------------------------------
	    method logOff {} 
	    # ----------------------------------------------
	    method logToggle {} 
	    # ----------------------------------------------
	}

    }


    # ======================================================
    # === class code
    # ======================================================

    # ------------------------------------------------------
    # --- constructor
    # ------------------------------------------------------
    body TLogging::constructor {} {
	set _logFile          ""
	set _logging          0
	set _logTiming	      0
	set _logToMud	      0
	set _logFID           ""

    }
    body TLogging::destructor {} {
	puts "Tlogging des"
	if {[logfileExists]} { 
	    flush $_logFID
	    close $_logFID
	}
    }    

    # ------------------------------------------------------
    # --- checkers
    # ------------------------------------------------------
    body TLogging::isLogging {}   {return $_logging}
    body TLogging::isLogTiming {} {return $_logTiming}
    body TLogging::isLogToMud {}  {return $_logToMud}
    body TLogging::logfileExists {} {
	if {[string compare "" $_logFile]} {
	    return 1
	} else {
	    return 0
	}
    }

    # ------------------------------------------------------
    # --- switches
    # ------------------------------------------------------
    body TLogging::logOn {} { 
	if {![logfileExists]} { return }
	set _logging 1 
    }
    body TLogging::logOff {} { 
	if {![logfileExists]} { return }
	set _logging 0 
	flush $_logFID
    }
    body TLogging::logToggle {} { 
	if {![logfileExists]} { return }

	set _logging [expr !$_logging] 
	if {[isLogging]} {
	    logOn
	} else {
	    logOff
	}
    }
    body TLogging::logTimeOn {} { set _logTiming 1 }
    body TLogging::logTimeOff {} { set _logTiming 0 }
    body TLogging::logToMudOn {} { set _logToMud 1 }
    body TLogging::logToMudOff {} { set _logToMud 0 }

    # ------------------------------------------------------
    # --- doers
    # ------------------------------------------------------
    body TLogging::logfile {aFile}  {
	puts $aFile
	if {[logfileExists]} {
	    # a logfile exists already
	    flush $_logFID
	    close $_logFID
	    $this printf "logfile '$_logFile' closed"
	    if {[catch "open $aFile {WRONLY CREAT APPEND}" nfid]} {
		# cannot open file
		set _logFile ""
		set _logFID  ""
		$this perror "cannot open file $aFile"
	    } else {
		# file is opened
		set _logFile $aFile 
		set _logFID  $nfid
		$this printf "logfile '$_logFile' opened"
	    }
	} else {
	    # no logfile exists up to now
	    if {[catch "open $aFile {WRONLY CREAT APPEND}" nfid]} {
		# cannot open file
		$this perror "cannot open file $aFile"
	    } else {
		# file is opened
		set _logFile $aFile 
		set _logFID  $nfid
		$this printf "logfile '$_logFile' opened"
	    }
	}
    }
    body TLogging::logFlush {} {
	if {[logfileExists]} {
	    flush $_logFID
	}
    }
    body TLogging::logInject {aPart} { 
	puts -nonewline $_logFID $aPart 
    }

    
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TSesLogging.tcl,v $
# Revision 1.1  2002/05/02 19:47:53  issever
# debugged logging and reorganized its code.
#

