# $Id: TSesManagerUif.tcl,v 1.3 2002/04/28 11:13:33 issever Exp $

class TSesManagerUif {
    inherit itk::Widget

    constructor {aParent aSesM aFilM args} {} {}

    # --- variables
    private variable _name
    private variable _player
    private variable _password
    private variable _mudname

    private variable _parent
    private variable _sesManager

    # --- methods: buttons
    public method buttonSesConnect {} 
    public method buttonSesLoad {} 
    public method buttonSesStop {} 
    public method buttonSesNew {} 
    public method buttonSesEdit {}
    public method buttonSesRemove {} 
    
    # --- methods other
    public method reallyRemove {aName} 
    public method selected {} 
    public method updateSessionList {args} 
    public method launchNewMudUif {}
    public method sessionHasBeenStopped {}
    private method   _configureButtons {} 
    
}

# ==========================================================
# === class code
# ==========================================================

# ----------------------------------------------------------
# --- constructor
# ----------------------------------------------------------
body TSesManagerUif::constructor {aParent aSesM aFilM args} {

    # === class variables
    # --- store passed information
    set _parent     $aParent
    set _sesManager $aSesM
    # --- init class variables
    set _name     ""
    set _player   ""
    set _password ""
    set _mudname  ""


    # === create widgets
    # --- main structure from left to right: 
    #     sessionbox, separator-line, buttonbox
    #     plus a dialog to edit or add sessions

    # ... sessionbox
    itk_component add sesbox {
	frame $itk_interior.sesbox
    } {keep -background}
    pack $itk_component(sesbox) -side left -fill both -expand true 
    # ... separator-line
    itk_component add sessep {
	iwidgets::line $itk_interior.sessep \
	    -orient vertical
    } { keep -background }
    pack $itk_component(sessep) -side left -fill both -expand true
    # ... buttonbox
    itk_component add sesbuttons {
	iwidgets::buttonbox $itk_interior.bb \
	    -orient vertical
    } { keep -background ; keep -foreground }
    pack $itk_component(sesbuttons) -side left -fill both -expand false 
    # ... session editor
    itk_component add sesEditor {
	TSesEditor $itk_interior.sesDialog $this $_sesManager $aFilM \
	    -master [winfo toplevel $itk_interior] \
	    -tops [winfo toplevel $itk_interior]
    } {keep -background ; keep -foreground }

    
    # === fill sessionbox
    # ... Sessions selector
    itk_component add sesselector {
	iwidgets::scrolledlistbox $itk_component(sesbox).ms \
	    -labeltext "Sessions:" -labelpos wn \
	    -selectmode browse \
	    -selectioncommand "[code $this selected]" \
	    -height 1 -foreground black
    } {keep -background}
    pack $itk_component(sesselector) -side top -fill both -expand true 
    #addFGCom [code $itk_component(sesselector) configure -foreground %c] 

    # ... Session details
    itk_component add sesdetails {
	frame $itk_component(sesbox).sesdetails
    } {keep -background}
    pack $itk_component(sesdetails) -side left -fill both -expand true 
    
    itk_component add sesdetailstitle {
	iwidgets::labeledwidget $itk_component(sesdetails).sesdet \
	    -labeltext "Session details:" -labelpos wn
    } { keep -background ; keep -foreground }
    itk_component add sesname {
	iwidgets::entryfield $itk_component(sesdetails).name \
	    -labeltext "  session name: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _name] \
	    -foreground black
    } {keep -background}
    itk_component add sesplayer {
	iwidgets::entryfield $itk_component(sesdetails).player \
	    -labeltext "  player: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _player] \
	    -foreground black
    } {keep -background}
    itk_component add sespassword {
	iwidgets::entryfield $itk_component(sesdetails).password \
	    -labeltext "  password: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _password] \
	    -foreground black
    } {keep -background}
    itk_component add sesmudname {
	iwidgets::entryfield $itk_component(sesdetails).mn \
	    -labeltext "  mud: " \
	    -state disabled \
	    -width 20 -labelmargin 0 \
	    -textvariable [scope _mudname] \
	    -foreground black
    } {keep -background}
    pack $itk_component(sesdetailstitle) $itk_component(sesname) \
	$itk_component(sesplayer) $itk_component(sespassword) \
	$itk_component(sesmudname) \
	-side top -fill both -expand true 

    # ... align labels
    iwidgets::Labeledwidget::alignlabels \
	$itk_component(sesselector) \
	$itk_component(sesdetailstitle) $itk_component(sesname) \
	$itk_component(sesplayer) $itk_component(sespassword) \
	$itk_component(sesmudname) 

    # ... fill the selectorbox
    updateSessionList


    # === fill buttonbox
    $itk_component(sesbuttons) add connect -text "Connect"    -command "[code $this buttonSesConnect]"
    $itk_component(sesbuttons) add load    -text "Load"       -command "[code $this buttonSesLoad]"
    $itk_component(sesbuttons) add stop    -text "Stop"       -command "[code $this buttonSesStop]"
    $itk_component(sesbuttons) add new     -text "New..."     -command "[code $this buttonSesNew]"
    $itk_component(sesbuttons) add edit    -text "Edit..."    -command "[code $this buttonSesEdit]"
    $itk_component(sesbuttons) add remove  -text "Remove..."  -command "[code $this buttonSesRemove]"
    # ... configure buttons
    _configureButtons


    # === now at last trigger itk
    eval itk_initialize $args	
}

# ----------------------------------------------------------
# --- buttoncommands
# ----------------------------------------------------------
body TSesManagerUif::buttonSesConnect {} {
    # also start connection to mud
    set name [string trim $_name]
    $_parent startSession $name 1
    _configureButtons
}    
body TSesManagerUif::buttonSesLoad {} {
    # dont build connction
    set name [string trim $_name]
    $_parent startSession $name 0
    _configureButtons
}
body TSesManagerUif::buttonSesStop {} {
    $_sesManager stopSession
    _configureButtons
}
body TSesManagerUif::sessionHasBeenStopped {} {
    _configureButtons
}
body TSesManagerUif::buttonSesNew {} {
    $itk_component(sesEditor) setMode new
    $itk_component(sesEditor) center
    $itk_component(sesEditor) activate
}
body TSesManagerUif::buttonSesEdit {} {
    set name [$itk_component(sesselector) getcurselection]
    if {![string compare "" $name]} { return }
    set ses  [$_sesManager getSes $name]
    $itk_component(sesEditor) setSes $ses
    $itk_component(sesEditor) setMode edit
    $itk_component(sesEditor) center
    $itk_component(sesEditor) activate
}
body TSesManagerUif::buttonSesRemove {} {
    set name [string trim $_name]
    if {![$_sesManager exists $name]} {
	TInformer [childsite].mess \
	    -master [winfo toplevel $itk_interior] \
	    -information "A Session with the name '$name' does not exist!"
	return
    }
    TConfirmer $itk_interior.remove -command "[code $this reallyRemove $name]" \
	-master "[winfo toplevel $itk_interior]" \
	-question "Do you really want to remove the\nsession '$name'?\nYou will loose all information\nbelonging to this session." 	
}


# ----------------------------------------------------------
# --- other methods
# ----------------------------------------------------------
body TSesManagerUif::_configureButtons {} {
    if {[$_sesManager sessionStarted]} {
	$itk_component(sesbuttons)    buttonconfigure 0 -state disabled
	$itk_component(sesbuttons)    buttonconfigure 1 -state disabled
	$itk_component(sesbuttons)    buttonconfigure 2 -state normal
	$itk_component(sesbuttons)    buttonconfigure 3 -state normal
	$itk_component(sesbuttons)    buttonconfigure 4 -state disabled
	$itk_component(sesbuttons)    buttonconfigure 5 -state disabled
    } else {				       
	$itk_component(sesbuttons)    buttonconfigure 0 -state normal
	$itk_component(sesbuttons)    buttonconfigure 1 -state normal
	$itk_component(sesbuttons)    buttonconfigure 2 -state disabled
	$itk_component(sesbuttons)    buttonconfigure 3 -state normal
	$itk_component(sesbuttons)    buttonconfigure 4 -state normal
	$itk_component(sesbuttons)    buttonconfigure 5 -state normal
    }
}
body TSesManagerUif::updateSessionList {args} {
    set ref  0
    set refn 0
    set reff 0
    set refs ""
    if {[llength args]>0} {
	set ref  1
	set refs [lindex $args 0]
    }

    $itk_component(sesselector) delete 0 end
    foreach mn [$_sesManager getSesNames] {	    
	$itk_component(sesselector) insert end $mn
	if {$ref} {
	    if {![string compare $mn $refs]} {
		set reff 1
	    }
	    if {!$reff} { incr refn }
	}	    
    }
    $itk_component(sesselector) selection clear 0 end
    if {$ref && $reff} {	    
	$itk_component(sesselector) selection set $refn
    } else {
	$itk_component(sesselector) selection set 0
    }
    selected
}
body TSesManagerUif::reallyRemove {aName} {
    $_sesManager rem $aName
    updateSessionList
}
body TSesManagerUif::selected {} {
    set name [string trim [$itk_component(sesselector) getcurselection]]
    if {![string compare "" $name]} { return }
    set ses  [$_sesManager getSes $name]
    set _name      $name
    set _player   [$ses player]
    set _password [$ses password]
    set _mudname  [$ses mudName]
}
body TSesManagerUif::launchNewMudUif {} {
    return [$_parent launchNewMudUif]
}

# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TSesManagerUif.tcl,v $
# Revision 1.3  2002/04/28 11:13:33  issever
# put menu->stop session back in place
# debug: sesManagerUif buttons showed wrong state,
#   when the menu was used to stop the session
# added save all maps menu entry
#
# Revision 1.2  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
