# $Id: TSesMudManager.tcl,v 1.3 2002/04/28 11:13:33 issever Exp $

# This is the combined Mud and Session Manager.
# The SesMudManager is not managed by the colormanager. 
# The foreground color usually should be handled by it.

class TSesMudManager {
    inherit iwidgets::Dialogshell

    public {
	constructor {aMainGui aSesM aMudM aFilM args} {} {}
	method launchUif {}
	method buttonCancel {}
	method startSession {aName aCon}
	method launchNewMudUif {}
	method sessionHasBeenStopped {}
    }
    private {
	variable _sesManager
	variable _mudManager
	variable _mainGui
    }
}

# ==========================================================
# === class code
# ==========================================================
body TSesMudManager::launchNewMudUif {} { 
    return [$itk_component(mudManager) buttonNew]
}
body TSesMudManager::launchUif {} { 
    center 
    activate 
}
body TSesMudManager::sessionHasBeenStopped {} {
    $itk_component(sesManager) sessionHasBeenStopped
}

body TSesMudManager::buttonCancel {} { 
    deactivate 
}

body TSesMudManager::startSession {aName aCon} {
    $_sesManager   newActSes $aName
    $_mainGui      newSes
    $_sesManager   connectActSes $_mainGui $aCon
    buttonCancel
}

body TSesMudManager::constructor {aMainGui aSesM aMudM aFilM args} {
    # === class variables
    set _mainGui    $aMainGui
    set _sesManager $aSesM
    set _mudManager $aMudM

    # === the window itself
    configure -title "Mud & Session Manager"
    configure -modality application
    configure -width 700
    configure -height 500
    # --- window buttons
    Dialogshell::add Close -text Close -command [code $this buttonCancel]
    
    # === the tabnotebook
    itk_component add tnb {
	iwidgets::tabnotebook [childsite].tnb \
	    -tabpos n \
	    -raiseselect 1 \
	    -tabbackground $TColor::BGdef \
	    -backdrop $TColor::BGdef
    } { keep -background ; keep -foreground}
    $itk_component(tnb) add -label Sessions
    $itk_component(tnb) add -label Muds
    $itk_component(tnb) select Sessions
    pack $itk_component(tnb) -side top -fill both -expand yes

    # === session tab
    itk_component add sesManager {
	TSesManagerUif [$itk_component(tnb) childsite Sessions].sesuif $this $_sesManager $aFilM
    } {keep -background}
    pack $itk_component(sesManager) -side top -fill both -expand true 

    # === mud tab
    itk_component add mudManager {
	TMudManagerUif [$itk_component(tnb) childsite Muds].muduif $this $_mudManager
    } {keep -background}
    pack $itk_component(mudManager) -side top -fill both -expand true 


    eval itk_initialize $args	
}




# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TSesMudManager.tcl,v $
# Revision 1.3  2002/04/28 11:13:33  issever
# put menu->stop session back in place
# debug: sesManagerUif buttons showed wrong state,
#   when the menu was used to stop the session
# added save all maps menu entry
#
# Revision 1.2  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
# Revision 1.1  2001/12/07 23:58:05  issever
# The code structure has changed while implementing the mud and session manager
#
