# $Id: TBG.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

# Class TBG is unnecessary, as TBG will be a TIMAGE 
class TBGUif {
    inherit itk::Widget

    variable CBGIM
    variable CSelector

    variable CActBG
    variable CDefBG

    variable CParent

    method clearUif {} {
	remBG
    }
    method setUif {aRoom} {
	clearUif
	setBG [$aRoom bg]
    }
    method remBG {} {
	$CParent removeTheRoom
	set CActBG ""
	$itk_component(but) configure -image [$CBGIM getImage system bg none]
    }
    method exists {} {
	return [string compare "" $CActBG]
    }
    method setDefBG {imo} {
	set CDefBG $imo
    }
    method createTheRoom {} {
	if {![exists]} {setBG $CDefBG}
    }
    method setBG {imo} {
	set CActBG $imo
	$CParent setBG $imo
	$itk_component(but) configure -image [$CBGIM getImage [$imo getType] [$imo getCategory] [$imo getName]]
    }
    method getBG {} {
	return $CActBG
    }
    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }
    constructor {aParent aBGIM args} {
	set CBGIM $aBGIM
	regsub -- {^::} $aParent {} CParent	

	itk_component   add but { button $itk_interior.but } {keep -background}
	pack $itk_component(but) -fill none -expand false -ipadx 0 -ipady 0 -padx 0 -pady 0 
	bind $itk_component(but) <<ZIFExtended>>       "[code $this launchUIF]"
	bind $itk_component(but) <<ZIFShortcut>>       "[code $this shortCutAction]"
	
	set CActBG ""
	$itk_component(but) configure -image [$CBGIM getImage system bg none]
	setDefBG [$CBGIM getObject bg_bw_ontop misc def]

	# create selector window, which is hiden at first
	set CSelector  $itk_interior.bgselector 
	itk_component add selec {
	    TBGSelector $CSelector $this $CBGIM \
	    -master [winfo toplevel $itk_interior] \
	    -tops [winfo toplevel $itk_interior] 
	} {
	    keep -background
	    keep -foreground
	}
	eval itk_initialize $args
    }

    method shortCutAction {} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	if {[exists]} {
	    remBG
	} else {
	    setBG $CDefBG	    
	}
    }

    method launchUIF {} { 
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	$CSelector activate 
    }

}

###############################################################
class TBGSelector {
    inherit iwidgets::Shell

    variable CBGIM
    variable CParent

    variable CSetMode 

    constructor {aParent aBGIM args} {
	configure -modality application

	regsub -- {^::} $aParent {} CParent

	set CBGIM    $aBGIM
	
	set wid [$this childsite]

	# create buttons
	itk_component add   butframe {frame $wid.butframe -relief ridge -bd 2 } {keep -background}
	pack $itk_component(butframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add   defbg {
	    button $itk_component(butframe).defbg -width 1 \
		-text "set def. bg" -command "[code $this defbg]"
	} {keep -background;keep -foreground}
	pack $itk_component(defbg) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component add   rem {
	    button $itk_component(butframe).rem -width 1 \
		-text "remove" -command "[code $this remove]"
	} {keep -background;keep -foreground}
	pack $itk_component(rem) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component add   canc {
	    button $itk_component(butframe).canc -width 1 \
		-text "cancel" -command "[code $this canc]"
	} {keep -background;keep -foreground}
	pack $itk_component(canc) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	# descriptor
	itk_component add   dframe {frame $wid.dframe -relief ridge -bd 2 } {keep -background}
	pack $itk_component(dframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add   desc   { 
	    label $itk_component(dframe).l -justify center -textvariable _TBGSelector($this,l) \
		-font bigBold -background $TColor::BGlight -width 60
	} { ignore -background ; keep -foreground}
	pack $itk_component(desc) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	
	# go into default "set bg" mode
	defaultMode

	# create bg buttons
	set c 0
	set io 0
	foreach type [list bg_bw_ontop bg_bw_below bg_color_ontop bg_color_below] {
	    foreach category [$CBGIM getCategories $type] {
		itk_component  add c$c { 
		    frame $wid.c$c -relief ridge -borderwidth 2 
		}
		pack $itk_component(c$c) -fill both -expand true -padx 0 -pady 0 -side top
		foreach imobj [$CBGIM getObjects $type $category] {
		    itk_component   add but$io { 
			button $itk_component(c$c).but$io  -image [$imobj getImage] \
			    -command "[code $this selectBG $imobj]"
		    } {keep -background;keep -foreground}
		    pack $itk_component(but$io) -side left -fill none -expand false \
			-ipadx 0 -ipady 0 -padx 0 -pady 0 
		    bind $itk_component(but$io) <Enter> "[code $this setText $imobj]"
		    bind $itk_component(but$io) <Leave> "[code $this remText]"

		    incr io
		}
		incr c
	    }
	}

	eval itk_initialize $args
    }
    method remText {} {
	global _TBGSelector
	set _TBGSelector($this,l) ""
    }
    method setText {imo} {
	global _TBGSelector
	set _TBGSelector($this,l) "[$imo getType] [$imo getCategory] [$imo getName]"
    }
    method remove {} {
	$CParent remBG
	canc
    }
    method defbg {} {
	if {$CSetMode} {
	    chooseDefBGMode
	} else {
	    defaultMode
	}
    }
    method chooseDefBGMode {} {
	set CSetMode 0
	configure -title "Default Background Selection"
	$itk_component(defbg) configure -text "choose bg  " 
   }
    method defaultMode {} {
	configure -title "Background Selection"
	$itk_component(defbg) configure -text "set def. bg" 
	set CSetMode 1
    }
    method canc {} { 
	defaultMode
	$this deactivate 
    }
    method selectBG {imo} {
	if {$CSetMode} {
	    $CParent setBG $imo
	} else {
	    $CParent setDefBG $imo
	}
	canc
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TBG.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
