# $Id: TCoordinate.tcl,v 1.5 2002/04/21 18:03:16 issever Exp $

### class definition ----------------------------------------
class TCoordinate {
    
    # global var: _TCoord(n$CNum,x|y)

    private common    COANum 0
    protected variable   CNum

    constructor {args} {} ;# takes 0 args, 1 arg: another coord, 2 args: x/y
    destructor {}

    method = {source}
    method isequal {source}
    method setX {aX}
    method setY {aY}
    method setXY {aX aY}
    method setXYc {aXY}
    method move {dir}
    method moveby {aX aY}

    method getX {}
    method getY {}
    method getXY {}
    proc   GETXY {X Y}
    proc   GETX {XY}
    proc   GETY {XY}
    method show {}
    method showval {}

    method isNull {}
    method streamout {}   { return [list [getX] [getY]]}
    method streamin {arg} { setXY [lindex $arg 0] [lindex $arg 1] }

    method getNum {}     { return $CNum }
    proc   getPairID {a1 a2} {
	if {[string compare [$a1 getXY] [$a2 getXY]] < 0} {
	    return "[$a1 getXY]'[$a2 getXY]"
	} else {
	    return "[$a2 getXY]'[$a1 getXY]"
	}
    }
    proc   cmp {a1 a2} {
	return [string compare [$a1 getXY] [$a2 getXY]]
    }

}
class TPosition {
    inherit TCoordinate

    variable CMap ""

    constructor {args} {TCoordinate::constructor} {}
    # 0: default empty
    # 1: another TPosition
    # 2: map, coord
    # 3: map, x, y
    method = {source}
    method setMap {aMap}   ;# sets object pointer to a TMap
    method getMap {}       ;# returns object pointer
    method exists {} { return [expr ![string match "" $CMap]]}
    method setNull {} { set CMap "" ; TCoordinate::setXY 0 0 }
    method != {source}
    method getMapName {} { return [$CMap name]}
    method getMapLevel {} { return [$CMap level]}
    method cmp {aMap aX aY} {
	if {[$CMap != $aMap]} { return 0}
	if {[getX] != $aX }   { return 0}
	if {[getY] != $aY }   { return 0}
	return 1
    }
}

class TCoordinateUif {
    inherit itk::Widget TCoordinate
    
    itk_option define -orient orient Orient "h" 
    itk_option define -xtext xText Text "x: "
    itk_option define -ytext yText Text "y: "
    itk_option define -borderwidth borderWidth Width 0
    itk_option define -width width Width 4
    itk_option define -relief relief Relief "ridge"
    itk_option define -font font Font defFixed
    itk_option define -validate validate Command {integer}
    itk_option define -command command Command ""
    itk_option define -focuscommand focusCommand Command ""

    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }

    constructor {args} {
	TCoordinate::constructor
    } {
	global _TCoord
	# mainframe
	itk_component add   mainframe { frame $itk_interior.mf } {
	    keep -background
	}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	# X
	itk_component add   x {
	    iwidgets::entryfield $itk_component(mainframe).x -labeltext "x: " \
		-width 4 -validate integer -textfont defFixed \
		-command "[code $this evalCom]" \
		-labelmargin 0 -labelfont defFixed -textvariable _TCoord(n$CNum,x)
	} {
	    keep -background
	    keep -foreground
	}
	# Y
	itk_component add   y {
	    iwidgets::entryfield $itk_component(mainframe).y -labeltext "y: " \
		-width 4 -validate integer -textfont defFixed \
		-command "[code $this evalCom]" \
		-labelmargin 0 -labelfont defFixed -textvariable _TCoord(n$CNum,y)
	} {
	    keep -background
	    keep -foreground
	}

	# pack x/y
	pack $itk_component(x) $itk_component(y) \
	    -fill both -expand false -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
	iwidgets::Labeledwidget::alignlabels $itk_component(x) $itk_component(y)

	eval itk_initialize $args
    }
    method evalCom {} {
	if {![string compare "" $itk_option(-command)]} {
	    return
	}
	regsub -all {%x} $itk_option(-command) [getX]  helper
	regsub -all {%y} $helper               [getY]  theCom
	eval $theCom
    }
    method redirect { aNum } {
	global _TCoord
	if {[info exists  _TCoord(n$CNum,x)]} { unset _TCoord(n$CNum,x) }
	if {[info exists  _TCoord(n$CNum,y)]} { unset _TCoord(n$CNum,y) }
	
	set CNum $aNum
	$itk_component(mainframe).x configure -textvariable _TCoord(n$CNum,x)
	$itk_component(mainframe).y configure -textvariable _TCoord(n$CNum,y)
    }
    method setNull {} {
	global _TCoord
	set _TCoord(n$CNum,x) ""
	set _TCoord(n$CNum,y) ""
    }
    method alignLabels {} {
	if {[string match "v" $itk_option(-orient)]} {
	    if {[string match "" $itk_option(-ytext)]} {
		if {![string match "" $itk_option(-xtext)]} {
		    $itk_component(y) configure -labeltext " "
		}
	    }
	    if {[string match "" $itk_option(-xtext)]} {
		if {![string match "" $itk_option(-ytext)]} {
		    $itk_component(x) configure -labeltext " "
		}
	    }
	    iwidgets::Labeledwidget::alignlabels $itk_component(x) $itk_component(y)	    
	}
    }
}
#----------------------------------------
configbody TCoordinateUif::relief {
    switch -- $itk_option(-relief) {
	flat - raised - sunken - ridge - groove {
	    $itk_component(mainframe) configure -relief $itk_option(-relief)
	}
	default { error "bad value \"$itk_option(-relief)\"" }
    }
}
configbody TCoordinateUif::borderwidth {
    if {[regexp -- {^[0-9]+} $itk_option(-borderwidth) ]} {
	$itk_component(mainframe) configure -bd $itk_option(-borderwidth)
    } else {
	error "bad value \"$itk_option(-borderwidth)\"" 
    }
}
configbody TCoordinateUif::focuscommand {
    $itk_component(x) configure -focuscommand $itk_option(-focuscommand)
    $itk_component(y) configure -focuscommand $itk_option(-focuscommand)
}
configbody TCoordinateUif::xtext {
    $itk_component(x) configure -labeltext $itk_option(-xtext)
    $itk_component(y) configure -labeltext $itk_option(-ytext)
    TCoordinateUif::alignLabels
}
configbody TCoordinateUif::command {
}
configbody TCoordinateUif::validate {
    $itk_component(x) configure -validate $itk_option(-validate)
    $itk_component(y) configure -validate $itk_option(-validate)
    TCoordinateUif::alignLabels
}
configbody TCoordinateUif::ytext {
    $itk_component(x) configure -labeltext $itk_option(-xtext)
    $itk_component(y) configure -labeltext $itk_option(-ytext)
    TCoordinateUif::alignLabels
}
configbody TCoordinateUif::font {
    $itk_component(x) configure -textfont $itk_option(-font) -labelfont $itk_option(-font)
    $itk_component(y) configure -textfont $itk_option(-font) -labelfont $itk_option(-font)
    TCoordinateUif::alignLabels
}
configbody TCoordinateUif::width {
    if {[regexp -- {^[0-9]+} $itk_option(-borderwidth) ]} {
	$itk_component(x) configure -width $itk_option(-width)
	$itk_component(y) configure -width $itk_option(-width)
	TCoordinateUif::alignLabels
    } else {
	error "bad value \"$itk_option(-width)\"" 
    }
}
configbody TCoordinateUif::orient {
    switch -- $itk_option(-orient) {
	h {
	    pack forget $itk_component(x) $itk_component(y)
	    pack        $itk_component(x) $itk_component(y) \
		-fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	}
	v {
	    pack forget $itk_component(x) $itk_component(y)
	    pack        $itk_component(x) $itk_component(y) \
		-fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
	    TCoordinateUif::alignLabels
	}
	default { error "bad value \"$itk_option(-orient)\"" }
    }
}
#----------------------------------------
itk::usual TCoordinateUif {
    keep -background
}
######################################################
body TPosition::constructor {args} {
    switch [llength $args] {
	0 {}
	1 { TPosition::= $args }
	2 { set CMap [lindex $args 0] 
	    TCoordinate::= [lindex $args 1] }
	3 { set CMap [lindex $args 0] 
	    TCoordinate::setX [lindex $args 1] 
	    TCoordinate::setY [lindex $args 1] }
    }
}
body TPosition::setMap {aMap} { set CMap $aMap }
body TPosition::getMap {} { return $CMap }
body TPosition::= {source} {
    set CMap [$source getMap]
    TCoordinate::= $source
}
body TPosition::!= {source} {
    if {[string compare $CMap [$source getMap]] != 0} {
	return 1
    }
    if {[TCoordinate::isequal $source]} {
	return 0
    } else {
	return 1
    }
}
######################################################
body TCoordinate::constructor {args} {
    global _TCoord

    set CNum $COANum

    switch [llength $args] {
	0 {
	    set _TCoord(n$CNum,x) 0
	    set _TCoord(n$CNum,y) 0
	}
	1 {
	    set _TCoord(n$CNum,x) [$args getX]
	    set _TCoord(n$CNum,y) [$args getY]
	}
	2 {
	    set _TCoord(n$CNum,x) [lindex $args 0]
	    set _TCoord(n$CNum,y) [lindex $args 1]
	}
	default {
	    error "Wrong numer of arguments to TCoordinate constructor!"
	}
    }
    incr COANum
}
body TCoordinate::destructor {} {
    global _TCoord
    if {[info exists  _TCoord(n$CNum,x)]} { unset _TCoord(n$CNum,x) }
    if {[info exists  _TCoord(n$CNum,y)]} { unset _TCoord(n$CNum,y) }
}
body TCoordinate::= {source} {
    global _TCoord
    set _TCoord(n$CNum,x) [$source getX]
    set _TCoord(n$CNum,y) [$source getY]
}
body TCoordinate::isNull {} {
    global _TCoord
    if {[string compare "" $_TCoord(n$CNum,x)]} { return 0 }
    if {[string compare "" $_TCoord(n$CNum,y)]} { return 0 }
    return 1
}
body TCoordinate::isequal {source} {
    if { [string compare "[getXY]" "[$source getXY]"]==0 } {
	return 1
    } else {
	return 0
    }
}
#------------------------------------------------------
body TCoordinate::setX {aX} {
    global _TCoord
    set _TCoord(n$CNum,x) $aX
}
body TCoordinate::setY {aY} {
    global _TCoord
    set _TCoord(n$CNum,y) $aY
}
body TCoordinate::setXY {aX aY} {
    global _TCoord
    set _TCoord(n$CNum,x) $aX
    set _TCoord(n$CNum,y) $aY
}
body TCoordinate::setXYc {aXY} {
    global _TCoord
    regexp -- {(.*),(.*)} $aXY dummy _TCoord(n$CNum,x) _TCoord(n$CNum,y)
}
body TCoordinate::moveby {aX aY} {
    global _TCoord
    incr _TCoord(n$CNum,x) $aX
    incr _TCoord(n$CNum,y) $aY   
}
body TCoordinate::move {dir} {
    global _TCoord
    switch -regexp -- $dir {
	nw {
	    incr _TCoord(n$CNum,y) +1
	    incr _TCoord(n$CNum,x) -1
	}
	nc {
	    incr _TCoord(n$CNum,y) +1
	}
	ne {
	    incr _TCoord(n$CNum,y) +1
	    incr _TCoord(n$CNum,x) +1
	}
	cw {
	    incr _TCoord(n$CNum,x) -1
	}
	ce {
	    incr _TCoord(n$CNum,x) +1
	}
	sw {
	    incr _TCoord(n$CNum,y) -1
	    incr _TCoord(n$CNum,x) -1
	}
	sc {
	    incr _TCoord(n$CNum,y) -1
	}
	se {
	    incr _TCoord(n$CNum,y) -1
	    incr _TCoord(n$CNum,x) +1
	}
	[ud][ox] {
	}
	default {
	    error "No such move-coordinate direction: '$dir'!"
	}
    }
}
#------------------------------------------------------
body TCoordinate::show {} {
    global _TCoord
    puts "(x,y) = ($_TCoord(n$CNum,x),$_TCoord(n$CNum,y))"
}
body TCoordinate::showval {} {
    global _TCoord
    return "(x,y) = ($_TCoord(n$CNum,x),$_TCoord(n$CNum,y))"
}
body TCoordinate::getX {} {
    global _TCoord
    return $_TCoord(n$CNum,x)
}
body TCoordinate::getY {} {
    global _TCoord
    return $_TCoord(n$CNum,y)
}
body TCoordinate::getXY {} {
    global _TCoord
    return "$_TCoord(n$CNum,x),$_TCoord(n$CNum,y)"
}
body TCoordinate::GETXY {X Y} {
    return "$X,$Y"
}
body TCoordinate::GETX {XY} {
    regexp -- {(.*),.*} dummy retval
    return $retval
}
body TCoordinate::GETY {XY} {
    regexp -- {.*,(.*)} dummy retval
    return $retval
}





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TCoordinate.tcl,v $
# Revision 1.5  2002/04/21 18:03:16  issever
# made ccp und dnd much smarter about exits leading to
# and coming from other maps.
#
# Revision 1.4  2002/04/06 00:28:48  issever
# added setXYc
# added missing bodies of GETX and GETY
#
# Revision 1.3  2002/02/11 20:24:32  issever
# cut/copy/paste for maps, drag&drop, code cleanup of mapmanager
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
