# $Id: TExit.tcl,v 1.9 2002/04/21 18:03:16 issever Exp $

# ==========================================================
# TExit
#
# --- This is the exit object as such. They will be filled
#     into the TExitList.
#
# ==========================================================


# ==========================================================
# === TExit
# ==========================================================

class TExit {
    # ------------------------------------------------------
    # --- con- & destructor
    # ------------------------------------------------------
    constructor {args} {}
    destructor {}

    # ------------------------------------------------------
    # --- vars
    # ------------------------------------------------------
    private {
	variable CDir          ""  ;#- the direction whre the exit is located in the room
	variable CExitCommand  ""  ;#- The command that should be sent to the mud, when this exit is entered

	variable CDoor         ""  ;#- Indicator for doors: [door|no door]
	variable CDoorOpen     ""
	variable CDoorClose    ""

	variable CMap          ""  ;#- The Map this exit leads to.
	variable CMapLevel     ""  ;#- The Map this exit leads to.
	variable CConnectTo    ""  ;#- the coordinate the exits leads to
	variable CDrawTo       ""  ;#- the coordinate the exits is drawn to _on_the_same_map_.

	variable CConThickness    "2"
	variable CConColor        "black"
    }

    # ------------------------------------------------------
    # --- streamers
    # ------------------------------------------------------
    method streamout {}
    method streamin  {arg}

    # ------------------------------------------------------
    # --- setters/getters/testers
    # ------------------------------------------------------
    method =               {source} 
    method getDir          {} {return $CDir}
    method getMap          {} {return $CMap}
    method getMapLevel     {} {return $CMapLevel}
    method getCommand      {} {return $CExitCommand}
    method getDoor         {} {return $CDoor}
    method hasDoor         {} {return $CDoor}
    method getDoorOpen     {} {return $CDoorOpen}
    method getDoorClose    {} {return $CDoorClose}
    method getConnectTo    {} {return $CConnectTo}
    method getDrawTo       {} {return $CDrawTo}
    method getConThickness {} {return $CConThickness}
    method getConColor     {} {return $CConColor}

    method setCommand {aCom} { set CExitCommand $aCom}

    method setMap          {arg} {set CMap      $arg}
    method setMapLevel     {arg} {set CMapLevel $arg}



    method moveby {aX aY} {
	$CConnectTo moveby $aX $aY
	$CDrawTo moveby $aX $aY
    }
    method moveConnectBy {aX aY} {
	$CConnectTo moveby $aX $aY
    }
    method moveDrawBy {aX aY} {
	$CDrawTo moveby $aX $aY
    }
    method setXY {aX aY} {
	$CConnectTo setXY $aX $aY
	$CDrawTo    setXY $aX $aY
    }
    method isntPointingToSameMap {} {
	return [string length $CMap]
    }
    
}




# ==========================================================
# === TExit
# ==========================================================

# ----------------------------------------------------------
# --- con- & destructor
# ----------------------------------------------------------
body TExit::constructor {args} {
    switch [llength $args] {
	0 {		
	    set CConnectTo           [TCoordinate ::\#auto ]
	    set CDrawTo              [TCoordinate ::\#auto    ]
	}
	1 {
	    set CConnectTo           [TCoordinate ::\#auto ]
	    set CDrawTo              [TCoordinate ::\#auto    ]
	    TExit::= $args
	}
	11 {
	    set CDir                 [lindex $args 0]
	    set CMap                 [lindex $args 1]
	    set CMapLevel            [lindex $args 2]
	    set CConnectTo           [TCoordinate ::\#auto [lindex $args 3]]
	    set CDrawTo              [TCoordinate ::\#auto [lindex $args 4]]
	    set CExitCommand         [lindex $args 5]
	    set CDoor                [lindex $args 6]
	    set CDoorOpen            [lindex $args 7]
	    set CDoorClose           [lindex $args 8]
	    set CConThickness        [lindex $args 9]
	    set CConColor            [lindex $args 10]
	}
	default {
	    error "Wrong numer of arguments to constructor!"
	}
	
    }	
} 
body TExit::destructor {} {
    ::delete object $CConnectTo
    ::delete object $CDrawTo
}

# ----------------------------------------------------------
# --- streamers
# ----------------------------------------------------------
body TExit::streamout {} {
    return [list $CDir $CExitCommand $CDoor $CDoorOpen $CDoorClose $CMap $CMapLevel [$CConnectTo streamout] [$CDrawTo streamout] $CConThickness $CConColor]
}
body TExit::streamin {arg} {
    set CDir                 [lindex $arg 0]
    set CExitCommand         [lindex $arg 1]
    set CDoor                [lindex $arg 2]
    set CDoorOpen            [lindex $arg 3]
    set CDoorClose           [lindex $arg 4]
    set CMap                 [lindex $arg 5]
    set CMapLevel            [lindex $arg 6]
    $CConnectTo streamin     [lindex $arg 7]
    $CDrawTo    streamin     [lindex $arg 8]
    set CConThickness        [lindex $arg 9]
    set CConColor            [lindex $arg 10]
}



# ----------------------------------------------------------
# --- setters and getters
# ----------------------------------------------------------
body TExit::= {source} {
    set CDir          [$source getDir]
    set CMap          [$source getMap]
    set CMapLevel     [$source getMapLevel]
    set CExitCommand  [$source getCommand]
    set CDoor         [$source getDoor]
    set CDoorOpen     [$source getDoorOpen]
    set CDoorClose    [$source getDoorClose]
    ::delete object $CConnectTo $CDrawTo
    set CConnectTo           [TCoordinate ::\#auto [$source getConnectTo]]
    set CDrawTo              [TCoordinate ::\#auto    [$source getDrawTo]]
    set CConColor       [$source getConColor]
    set CConThickness   [$source getConThickness]
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TExit.tcl,v $
# Revision 1.9  2002/04/21 18:03:16  issever
# made ccp und dnd much smarter about exits leading to
# and coming from other maps.
#
# Revision 1.8  2002/04/06 01:31:16  issever
# debugged cut/copy/paste in maps. In fact it was quite a redo
# of the code, but now it works fine.
# Area to be pasted will be indicated.
#
# Revision 1.7  2002/04/05 20:35:27  issever
# splited the file TExit.tcl
# removed a small bug
#
# Revision 1.6  2002/04/04 21:07:03  issever
# Optimized the expr's, which are used in the mapping code.
# Splited the File TEXit.tcl.
#
# Revision 1.5  2002/03/07 21:52:03  moth
# Don't lose door open/close commands if they're already set.  And, use
# directional door names by default.
#
# Revision 1.4  2002/02/11 20:24:32  issever
# cut/copy/paste for maps, drag&drop, code cleanup of mapmanager
#
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
