# $Id: TExitList.tcl,v 1.2 2002/04/05 20:35:27 issever Exp $

# ==========================================================
# TExitList
#
# --- This class is a container for all the exits of one
#     room.
#
# ==========================================================

class TExitList {
    # ======================================================
    # === privates
    # ======================================================
    private {
	# --------------------------------------------------
	variable _exitList
	# This array will hold pointers to exits. The index
	# is one of TExitManager::CDirs
	# --------------------------------------------------
    }

    # ======================================================
    # === public
    # ======================================================

    # ------------------------------------------------------
    # --- con- & destructor
    # ------------------------------------------------------
    constructor {args} {}
    destructor {}

    # ------------------------------------------------------
    # --- streamers
    # ------------------------------------------------------
    method streamout {}
    # This returns a string, which will contain all 
    # information of all exits so the exit list can be build
    # up again by using this string.
    # ------------------------------------------------------
    method streamin {arg}
    # This proc gets the string from the proc above,
    # creates all exits as before and puts them into its 
    # list.
    # ------------------------------------------------------

    # ------------------------------------------------------
    # --- setters/getters/testers
    # ------------------------------------------------------
    method = {source} 
    # This proc works only for empty exitlists correctly!
    # It will copy each exit in source into this list, so
    # both lists are equal. Each exits is newly created.
    # ------------------------------------------------------
    method add {aExit}
    # This proc will create another exit exactly as aExit
    # and add it to the list. 
    # This proc is safe in the sense, that an probably 
    # existing exit will be deleted before.
    # ------------------------------------------------------
    method rem {aPos} 
    # This proc deletes the exit object at the position
    # aPos. 
    # This is a safe proc, as it will not dump, if the exit
    # aPos does not exist.
    # ------------------------------------------------------
    method remAll {} 
    # This proc will delete all exit objects in the list.
    # ------------------------------------------------------
    method getPoss {}
    # Returns a list of indices of exits in the list.
    # ------------------------------------------------------
    method getExit {aPos}
    # Returns the object pointer to the exit at the 
    # requested position.
    # This proc is not failsave, as it is not checked, if
    # the exits really exists.
    # ------------------------------------------------------
    method getAllExits {} 
    # Returns a list of all the object pointers of all the
    # exits in the list.
    # ------------------------------------------------------
    method getPosOfExitWithCommand {aCom} 
    # Returns the pos/indices of the *first* found exit,
    # whose command is aCom.
    # ------------------------------------------------------
    method exists {aPos}
    # Returns 0 or 1. This is a test, if an exit at the 
    # position aPos exits.
    # ------------------------------------------------------
}

# ==========================================================
# === TExitList
# ==========================================================

# ----------------------------------------------------------
# --- con- & destructor
# ----------------------------------------------------------
body TExitList::constructor {args} {
    switch [llength $args] {
 	0 {		
 	}
 	1 {
 	    TExitList::= $args
 	}
 	default {
 	    error "Wrong numer of arguments to constructor!"
 	}
	
    }	
}
body TExitList::destructor {} {
    foreach pos [TExitList::getPoss] {
 	::delete object [TExitList::getExit $pos]
    }	
}


# ----------------------------------------------------------
# --- streamers
# ----------------------------------------------------------
body TExitList::streamout {} {
    set il [list]
    foreach pos [TExitList::getPoss] {
	lappend il [[getExit $pos] streamout]
    }
    return $il
}
body TExitList::streamin {arg} {
    foreach exs $arg {
	set dummy [TExit ::\#auto]
	$dummy streamin $exs
	TExitList::add $dummy
	::delete object $dummy
    }
}


# ----------------------------------------------------------
# --- setters and getters
# ----------------------------------------------------------
body TExitList::add {aExit} {
    set dir [$aExit getDir]
    TExitList::rem $dir
    set _exitList($dir) [TExit ::TExitListExit\#auto $aExit]
}
body TExitList::rem {aPos} {
    if {[info exists _exitList($aPos)]} {
 	::delete object $_exitList($aPos)
 	unset _exitList($aPos)
    }	
}
body TExitList::remAll {} {
    foreach pos [getPoss] {
 	::delete object $_exitList($pos)
 	unset _exitList($pos)
    }	
}
body TExitList::exists {aPos} {
    return [info exists _exitList($aPos)]
}
body TExitList::getPoss {} {
    return [array names _exitList]
}
body TExitList::getExit {aPos} {
    return $_exitList($aPos)
}

body TExitList::= {source} {
    foreach pos [$source TExitList::getPoss] {
 	TExitList::add [$source getExit $pos]
    }
}
body TExitList::getAllExits {} {
    set retval [list]
    foreach pos [TExitList::getPoss] {
	lappend retval [getExit $pos]
    }
    return $retval
}
body TExitList::getPosOfExitWithCommand {aCom} {
    set retpos ""
    foreach pos [TExitList::getPoss] {
	set ex [TExitList::getExit $pos]
	if {![string compare [$ex getCommand] $aCom]} {
	    set retpos $pos
	    break
	}
    }
    return $retpos
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TExitList.tcl,v $
# Revision 1.2  2002/04/05 20:35:27  issever
# splited the file TExit.tcl
# removed a small bug
#


