# $Id: TExitListUif.tcl,v 1.1 2002/04/05 20:37:13 issever Exp $

# ==========================================================
# TExitListUif
#
# --- This class is a TExitList and a GUI. The GUI is being
#     used in the ZIF.
#
# ==========================================================

# ==========================================================
# === TExitListUif
# ==========================================================

class TExitListUif {
    inherit itk::Widget

    variable CParent
    variable CMapM
    variable CSelector

    private variable CBGColor     "\#daceaf"
    private variable CBGDarkColor "\#a97"

    method getMapM {} { return $CMapM }

    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }
    constructor {aParent aMapM aIMM args} {
	TExitList::constructor
    } {
	# parent is a roomuif	
	set wid $itk_interior.f
	set CMapM $aMapM
	set CIMM $aIMM
	regsub -- {^::} $aParent {} CParent	

	itk_component add mainframe {frame $wid -relief ridge -bd 2 } {keep -background}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	###################################################################################
	# buttons
	foreach ns {n c s} {
	    itk_component   add bf$ns {frame $itk_component(mainframe).$ns -relief flat -bd 0} {usual}

	    pack $itk_component(bf$ns) -fill both -expand true -side top

	    foreach we {w c e} {
		switch $ns$we {
		    cc {
			itk_component   add ccf {frame $itk_component(bf$ns).$we -relief flat -bd 0} {usual}
			pack $itk_component(ccf) -fill both -expand true -side left

			foreach ud {u d} {
			    itk_component   add udf$ud {frame $itk_component(ccf).$ud -relief flat -bd 0} {usual}
			    pack $itk_component(udf$ud) -fill both -expand true -side top

			    foreach ox {o x} {
				itk_component   add $ud$ox {
				    button $itk_component(udf$ud).$ox -width 4 -text "" -font small \
					-command "[code $this useExit $ud$ox]"
				} { usual ; ignore -font ; keep -foreground }
				pack $itk_component($ud$ox) -fill both -expand true -side left 
				bind $itk_component($ud$ox) <<ZIFExtended>>       "[code $this launchUIF $ud$ox]"
				bind $itk_component($ud$ox) <<ZIFShortcut>>       "[code $this shortCutAction $ud$ox]"

				rem $ud$ox
			    }
			}
		    }
		    default {
			itk_component   add $ns$we {
			    button $itk_component(bf$ns).$we -width 5 -text "" -font small \
				-command "[code $this useExit $ns$we]"
			} { usual ; ignore -font ; keep -foreground }
			pack $itk_component($ns$we) -fill x -expand 1 -side left
			bind $itk_component($ns$we) <<ZIFExtended>>        "[code $this launchUIF $ns$we]"
			bind $itk_component($ns$we) <<ZIFShortcut>>        "[code $this shortCutAction $ns$we]"

			rem $ns$we
		    }
		}
	    }
	}
	
	set CSelector $itk_interior.selector
	itk_component add selec {
	    TExitSelector $CSelector $this $CIMM \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {
	    keep -foreground
	    keep -background
	}

	eval itk_initialize $args
    }

    method clearUif {} {
	foreach pos $TExitManager::CDirs {
	    rem $pos
	}
    }
    method setUif {aRoom} {
	clearUif
	$CParent TExitList::= $aRoom
	foreach expos [$aRoom TExitList::getPoss] {
	    $itk_component($expos) configure -text [[$aRoom TExitList::getExit $expos] getCommand]
	}
    }

    method launchUIF {aPos} {
	if {![$CParent mayEdit]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	$CSelector setActPos $aPos $CParent
	$CSelector activate 
    }
    method add {ex} {
	$CParent changed
	$CParent createTheRoom
	$CParent TExitList::add $ex
	$itk_component([$ex getDir]) configure -text [$ex getCommand]
    }
    method setExitCommand {aPos aCom} {
	[getExit $aPos] setCommand $aCom
	$itk_component($aPos) configure -text $aCom
    }
    method rem {aPos} {
	$CParent changed
	$CParent TExitList::rem $aPos
	$itk_component($aPos) configure -text ""
    }
    method exists {aPos} {
	return [$CParent TExitList::exists $aPos]
    }
    method getExit {aPos} {
	return [$CParent TExitList::getExit $aPos]
    }
    method useExit {aPos} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	#Pass it to the mapmanager
	$CMapM useExit $aPos
    }
    method shortCutAction {aPos} {
	if {![$CParent mayEdit]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	if {[exists $aPos]} {
	    switch -regexp -- $aPos {
		n[we] {
		    if {[string match "north*" [[getExit $aPos] getCommand]]} {
			setExitCommand $aPos "up"
		    } else {
			rem $aPos
		    }
		}
		s[we] {
		    if {[string match "south*" [[getExit $aPos] getCommand]]} {
			setExitCommand $aPos "down"
		    } else {
			rem $aPos
		    }
		}
		default {
		    rem $aPos
		}
	    }
	} else {
	    # create an exit
	    set cc [TCoordinate ::\#auto [$CMapM getActCoord]]
	    $cc move $aPos
	    set cd [TCoordinate ::\#auto $cc]	
	    set actmap [$CMapM getActMap]
	    set mapn   [$actmap name]
	    set mapl   [$actmap level]

	    switch -regexp -- $aPos {
		d[ox] {
		    incr mapl -1
		}		
		u[ox] {
		    incr mapl +1
		}		
		default {
		    set mapn ""
		    set mapl ""
		}
	    }

	    set ex [TExit ::\#auto $aPos $mapn $mapl $cc $cd [TExitManager::qECom $aPos] 0 "" "" 2 "black"]
	    
	    add $ex
	    ::delete object $ex $cc $cd
	}
    }
    method = {source} {
	foreach pos [$source TExitList::getPoss] {
	    add [$source getExit $pos]
	}
    }


}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TExitListUif.tcl,v $
# Revision 1.1  2002/04/05 20:37:13  issever
# splitted Texit.tcl
#
