# $Id: TExitManager.tcl,v 1.2 2002/04/05 20:35:27 issever Exp $

# ==========================================================
# TExitManager
#
# --- This class will have only one instance and is needed
#     to provide the default behaviour of exits -- mainly
#     regarding to drawing.
#
# --- This class would also be good suited to take other
#     defaults like exit command names e.g.
#
# ==========================================================

class TExitManager {
    # ======================================================
    # === privates
    # ======================================================
    private {
	# --------------------------------------------------
	variable _IM
	# pointer to the image manager.
	# --------------------------------------------------
    }

    # ======================================================
    # === public
    # ======================================================
    public {
	# --------------------------------------------------
	common   CDirs
	# List of all possible exit indices
	# --------------------------------------------------
	common   CNoDir
	# index/id for a not exisiting position. This
	# information will primarily used to indicate, that 
	# an exit is pointing to the center of the 
	# destination room.
	# --------------------------------------------------
	common   CGrid 
	# Gridsize, which is going to be used for drawing 
	# the exits.
	# --------------------------------------------------
	common   CDirConP
	# Precalculated connection points, which are needed
	# for drawing. CGrid is used for this calculation.
	# --------------------------------------------------
	common   CImage
	# Stores pointers to the image objects for the four
	# special exits.
	# --------------------------------------------------
    }

    # ------------------------------------------------------
    # --- constructor
    # ------------------------------------------------------
    proc qECom {aPos}
    # This proc returns a default command for an exit at
    # the position aPos; e.g. northeast for ne
    # ------------------------------------------------------

    # ------------------------------------------------------
    # --- constructor
    # ------------------------------------------------------
    constructor {aGrid aIM} {}
}

# ==========================================================
# === TExitManager
# ==========================================================

# ----------------------------------------------------------
# --- constructor
# ----------------------------------------------------------
body TExitManager::constructor {aGrid aIM} {
    set CGrid $aGrid
    set _IM   $aIM

    set CDirs  "nw nc ne cw ce sw sc se uo ux do dx"
    set CNoDir "cc"

    set CDirConP(nw,x) [expr { -0.5*$CGrid }]
    set CDirConP(nc,x) [expr {  0          }]
    set CDirConP(ne,x) [expr {  0.5*$CGrid }]
    set CDirConP(nw,y) [expr { -0.5*$CGrid }]
    set CDirConP(nc,y) [expr { -0.5*$CGrid }]
    set CDirConP(ne,y) [expr { -0.5*$CGrid }]
    set CDirConP(cw,x) [expr { -0.5*$CGrid }]
    set CDirConP(cc,x) [expr {  0          }]
    set CDirConP(ce,x) [expr {  0.5*$CGrid }]
    set CDirConP(cw,y) [expr {  0          }]
    set CDirConP(cc,y) [expr {  0          }]
    set CDirConP(ce,y) [expr {  0          }]
    set CDirConP(sw,x) [expr { -0.5*$CGrid }]
    set CDirConP(sc,x) [expr {  0          }]
    set CDirConP(se,x) [expr {  0.5*$CGrid }]
    set CDirConP(sw,y) [expr {  0.5*$CGrid }]
    set CDirConP(sc,y) [expr {  0.5*$CGrid }]
    set CDirConP(se,y) [expr {  0.5*$CGrid }]
    
    set CDirConP(uo,x) -8
    set CDirConP(uo,y) -8
    set CDirConP(do,x) -8
    set CDirConP(do,y)  8
    set CDirConP(ux,x)  8
    set CDirConP(ux,y) -8
    set CDirConP(dx,x)  8
    set CDirConP(dx,y)  8

    foreach pos {uo do ux dx} {
	set CImage($pos) [$_IM getImage system exits $pos]
    }
    
}

body TExitManager::qECom {aPos} {
    switch -regexp -- $aPos {
	nw { return northwest }
	nc { return north }
	ne { return northeast }
	cw { return west }
	ce { return east }
	sw { return southwest }
	sc { return south }
	se { return southeast }
	do { return down }
	dx { return down }
	uo { return up }
	ux { return up }
	default  { return "" }
    }
}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TExitManager.tcl,v $
# Revision 1.2  2002/04/05 20:35:27  issever
# splited the file TExit.tcl
# removed a small bug
#
