# $Id: TExitSelector.tcl,v 1.3 2002/04/16 21:53:30 issever Exp $

# ==========================================================
# TExitSelector
#
# --- This class is the GUI for an exit. It will pop up the
#     dialog, with which the exit can be configured in 
#     detail.
#
# ==========================================================

class TExitSelector {
    inherit iwidgets::Shell

    variable CParent
    variable CActPos
    variable CIMM

    method setActPos {aPos aActCoord} {
	global TV
	set CActPos $aPos
	configure -title "Configure Exit: $CActPos"
	configure -modality application

	if {[$CParent exists $aPos]} {
	    set ex [$CParent getExit $aPos]	    
	    set TV($this,command)    [$ex getCommand]
	    set TV($this,map)        [$ex getMap]
	    set TV($this,mapl)       [$ex getMapLevel]
	    set TV($this,door)       [$ex getDoor]
	    set TV($this,doorOpen)   [$ex getDoorOpen]
	    set TV($this,doorClose)  [$ex getDoorClose]
	    $itk_component(conxy)  = [$ex getConnectTo]
	    $itk_component(drawxy) = [$ex getDrawTo]
	    set TV($this,color)      [$ex getConColor]
	    $itk_component(thick) delete 0 end
	    $itk_component(thick) insert 0 [$ex getConThickness]
	} else {
	    set TV($this,command)    [::TExitManager::qECom $aPos]
	    set TV($this,map)        ""
	    set TV($this,mapl)       ""
	    set TV($this,door)       0
	    set TV($this,doorOpen)   ""
	    set TV($this,doorClose)  ""
	    set TV($this,color)      "black"
	    $itk_component(conxy)    = $aActCoord
	    $itk_component(conxy)    move $aPos
	    $itk_component(drawxy)   = $itk_component(conxy)  
	    $itk_component(thick) delete 0 end
	    $itk_component(thick) insert 0 2
	}
    }
    method doorWasToggled {} {
	global TV
	if {$TV($this,door)} {
	    if {[string match "" $TV($this,doorOpen)]} {
	    	set cmd door
	    	set rcmd door
		set tcmd $TV($this,command)
		set end [expr [string length $tcmd] - 1]
		if {[regexp {^n(o(r(t(h(e(a(st?)?)?)?)?)?)?)?$} $tcmd]} {
			set cmd $tcmd
			set rcmd [string range southwest 0 $end]
		}
		if {[string match ne $tcmd]} {
			set cmd $tcmd
			set rcmd sw
		}
		if {[regexp {^northw(e(st?)?)?$} $tcmd]} {
			set cmd $tcmd
			set rcmd [string range southeast 0 $end]
		}
		if {[string match nw $tcmd]} {
			set cmd $tcmd
			set rcmd se
		}
		if {[regexp {^s(o(u(t(h(e(a(st?)?)?)?)?)?)?)?$} $tcmd]} {
			set cmd $tcmd
			set rcmd [string range northwest 0 $end]
		}
		if {[string match se $tcmd]} {
			set cmd $tcmd
			set rcmd nw
		}
		if {[regexp {^southw(e(st?)?)?$} $tcmd]} {
			set cmd $tcmd
			set rcmd [string range northeast 0 $end]
		}
		if {[string match sw $tcmd]} {
			set cmd $tcmd
			set rcmd ne
		}
		if {[regexp {^e(a(st?)?)?$}     $tcmd]} {
			set cmd $tcmd
			set rcmd [string range west  0 $end]
		}
		if {[regexp {^w(e(st?)?)?$}     $tcmd]} {
			set cmd $tcmd
			set rcmd [string range east  0 $end]
		}
		if {[regexp {^up?$}             $tcmd]} {
			set cmd $tcmd
			if {$end} {
				set rcmd down
			} {
				set rcmd d
			}
		}
		if {[regexp {^d(o(wn?)?)?$}     $tcmd]} {
			set cmd $tcmd
			set rcmd [string range up    0 $end]
		}
	 	set TV($this,doorOpen)  "open $cmd"
	 	set TV($this,doorClose) "close $rcmd"
	    }
	}
    }
    constructor {aParent aIMM args} {
	# parent is an ExitListUif
	global TV
	set CIMM $aIMM
	set CActPos ""
	set CMapped 0

	regsub -- {^::} $aParent {} CParent

	set wid [$this childsite]
	$wid configure -relief ridge -bd 0

	#########################################################################
	# create buttons
	itk_component add   butframe {frame $wid.butframe -relief ridge -bd 2 } {keep -background}
	pack $itk_component(butframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add   ok {
	    button $itk_component(butframe).ok -width 10 -text "OK" -command "[code $this OK]"
	} {keep -background;keep -foreground}
	itk_component add   rem {
	    button $itk_component(butframe).rem -width 10 -text "remove" -command "[code $this remove]"
	} {keep -background;keep -foreground}
	itk_component add   canc {
	    button $itk_component(butframe).canc -width 10 -text "cancel" -command "[code $this canc]"
	} {keep -background;keep -foreground}
	pack $itk_component(ok) $itk_component(rem) $itk_component(canc) \
	    -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left


	###########################################################################
	# create the rest
	itk_component add rframe {frame $wid.r -relief ridge -bd 2 } {keep -background}
	pack $itk_component(rframe) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	# command
	itk_component   add comf { frame $itk_component(rframe).comf -relief ridge -borderwidth 2 } {usual}
	pack $itk_component(comf) -fill both -expand 1 -side top -anchor nw
	itk_component   add command {iwidgets::entryfield $itk_component(comf).com \
					 -labeltext "command: " \
					 -width 4 -textfont def \
					 -labelmargin 0 -textvariable TV($this,command)
	} {keep -background;keep -foreground}
	pack $itk_component(command) -fill both -expand 1 -side top -anchor nw
	#map
	itk_component   add mapf { frame $itk_component(rframe).mapf -relief ridge -borderwidth 2 } {usual}
	pack $itk_component(mapf) -fill both -expand 1 -side top -anchor nw
	itk_component   add map {iwidgets::entryfield $itk_component(mapf).map \
				     -labeltext "map: " \
				     -width 12 -textfont def -labelfont def \
				     -labelmargin 0 -textvariable TV($this,map)
	} {keep -background;keep -foreground}
	itk_component   add mapl {iwidgets::entryfield $itk_component(mapf).mapl \
				      -width 3 -textfont def -labelfont def \
				      -validate integer \
				      -labelmargin 0 -textvariable TV($this,mapl)
	} {keep -background;keep -foreground}
	pack $itk_component(map) $itk_component(mapl) -fill both -expand 1 -side left -anchor nw
	iwidgets::Labeledwidget::alignlabels $itk_component(command) $itk_component(map)

	# door
	itk_component   add doorf { frame $itk_component(rframe).doorf -relief ridge -borderwidth 2 } {usual}
	pack $itk_component(doorf) -fill x -expand 1 -side top -anchor nw
	itk_component   add doorcheck {
	    checkbutton $itk_component(doorf).door -text door \
		-relief flat -justify left -anchor nw -font def \
		-variable TV($this,door) -command "[code $this doorWasToggled]"
	} {usual; ignore -font}
	itk_component   add dooropen {iwidgets::entryfield $itk_component(doorf).open \
					  -labeltext "open:" -width 3 -labelfont def \
					  -textfont def -labelmargin 0 \
					  -textvariable TV($this,doorOpen)
	} {keep -background;keep -foreground}
	itk_component   add doorclose {iwidgets::entryfield $itk_component(doorf).close \
					   -labeltext "close:" -width 3 -labelfont def \
					   -textfont def -labelmargin 0 \
					   -textvariable TV($this,doorClose)
	} {keep -background;keep -foreground}
	iwidgets::Labeledwidget::alignlabels $itk_component(dooropen) $itk_component(doorclose)

	pack $itk_component(doorcheck) $itk_component(dooropen) $itk_component(doorclose) \
	    -fill x -expand 1 -side top -anchor nw -padx 0 -pady 0 -ipadx 0 -ipady 0

	######## con/draw
	itk_component   add cond { 
	    frame $itk_component(rframe).cond -relief ridge -borderwidth 2 
	} {usual}
	pack $itk_component(cond) -fill x -expand 1 -side top -anchor nw
	###### con
	itk_component   add con   { frame $itk_component(cond).con -relief flat -borderwidth 0 } {usual}
	pack $itk_component(con)   -fill both -expand 1 -side top -anchor nw
	itk_component   add conxy { 
	    TCoordinateUif $itk_component(con).xy -orient h -xtext   "Connect x: " 
	} {
	    keep -foreground
	    keep -background
	}
	itk_component   add conc  { 
	    button $itk_component(con).conc -image [$CIMM getImage system buttons click] \
		-command [code $this clickCon]		
	} {keep -background;keep -foreground}
	itk_component   add conr  { 
	    button $itk_component(con).conr -image [$CIMM getImage system buttons cut] \
		-command [code $this remCon]
	} {keep -background;keep -foreground}
	pack $itk_component(conxy) $itk_component(conc) $itk_component(conr) \
	    -fill both -expand 1 -side left -anchor nw
	###### draw
	itk_component   add draw   { frame $itk_component(cond).draw -relief flat -borderwidth 0 } {usual}
	pack $itk_component(draw)  -fill both -expand 1 -side top -anchor nw
	itk_component   add drawxy { 
	    TCoordinateUif $itk_component(draw).xy -orient h -xtext "Draw    x: " 
	} {
	    keep -background
	    keep -foreground
	}
	itk_component   add drawc  { 
	    button $itk_component(draw).drawc -image [$CIMM getImage system buttons click] \
		-command [code $this clickDraw]		
	} {keep -background;keep -foreground}
	itk_component   add drawr  { 
	    button $itk_component(draw).drawr -image [$CIMM getImage system buttons cut] \
		-command [code $this remDraw]
	} {keep -background;keep -foreground}
	pack $itk_component(drawxy) $itk_component(drawc) $itk_component(drawr) \
	    -fill both -expand 1 -side left -anchor nw
	###### color/thickness
	itk_component   add colort   { frame $itk_component(cond).colort -relief flat -borderwidth 0 } {usual}
	pack $itk_component(colort)  -fill both -expand 1 -side top -anchor nw

	itk_component   add thick { 
	    iwidgets::spinint $itk_component(colort).thick \
		-labeltext "Thickness: " -range {0 64} -width 3 -arroworient horizontal
	} {keep -background;keep -foreground}

	itk_component   add color { 
	    iwidgets::combobox $itk_component(colort).color \
		-editable 0 -width 10 -textvariable TV($this,color) -labeltext "Color: "
	} {keep -background;keep -foreground}
	$itk_component(color) insert list end \
	   black red green blue "bg def" "bg dark" white yellow magenta cyan 
 	pack $itk_component(thick) $itk_component(color) -fill both -expand 1 -side left -anchor nw


	eval itk_initialize $args
    }
    method remCon  {} { 
	$itk_component(conxy) setNull 
	remDraw
    }
    method remDraw {} { 
	$itk_component(drawxy) setNull 
    }
    method clickCon {} {
	$this deactivate
	[$CParent getMapM] clickCon $this
    }
    method clickConClick {x y mapname maplevel} {	
	global TV
	if {$maplevel == 0} { set maplevel "" }
	if {![string compare "" $mapname]} { set maplevel "" }
	set TV($this,map)        $mapname
	set TV($this,mapl)       $maplevel	
	$itk_component(conxy) setXY $x $y
	if {![string compare "" $mapname]} {
	    $itk_component(drawxy) setXY $x $y
	}
	$this activate
    }
    method clickDraw {} {
	$this deactivate
	[$CParent getMapM] clickDraw $this
    }
    method clickDrawClick {x y} {
	$itk_component(drawxy) setXY $x $y
	$this activate
    }
    method canc {} { 
	$this deactivate 
    }
    method remove {} {
	$CParent rem $CActPos
	canc
    }
    method OK {} {
	global TV
	if {![string compare $TV($this,command) ""]} {
	    TInformer $itk_interior.mess \
		-information "You have to give a 'command'!\nOtherwise remove the exit."
	    return
	}

	set ex [TExit ::\#auto $CActPos \
		    $TV($this,map) $TV($this,mapl) \
		    $itk_component(conxy) $itk_component(drawxy) \
		    $TV($this,command) \
		    $TV($this,door) $TV($this,doorOpen) $TV($this,doorClose) \
		    [$itk_component(thick) get] $TV($this,color) ]
	$CParent add $ex
	::delete object $ex

	canc
    }
}


# ==========================================================
# === TExitSelector
# ==========================================================








# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TExitSelector.tcl,v $
# Revision 1.3  2002/04/16 21:53:30  issever
# changed default select color
#
# Revision 1.2  2002/04/08 22:43:56  moth
# Use reasonable default when editting a freshly allocated exit.
#
# Revision 1.1  2002/04/05 20:37:13  issever
# splitted Texit.tcl
#
